/*
 * Decompiled with CFR 0.152.
 */
package net.adriantodt.winged.data.impl;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.adriantodt.winged.data.WingedConfig;
import net.adriantodt.winged.data.WingedData;
import net.adriantodt.winged.data.impl.BoosterDataImpl;
import net.adriantodt.winged.data.impl.BoosterVelocityImpl;
import net.adriantodt.winged.data.impl.FuelPelletDataImpl;
import net.adriantodt.winged.data.impl.WingedDataImpl;
import net.adriantodt.winged.data.impl.WingedDataImpl$WhenMappings;
import net.adriantodt.winged.item.ActiveBoosterItem;
import net.adriantodt.winged.item.BoosterItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0014\u0010\u001b\u001a\u00020\u001e*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lnet/adriantodt/winged/data/impl/WingedDataImpl;", "Lnet/adriantodt/winged/data/WingedData;", "config", "Lnet/adriantodt/winged/data/WingedConfig;", "(Lnet/adriantodt/winged/data/WingedConfig;)V", "boosterMap", "", "Lnet/adriantodt/winged/data/WingedData$BoosterType;", "Lnet/adriantodt/winged/data/impl/BoosterDataImpl;", "fuelPelletMap", "Lnet/adriantodt/winged/data/impl/FuelPelletDataImpl;", "heartOfTheSkyItemTicksPerDamage", "", "getHeartOfTheSkyItemTicksPerDamage", "()I", "setHeartOfTheSkyItemTicksPerDamage", "(I)V", "launcherVelocity", "Lnet/adriantodt/winged/data/impl/BoosterVelocityImpl;", "getLauncherVelocity", "()Lnet/adriantodt/winged/data/impl/BoosterVelocityImpl;", "removeWingsDamage", "", "getRemoveWingsDamage", "()F", "setRemoveWingsDamage", "(F)V", "booster", "type", "fuelPellet", "Lnet/adriantodt/winged/data/WingedConfig$BoosterValues;", "winged"})
public final class WingedDataImpl
implements WingedData {
    @NotNull
    private final BoosterVelocityImpl launcherVelocity;
    private float removeWingsDamage;
    private int heartOfTheSkyItemTicksPerDamage;
    private final Map<WingedData.BoosterType, FuelPelletDataImpl> fuelPelletMap;
    private final Map<WingedData.BoosterType, BoosterDataImpl> boosterMap;

    @Override
    @NotNull
    public BoosterVelocityImpl getLauncherVelocity() {
        return this.launcherVelocity;
    }

    @Override
    public float getRemoveWingsDamage() {
        return this.removeWingsDamage;
    }

    @Override
    public void setRemoveWingsDamage(float f) {
        this.removeWingsDamage = f;
    }

    @Override
    public int getHeartOfTheSkyItemTicksPerDamage() {
        return this.heartOfTheSkyItemTicksPerDamage;
    }

    @Override
    public void setHeartOfTheSkyItemTicksPerDamage(int n) {
        this.heartOfTheSkyItemTicksPerDamage = n;
    }

    @Override
    @NotNull
    public BoosterDataImpl booster(@NotNull WingedData.BoosterType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        BoosterDataImpl boosterDataImpl = this.boosterMap.get((Object)type);
        if (boosterDataImpl == null) {
            String string = "Impossible.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return boosterDataImpl;
    }

    @Override
    @NotNull
    public FuelPelletDataImpl fuelPellet(@NotNull WingedData.BoosterType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        FuelPelletDataImpl fuelPelletDataImpl = this.fuelPelletMap.get((Object)type);
        if (fuelPelletDataImpl == null) {
            String string = "Impossible.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return fuelPelletDataImpl;
    }

    private final WingedConfig.BoosterValues booster(@NotNull WingedData.BoosterType $this$booster, WingedConfig config) {
        WingedConfig.BoosterValues boosterValues;
        switch (WingedDataImpl$WhenMappings.$EnumSwitchMapping$0[$this$booster.ordinal()]) {
            case 1: {
                boosterValues = config.getBoosters().getStandardBooster();
                break;
            }
            case 2: {
                boosterValues = config.getBoosters().getFastBooster();
                break;
            }
            case 3: {
                boosterValues = config.getBoosters().getSlowBooster();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return boosterValues;
    }

    public WingedDataImpl(@NotNull WingedConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.launcherVelocity = new BoosterVelocityImpl(config.getBoosters().getForwardLauncher());
        this.removeWingsDamage = config.getRemoveWingsDamage();
        this.heartOfTheSkyItemTicksPerDamage = config.getHeartOfTheSkyItemTicksPerDamage();
        this.fuelPelletMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)WingedData.BoosterType.STANDARD), (Object)new FuelPelletDataImpl(3, 0, 0, (Function0<BoosterItem>)((Function0)fuelPelletMap.1.INSTANCE))), TuplesKt.to((Object)((Object)WingedData.BoosterType.FAST), (Object)new FuelPelletDataImpl(2, 1, 0, (Function0<BoosterItem>)((Function0)fuelPelletMap.2.INSTANCE))), TuplesKt.to((Object)((Object)WingedData.BoosterType.SLOW), (Object)new FuelPelletDataImpl(2, 0, 1, (Function0<BoosterItem>)((Function0)fuelPelletMap.3.INSTANCE)))});
        this.boosterMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)WingedData.BoosterType.STANDARD), (Object)new BoosterDataImpl(this.booster(WingedData.BoosterType.STANDARD, config), (Function0<BoosterItem>)((Function0)boosterMap.1.INSTANCE), (Function0<ActiveBoosterItem>)((Function0)boosterMap.2.INSTANCE))), TuplesKt.to((Object)((Object)WingedData.BoosterType.SLOW), (Object)new BoosterDataImpl(this.booster(WingedData.BoosterType.SLOW, config), (Function0<BoosterItem>)((Function0)boosterMap.3.INSTANCE), (Function0<ActiveBoosterItem>)((Function0)boosterMap.4.INSTANCE))), TuplesKt.to((Object)((Object)WingedData.BoosterType.FAST), (Object)new BoosterDataImpl(this.booster(WingedData.BoosterType.FAST, config), (Function0<BoosterItem>)((Function0)boosterMap.5.INSTANCE), (Function0<ActiveBoosterItem>)((Function0)boosterMap.6.INSTANCE)))});
    }
}

