/*
 * Decompiled with CFR 0.152.
 */
package feon.wirelessredstone.objects.blocks;

import feon.wirelessredstone.init.ModTileEntityTypes;
import feon.wirelessredstone.objects.items.LinkerItem;
import feon.wirelessredstone.tileentity.RedstoneTransmitterTileEntity;
import feon.wirelessredstone.world.RedstoneNetwork;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RedstoneTransmitter
extends HorizontalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public RedstoneTransmitter(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return RedstoneTransmitter.func_220064_c((IBlockReader)worldIn, (BlockPos)pos.func_177977_b());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity entity;
        if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof RedstoneTransmitterTileEntity) {
            RedstoneTransmitterTileEntity transmitterTileEntity = (RedstoneTransmitterTileEntity)entity;
            Integer transmitterFrequency = transmitterTileEntity.getFrequency();
            ItemStack stack = player.func_184586_b(handIn);
            if (stack.func_190926_b() && handIn == Hand.MAIN_HAND) {
                String message = "Transmitter frequency: " + transmitterFrequency + ".";
                if (transmitterFrequency == null) {
                    message = "Frequency not set";
                }
                player.func_146105_b((ITextComponent)new StringTextComponent(message), false);
            }
            if (stack.func_77973_b() instanceof LinkerItem) {
                String message;
                LinkerItem linker = (LinkerItem)stack.func_77973_b();
                Integer linkerFrequency = linker.getFrequency(stack);
                if (linkerFrequency == null) {
                    if (transmitterFrequency == null) {
                        RedstoneNetwork network = RedstoneNetwork.getNetwork(worldIn);
                        int newFrequency = network.getNewFrequency();
                        network.save();
                        linker.setFrequency(stack, newFrequency);
                        transmitterTileEntity.setFrequency(newFrequency);
                        message = "Transmitter and Linker set to frequency " + newFrequency + ".";
                    } else {
                        linker.setFrequency(stack, transmitterFrequency);
                        message = "Linker set to frequency " + transmitterFrequency + ".";
                    }
                } else {
                    transmitterTileEntity.setFrequency(linkerFrequency);
                    message = "Transmitter set to frequency " + linkerFrequency + ".";
                }
                player.func_146105_b((ITextComponent)new StringTextComponent(message), false);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntity entity;
        if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof RedstoneTransmitterTileEntity) {
            RedstoneTransmitterTileEntity transmitterTileEntity = (RedstoneTransmitterTileEntity)entity;
            transmitterTileEntity.setPowerLevel(this.getPower(worldIn, pos));
        }
    }

    private int getPower(World worldIn, BlockPos pos) {
        int max = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockState;
            Block block;
            if (direction == Direction.UP) continue;
            int val = worldIn.func_175651_c(pos.func_177972_a(direction), direction);
            if (val < 15 && (block = (blockState = worldIn.func_180495_p(pos.func_177972_a(direction))).func_177230_c()) == Blocks.field_150488_af) {
                val = Math.max(val, (Integer)blockState.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O));
            }
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.REDSTONE_TRANSMITTER.get()).func_200968_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, POWERED});
    }
}

