/*
 * Decompiled with CFR 0.152.
 */
package feon.wirelessredstone.objects.items;

import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class LinkerItem
extends Item {
    private static final String FREQUENCY_KEY = "Frequency";

    public LinkerItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Integer frequency = this.getFrequency(stack);
        String message = frequency == null ? "No frequency set. <Hold shift for usage>" : "Frequency: " + frequency + ". <Hold shift for usage>";
        tooltip.add((ITextComponent)new StringTextComponent(message));
        if (Screen.hasShiftDown()) {
            if (frequency == null) {
                tooltip.add((ITextComponent)new StringTextComponent("Right click on a Redstone Reciever or Transmitter to set the Linker's frequency."));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent("Right click on a Redstone Reciever or Transmitter to set their frequency to " + frequency));
                tooltip.add((ITextComponent)new StringTextComponent("Sneak + Right Click to clear Linker's frequency."));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public Integer getFrequency(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(FREQUENCY_KEY)) {
            return null;
        }
        return tag.func_74762_e(FREQUENCY_KEY);
    }

    public void setFrequency(ItemStack stack, int frequency) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_82580_o(FREQUENCY_KEY);
        tag.func_74768_a(FREQUENCY_KEY, frequency);
    }

    public void clearFrequency(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(FREQUENCY_KEY)) {
            return;
        }
        tag.func_82580_o(FREQUENCY_KEY);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack;
        if (!worldIn.field_72995_K && (stack = playerIn.func_184586_b(handIn)).func_77973_b() instanceof LinkerItem) {
            LinkerItem linker = (LinkerItem)stack.func_77973_b();
            if (playerIn.func_225608_bj_() && linker.getFrequency(stack) != null) {
                linker.clearFrequency(stack);
                playerIn.func_146105_b((ITextComponent)new StringTextComponent("Linker frequency cleared!"), false);
                return ActionResult.func_226248_a_((Object)stack);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

