/*
 * Decompiled with CFR 0.152.
 */
package feon.wirelessredstone.tileentity;

import feon.wirelessredstone.init.ModTileEntityTypes;
import feon.wirelessredstone.objects.blocks.RedstoneReceiver;
import feon.wirelessredstone.world.RedstoneNetwork;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class RedstoneReceiverTileEntity
extends TileEntity
implements ITickableTileEntity {
    protected int frequency = -1;
    protected int powerLevel = 0;
    private static final String POWER_LEVEL_KEY = "powerLevel";
    private static final String FREQUENCY_KEY = "frequency";

    public RedstoneReceiverTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public RedstoneReceiverTileEntity() {
        this((TileEntityType)ModTileEntityTypes.REDSTONE_RECEIVER.get());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int newPower = this.getPowerFromNetwork();
        if (newPower == this.powerLevel) {
            return;
        }
        this.powerLevel = newPower;
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof RedstoneReceiver) {
            state = (BlockState)state.func_206870_a((IProperty)RedstoneReceiver.POWERED, (Comparable)Boolean.valueOf(this.powerLevel > 0));
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
        }
        this.func_70296_d();
        this.func_145831_w().func_195593_d(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c());
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public int getPowerFromNetwork() {
        if (this.frequency == -1) {
            return 0;
        }
        return RedstoneNetwork.getNetwork(this.field_145850_b).getFrequencyValue(this.frequency);
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public Integer getFrequency() {
        return this.frequency == -1 ? null : Integer.valueOf(this.frequency);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.powerLevel = compound.func_74762_e(POWER_LEVEL_KEY);
        this.frequency = compound.func_74762_e(FREQUENCY_KEY);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a(FREQUENCY_KEY, this.frequency);
        compound.func_74768_a(POWER_LEVEL_KEY, this.powerLevel);
        return super.func_189515_b(compound);
    }
}

