/*
 * Decompiled with CFR 0.152.
 */
package feon.wirelessredstone.tileentity;

import feon.wirelessredstone.init.ModTileEntityTypes;
import feon.wirelessredstone.objects.blocks.RedstoneTransmitter;
import feon.wirelessredstone.world.RedstoneNetwork;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class RedstoneTransmitterTileEntity
extends TileEntity {
    protected int frequency = -1;
    protected int powerLevel = 0;
    private static final String POWER_LEVEL_KEY = "powerLevel";
    private static final String FREQUENCY_KEY = "frequency";

    public RedstoneTransmitterTileEntity() {
        super((TileEntityType)ModTileEntityTypes.REDSTONE_TRANSMITTER.get());
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public Integer getFrequency() {
        return this.frequency == -1 ? null : Integer.valueOf(this.frequency);
    }

    public void setPowerLevel(int power) {
        if (this.frequency == -1 || this.powerLevel == power) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof RedstoneTransmitter) {
            state = (BlockState)state.func_206870_a((IProperty)RedstoneTransmitter.POWERED, (Comparable)Boolean.valueOf(power > 0));
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
        }
        this.powerLevel = power;
        RedstoneNetwork network = RedstoneNetwork.getNetwork(this.field_145850_b);
        network.setFrequencyValue(this.frequency, this.powerLevel);
        network.save();
    }

    public int getPowerFromNetwork() {
        if (this.frequency == -1) {
            this.powerLevel = 0;
            return this.powerLevel;
        }
        this.powerLevel = RedstoneNetwork.getNetwork(this.field_145850_b).getFrequencyValue(this.frequency);
        return this.powerLevel;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.powerLevel = compound.func_74762_e(POWER_LEVEL_KEY);
        this.frequency = compound.func_74762_e(FREQUENCY_KEY);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a(FREQUENCY_KEY, this.frequency);
        compound.func_74768_a(POWER_LEVEL_KEY, this.powerLevel);
        return super.func_189515_b(compound);
    }
}

