/*
 * Decompiled with CFR 0.152.
 */
package feon.wirelessredstone.world;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class RedstoneNetwork
extends WorldSavedData {
    private static final String REDSTONE_NETWORK_NAME = "RedstoneNetwork";
    private static final String REDSTONE_NETWORK_FREQUENCY_LIST_KEY = "redstoneNetworkFrequencies";
    private static final String REDSTONE_NETWORK_MAX_ID_KEY = "redstoneNetworkMaxId";
    private static final String REDSTONE_NETWORK_FREQUENCY_KEY = "frequency";
    private static final String REDSTONE_NETWORK_VALUE_KEY = "value";
    private final Map<Integer, Integer> frequencies = new HashMap<Integer, Integer>();
    private int maxId = 0;

    public RedstoneNetwork(String name) {
        super(name);
    }

    public int getFrequencyValue(int frequency) {
        Integer value = this.frequencies.get(frequency);
        return value == null ? 0 : value;
    }

    public void setFrequencyValue(int frequency, int value) {
        this.frequencies.put(frequency, value);
    }

    public void deleteFrequency(int frequency) {
        this.frequencies.remove(frequency);
    }

    public int getNewFrequency() {
        ++this.maxId;
        return this.maxId;
    }

    public void save() {
        this.func_76185_a();
    }

    public static RedstoneNetwork getNetwork(World world) {
        if (world.field_72995_K) {
            throw new RuntimeException("Don't access this client-side!");
        }
        DimensionSavedDataManager storage = DimensionManager.getWorld((MinecraftServer)world.func_73046_m(), (DimensionType)DimensionType.field_223227_a_, (boolean)false, (boolean)false).func_217481_x();
        return (RedstoneNetwork)storage.func_215752_a(() -> new RedstoneNetwork(REDSTONE_NETWORK_NAME), REDSTONE_NETWORK_NAME);
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.frequencies.clear();
        ListNBT list = nbt.func_150295_c(REDSTONE_NETWORK_FREQUENCY_LIST_KEY, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT item = list.func_150305_b(i);
            int frequency = item.func_74762_e(REDSTONE_NETWORK_FREQUENCY_KEY);
            int value = item.func_74762_e(REDSTONE_NETWORK_VALUE_KEY);
            this.frequencies.put(frequency, value);
        }
        this.maxId = nbt.func_74762_e(REDSTONE_NETWORK_MAX_ID_KEY);
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<Integer, Integer> entry : this.frequencies.entrySet()) {
            CompoundNBT item = new CompoundNBT();
            item.func_74768_a(REDSTONE_NETWORK_FREQUENCY_KEY, entry.getKey().intValue());
            item.func_74768_a(REDSTONE_NETWORK_VALUE_KEY, entry.getValue().intValue());
            list.add((Object)item);
        }
        compound.func_218657_a(REDSTONE_NETWORK_FREQUENCY_LIST_KEY, (INBT)list);
        compound.func_74768_a(REDSTONE_NETWORK_MAX_ID_KEY, this.maxId);
        return compound;
    }
}

