/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.mumfrey.worldeditcui.WorldEditCUI;
import com.mumfrey.worldeditcui.config.CUIConfiguration;
import com.mumfrey.worldeditcui.event.listeners.CUIListenerChannel;
import com.mumfrey.worldeditcui.event.listeners.CUIListenerWorldRender;
import com.mumfrey.worldeditcui.input.KeySetting;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.client.ClientTickCallback;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

public class LiteModWorldEditCUI
implements ModInitializer,
PacketConsumer,
ClientTickCallback {
    public static String path = "";
    private static final String SUB_CHANNEL_WECUI = "cui";
    private static final String CHANNEL_WECUI = "worldedit";
    private WorldEditCUI controller;
    public static LiteModWorldEditCUI instance;
    private class_638 lastWorld;
    private class_1657 lastPlayer;
    private static boolean joinedServer;
    private boolean init = false;
    private KeySetting keyBindToggleUI;
    private KeySetting keyBindClearSel;
    private KeySetting keyBindChunkBorder;
    private KeySetting keyBindLShift;
    private KeySetting keyBindRShift;
    private boolean visible = true;
    private boolean alwaysOnTop = true;
    private CUIListenerWorldRender worldRenderListener;
    private CUIListenerChannel channelListener;
    private boolean registered = false;

    public void init(File configPath) {
        this.init = true;
        instance = this;
        this.keyBindToggleUI = new KeySetting(290, "wecui.keys.toggle");
        this.keyBindClearSel = new KeySetting(291, "wecui.keys.clear");
        this.keyBindChunkBorder = new KeySetting(292, "wecui.keys.chunk");
        this.keyBindLShift = new KeySetting(340, "wecui.keys.control.lshift");
        this.keyBindRShift = new KeySetting(344, "wecui.keys.control.rshift");
    }

    public void upgradeSettings(String version, File configPath, File oldConfigPath) {
    }

    public void onInitCompleted() {
        path = System.getProperty("user.dir");
        path = path + System.getProperty("file.separator") + "mods" + System.getProperty("file.separator") + "";
        class_310 minecraft = class_310.method_1551();
        this.controller = new WorldEditCUI();
        this.controller.initialise(minecraft);
        this.worldRenderListener = new CUIListenerWorldRender(this.controller, minecraft);
        this.channelListener = new CUIListenerChannel(this.controller);
    }

    protected class_2540 getRegistrationData() {
        StringBuilder channelList = new StringBuilder();
        for (String channel : this.getChannels()) {
            channelList.append(channel);
            channelList.append("\u0000");
        }
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeBytes(channelList.toString().getBytes(Charsets.UTF_8));
        return buffer;
    }

    private void register() {
        if (!this.registered) {
            class_2960 id = new class_2960("worldedit:cui");
            ServerSidePacketRegistry.INSTANCE.register(id, (PacketConsumer)this);
            ClientSidePacketRegistry.INSTANCE.register(new class_2960("worldedit:cui"), (PacketConsumer)this);
            this.registered = true;
        }
    }

    public void receiveMessage(String message, String channel) {
        if (channel.trim().equalsIgnoreCase("minecraft")) {
            System.out.println("recieved message from " + channel + ": '" + message.trim());
            if (message.trim().equalsIgnoreCase("worldedit:cui")) {
                System.out.println("register worldedit:cui");
                this.register();
            } else {
                System.out.println("unknown message '" + message + "'");
            }
        }
    }

    public List<String> getChannels() {
        return ImmutableList.of((Object)"worldedit:cui");
    }

    public void onCustomPayload(String channel, class_2540 data) {
        try {
            int readableBytes = data.readableBytes();
            if (readableBytes > 0) {
                byte[] payload = new byte[readableBytes];
                data.readBytes(payload);
                this.channelListener.onMessage(new String(payload, Charsets.UTF_8));
            } else {
                this.controller.getDebugger().debug("Warning, invalid (zero length) payload received from server");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tick(class_310 client) {
        if (client.field_1687 != null) {
            this.onTick(client, client.method_1488(), true, true);
        } else {
            this.onTick(client, client.method_1488(), false, false);
        }
    }

    public void onTick(class_310 mc, float partialTicks, boolean inGame, boolean clock) {
        if (!this.init) {
            this.init(null);
            this.init = true;
        }
        CUIConfiguration config = this.controller.getConfiguration();
        if (inGame && mc.field_1755 == null) {
            if (this.keyBindToggleUI.isPressed()) {
                if (this.keyBindLShift.isKeyDown() || this.keyBindRShift.isKeyDown()) {
                    config.setAlwaysOnTop(!config.isAlwaysOnTop());
                } else {
                    boolean bl = this.visible = !this.visible;
                }
            }
            if (this.keyBindClearSel.isPressed()) {
                if (mc.field_1724 != null) {
                    mc.field_1724.method_3142("//sel");
                }
                if (config.isClearAllOnKey()) {
                    this.controller.clearRegions();
                }
            }
            if (this.keyBindChunkBorder.isPressed()) {
                this.controller.toggleChunkBorders();
            }
        }
        if (inGame && clock && this.controller != null) {
            this.alwaysOnTop = config.isAlwaysOnTop();
            if (mc.field_1687 != this.lastWorld || mc.field_1724 != this.lastPlayer) {
                this.lastWorld = mc.field_1687;
                this.lastPlayer = mc.field_1724;
                this.controller.getDebugger().debug("World change detected, sending new handshake");
                this.controller.clear();
                if (mc.field_1724 != null && config.isPromiscuous()) {
                    mc.field_1724.method_3142("/we cui");
                    Thread t1 = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            LiteModWorldEditCUI.this.controller.getDebugger().debug("sending /we cui command");
                        }
                    });
                    t1.start();
                }
            }
        }
    }

    public String getName() {
        return "WorldEditCUI - Fabric";
    }

    public String getVersion() {
        return "1.15.2";
    }

    public WorldEditCUI getController() {
        return this.controller;
    }

    public void onInitialize() {
        instance = this;
        MixinBootstrap.init();
        Mixins.addConfiguration((String)"mixins.wecui.json");
        this.onInitCompleted();
        ClientTickCallback.EVENT.register((Object)this);
    }

    public void accept(PacketContext context, class_2540 buffer) {
        this.onCustomPayload("unused channel", buffer);
    }

    public void onHudRender(float tickDelta, double cameraX, double cameraY, double cameraZ) {
        if (this.visible && this.alwaysOnTop) {
            this.worldRenderListener.onRender(tickDelta, cameraX, cameraY, cameraZ);
        }
    }

    static {
        joinedServer = false;
    }
}

