/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.points;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import net.minecraft.class_4050;

public abstract class EntityUtilities {
    static final Predicate<class_1297> TRACEABLE = Predicates.and((Predicate[])new Predicate[]{new Predicate<class_1297>(){

        public boolean apply(class_1297 entity) {
            return entity != null && entity.method_5863();
        }
    }});

    public static class_3966 rayTraceFromEntity(class_1297 source, double traceDistance, float partialTicks, boolean includeEntities) {
        class_3966 blockRay = EntityUtilities.rayTraceFromEntity(source, traceDistance, partialTicks);
        if (!includeEntities) {
            return blockRay;
        }
        class_243 traceStart = EntityUtilities.getPositionEyes(source, partialTicks);
        double blockDistance = blockRay != null ? blockRay.method_17784().method_1022(traceStart) : traceDistance;
        EntityTrace entityRay = EntityUtilities.rayTraceEntities(source, traceDistance, partialTicks, blockDistance, traceStart);
        if (entityRay.entity != null && (entityRay.distance < blockDistance || blockRay == null)) {
            return entityRay.asRayTraceResult();
        }
        return blockRay;
    }

    private static EntityTrace rayTraceEntities(class_1297 source, double traceDistance, float partialTicks, double blockDistance, class_243 traceStart) {
        EntityTrace trace = new EntityTrace(blockDistance);
        class_243 lookDir = source.method_5836(partialTicks).method_1021(traceDistance);
        class_243 traceEnd = traceStart.method_1019(lookDir);
        for (class_1297 entity : EntityUtilities.getTraceEntities(source, traceDistance, lookDir, TRACEABLE)) {
            double distanceToEntity;
            class_238 entityBB = entity.method_5829().method_1014(entity.method_5827().method_995());
            Optional entityRay = entityBB.method_999(entityBB).method_992(traceStart, traceEnd);
            if (entityBB.method_1006(traceStart)) {
                if (!(trace.distance >= 0.0)) continue;
                trace.entity = entity;
                trace.location = entityRay.isPresent() ? traceStart : (class_243)entityRay.get();
                trace.distance = 0.0;
                continue;
            }
            if (entityRay.isPresent() || !((distanceToEntity = traceStart.method_1022((class_243)entityRay.get())) < trace.distance) && trace.distance != 0.0) continue;
            if (entity.method_5642() == source.method_5642()) {
                if (trace.distance != 0.0) continue;
                trace.entity = entity;
                trace.location = (class_243)entityRay.get();
                continue;
            }
            trace.entity = entity;
            trace.location = (class_243)entityRay.get();
            trace.distance = distanceToEntity;
        }
        return trace;
    }

    private static List<class_1297> getTraceEntities(class_1297 source, double traceDistance, class_243 dir, Predicate<class_1297> filter) {
        class_238 boundingBox = source.method_5829();
        class_238 traceBox = boundingBox.method_1009(dir.field_1352, dir.field_1351, dir.field_1350);
        List entities = source.field_6002.method_8333(source, traceBox.method_1009(1.0, 1.0, 1.0), filter);
        return entities;
    }

    public static class_3966 rayTraceFromEntity(class_1297 source, double traceDistance, float partialTicks) {
        class_243 traceStart = EntityUtilities.getPositionEyes(source, partialTicks);
        class_243 lookDir = source.method_5836(partialTicks).method_1021(traceDistance);
        class_243 traceEnd = traceStart.method_1019(lookDir);
        class_3959 con = new class_3959(traceStart, traceEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, source);
        return (class_3966)source.method_5745(traceDistance, (float)traceDistance, true);
    }

    public static class_243 getPositionEyes(class_1297 entity, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new class_243(entity.method_23317(), entity.method_23318() + (double)entity.method_18381(class_4050.field_18076), entity.method_23321());
        }
        double interpX = entity.field_6014 + (entity.method_23317() - entity.field_6014) * (double)partialTicks;
        double interpY = entity.field_6036 + (entity.method_23318() - entity.field_6036) * (double)partialTicks + (double)entity.method_18381(class_4050.field_18076);
        double interpZ = entity.field_5969 + (entity.method_23321() - entity.field_5969) * (double)partialTicks;
        return new class_243(interpX, interpY, interpZ);
    }

    static final class EntityTrace {
        class_1297 entity;
        class_243 location;
        double distance;

        EntityTrace(double entityDistance) {
            this.distance = entityDistance;
        }

        class_3966 asRayTraceResult() {
            return new class_3966(this.entity, this.location);
        }
    }
}

