/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.points;

import com.mumfrey.worldeditcui.render.ConfiguredColour;
import com.mumfrey.worldeditcui.render.RenderStyle;
import com.mumfrey.worldeditcui.render.shapes.Render3DBox;
import com.mumfrey.worldeditcui.util.BoundingBox;
import com.mumfrey.worldeditcui.util.Observable;
import com.mumfrey.worldeditcui.util.Vector3;

public class PointCube
extends Observable<BoundingBox> {
    private static final double PADDING = 0.03;
    protected static final Vector3 MIN_VEC = new Vector3(0.03, 0.03, 0.03);
    protected static final Vector3 MAX_VEC = new Vector3(1.03, 1.03, 1.03);
    protected int id;
    protected Vector3 point;
    protected RenderStyle style = ConfiguredColour.CUBOIDPOINT1.style();
    protected Render3DBox box;

    public PointCube(double x, double y, double z) {
        this(new Vector3(x, y, z));
    }

    public PointCube(Vector3 point) {
        this.setPoint(point);
    }

    public boolean isDynamic() {
        return false;
    }

    public PointCube setId(int id) {
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public void render(Vector3 cameraPos) {
        this.box.render(cameraPos);
    }

    public void updatePoint(float partialTicks) {
    }

    public Vector3 getPoint() {
        return this.point;
    }

    public void setPoint(Vector3 point) {
        this.point = point;
        this.update();
    }

    public RenderStyle getStyle() {
        return this.style;
    }

    public PointCube setStyle(RenderStyle style) {
        this.style = style;
        this.update();
        return this;
    }

    private void update() {
        this.box = new Render3DBox(this.style, this.point.subtract(MIN_VEC), this.point.add(MAX_VEC));
    }
}

