/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.shapes;

import com.mumfrey.worldeditcui.render.LineStyle;
import com.mumfrey.worldeditcui.render.RenderStyle;
import com.mumfrey.worldeditcui.render.shapes.RenderRegion;
import com.mumfrey.worldeditcui.util.BoundingBox;
import com.mumfrey.worldeditcui.util.Observable;
import com.mumfrey.worldeditcui.util.Vector3;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_4493;

public class Render3DGrid
extends RenderRegion {
    private static final float CULL_RANGE = 128.0f;
    public static final double MIN_SPACING = 1.0;
    private Vector3 first;
    private Vector3 second;
    private double spacing = 1.0;

    public Render3DGrid(RenderStyle style, BoundingBox region) {
        this(style, region.getMin(), region.getMax());
        if (region.isDynamic()) {
            region.addObserver(this);
        }
    }

    public Render3DGrid(RenderStyle style, Vector3 first, Vector3 second) {
        super(style);
        this.first = first;
        this.second = second;
    }

    @Override
    public void notifyChanged(Observable<?> source) {
        this.setPosition((BoundingBox)source);
    }

    public void setPosition(BoundingBox region) {
        this.setPosition(region.getMin(), region.getMax());
    }

    public void setPosition(Vector3 first, Vector3 second) {
        this.first = first;
        this.second = second;
    }

    public Render3DGrid setSpacing(double spacing) {
        this.spacing = spacing;
        return this;
    }

    @Override
    public void render(Vector3 cameraPos) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        double x1 = this.first.getX() - cameraPos.getX();
        double y1 = this.first.getY() - cameraPos.getY();
        double z1 = this.first.getZ() - cameraPos.getZ();
        double x2 = this.second.getX() - cameraPos.getX();
        double y2 = this.second.getY() - cameraPos.getY();
        double z2 = this.second.getZ() - cameraPos.getZ();
        if (this.spacing != 1.0) {
            class_4493.method_22078();
            double[] vertices = new double[]{x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2, x1, y2, z1, x2, y2, z1, x2, y2, z2, x1, y2, z2, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2};
            for (LineStyle line : this.style.getLines()) {
                if (!line.prepare(this.style.getRenderType())) continue;
                buf.method_1328(7, class_290.field_1592);
                line.applyColour(0.25f);
                for (int i = 0; i < vertices.length; i += 3) {
                    buf.method_22912(vertices[i], vertices[i + 1], vertices[i + 2]).method_1344();
                }
                tessellator.method_1350();
            }
            class_4493.method_22076();
        }
        if (this.spacing < 1.0) {
            return;
        }
        double cullAt = 128.0 * this.spacing;
        for (LineStyle line : this.style.getLines()) {
            if (!line.prepare(this.style.getRenderType())) continue;
            buf.method_1328(1, class_290.field_1592);
            line.applyColour();
            for (double y = Math.max(y1, -cullAt); y <= y2 && y <= cullAt; y += this.spacing) {
                buf.method_22912(x1, y, z2).method_1344();
                buf.method_22912(x2, y, z2).method_1344();
                buf.method_22912(x1, y, z1).method_1344();
                buf.method_22912(x2, y, z1).method_1344();
                buf.method_22912(x1, y, z1).method_1344();
                buf.method_22912(x1, y, z2).method_1344();
                buf.method_22912(x2, y, z1).method_1344();
                buf.method_22912(x2, y, z2).method_1344();
            }
            for (double x = Math.max(x1, -cullAt); x <= x2 && x <= cullAt; x += this.spacing) {
                buf.method_22912(x, y1, z1).method_1344();
                buf.method_22912(x, y2, z1).method_1344();
                buf.method_22912(x, y1, z2).method_1344();
                buf.method_22912(x, y2, z2).method_1344();
                buf.method_22912(x, y2, z1).method_1344();
                buf.method_22912(x, y2, z2).method_1344();
                buf.method_22912(x, y1, z1).method_1344();
                buf.method_22912(x, y1, z2).method_1344();
            }
            for (double z = Math.max(z1, -cullAt); z <= z2 && z <= cullAt; z += this.spacing) {
                buf.method_22912(x1, y1, z).method_1344();
                buf.method_22912(x2, y1, z).method_1344();
                buf.method_22912(x1, y2, z).method_1344();
                buf.method_22912(x2, y2, z).method_1344();
                buf.method_22912(x2, y1, z).method_1344();
                buf.method_22912(x2, y2, z).method_1344();
                buf.method_22912(x1, y1, z).method_1344();
                buf.method_22912(x1, y2, z).method_1344();
            }
            tessellator.method_1350();
        }
    }
}

