/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.shapes;

import com.mumfrey.worldeditcui.render.LineStyle;
import com.mumfrey.worldeditcui.render.RenderStyle;
import com.mumfrey.worldeditcui.render.points.PointCube;
import com.mumfrey.worldeditcui.render.shapes.RenderRegion;
import com.mumfrey.worldeditcui.util.Vector3;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;

public class RenderCylinderGrid
extends RenderRegion {
    protected double radX = 0.0;
    protected double radZ = 0.0;
    protected int minY;
    protected int maxY;
    protected double centreX;
    protected double centreZ;

    public RenderCylinderGrid(RenderStyle style, PointCube centre, double radX, double radZ, int minY, int maxY) {
        super(style);
        this.radX = radX;
        this.radZ = radZ;
        this.minY = minY;
        this.maxY = maxY;
        this.centreX = centre.getPoint().getX() + 0.5;
        this.centreZ = centre.getPoint().getZ() + 0.5;
    }

    @Override
    public void render(Vector3 cameraPos) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        double xPos = this.centreX;
        double zPos = this.centreZ;
        for (LineStyle line : this.style.getLines()) {
            if (!line.prepare(this.style.getRenderType())) continue;
            int tmaxY = this.maxY + 1;
            int tminY = this.minY;
            int posRadiusX = (int)Math.ceil(this.radX);
            int negRadiusX = (int)(-Math.ceil(this.radX));
            int posRadiusZ = (int)Math.ceil(this.radZ);
            int negRadiusZ = (int)(-Math.ceil(this.radZ));
            for (double tempX = (double)negRadiusX; tempX <= (double)posRadiusX; tempX += 1.0) {
                double tempZ = this.radZ * Math.cos(Math.asin(tempX / this.radX));
                buf.method_1328(2, class_290.field_1592);
                line.applyColour();
                buf.method_22912(xPos + tempX, (double)tmaxY - cameraPos.getY(), zPos + tempZ).method_1344();
                buf.method_22912(xPos + tempX, (double)tmaxY - cameraPos.getY(), zPos - tempZ).method_1344();
                buf.method_22912(xPos + tempX, (double)tminY - cameraPos.getY(), zPos - tempZ).method_1344();
                buf.method_22912(xPos + tempX, (double)tminY - cameraPos.getY(), zPos + tempZ).method_1344();
                tessellator.method_1350();
            }
            for (double tempZ = (double)negRadiusZ; tempZ <= (double)posRadiusZ; tempZ += 1.0) {
                double tempX = this.radX * Math.sin(Math.acos(tempZ / this.radZ));
                buf.method_1328(2, class_290.field_1592);
                line.applyColour();
                buf.method_22912(xPos + tempX, (double)tmaxY - cameraPos.getY(), zPos + tempZ).method_1344();
                buf.method_22912(xPos - tempX, (double)tmaxY - cameraPos.getY(), zPos + tempZ).method_1344();
                buf.method_22912(xPos - tempX, (double)tminY - cameraPos.getY(), zPos + tempZ).method_1344();
                buf.method_22912(xPos + tempX, (double)tminY - cameraPos.getY(), zPos + tempZ).method_1344();
                tessellator.method_1350();
            }
        }
    }
}

