/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.shapes;

import com.mumfrey.worldeditcui.render.LineStyle;
import com.mumfrey.worldeditcui.render.RenderStyle;
import com.mumfrey.worldeditcui.render.points.PointCube;
import com.mumfrey.worldeditcui.render.shapes.RenderRegion;
import com.mumfrey.worldeditcui.util.Vector3;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_4493;

public class RenderEllipsoid
extends RenderRegion {
    protected static final double TAU = Math.PI * 2;
    protected PointCube centre;
    protected Vector3 radii;
    protected double centreX;
    protected double centreY;
    protected double centreZ;

    public RenderEllipsoid(RenderStyle style, PointCube centre, Vector3 radii) {
        super(style);
        this.centre = centre;
        this.radii = radii;
        this.centreX = centre.getPoint().getX() + 0.5;
        this.centreY = centre.getPoint().getY() + 0.5;
        this.centreZ = centre.getPoint().getZ() + 0.5;
    }

    @Override
    public void render(Vector3 cameraPos) {
        class_4493.method_21926();
        class_4493.method_21938((double)(this.centreX - cameraPos.getX()), (double)(this.centreY - cameraPos.getY()), (double)(this.centreZ - cameraPos.getZ()));
        for (LineStyle line : this.style.getLines()) {
            if (!line.prepare(this.style.getRenderType())) continue;
            this.drawXZPlane(line);
            this.drawYZPlane(line);
            this.drawXYPlane(line);
        }
        class_4493.method_21928();
    }

    protected void drawXZPlane(LineStyle line) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        int yRad = (int)Math.floor(this.radii.getY());
        for (int yBlock = -yRad; yBlock < yRad; ++yBlock) {
            buf.method_1328(2, class_290.field_1592);
            line.applyColour();
            for (int i = 0; i <= 40; ++i) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempX = this.radii.getX() * Math.cos(tempTheta) * Math.cos(Math.asin((double)yBlock / this.radii.getY()));
                double tempZ = this.radii.getZ() * Math.sin(tempTheta) * Math.cos(Math.asin((double)yBlock / this.radii.getY()));
                buf.method_22912(tempX, (double)yBlock, tempZ).method_1344();
            }
            tessellator.method_1350();
        }
        buf.method_1328(2, class_290.field_1592);
        line.applyColour();
        for (int i = 0; i <= 40; ++i) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempX = this.radii.getX() * Math.cos(tempTheta);
            double tempZ = this.radii.getZ() * Math.sin(tempTheta);
            buf.method_22912(tempX, 0.0, tempZ).method_1344();
        }
        tessellator.method_1350();
    }

    protected void drawYZPlane(LineStyle line) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        int xRad = (int)Math.floor(this.radii.getX());
        for (int xBlock = -xRad; xBlock < xRad; ++xBlock) {
            buf.method_1328(2, class_290.field_1592);
            line.applyColour();
            for (int i = 0; i <= 40; ++i) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempY = this.radii.getY() * Math.cos(tempTheta) * Math.sin(Math.acos((double)xBlock / this.radii.getX()));
                double tempZ = this.radii.getZ() * Math.sin(tempTheta) * Math.sin(Math.acos((double)xBlock / this.radii.getX()));
                buf.method_22912((double)xBlock, tempY, tempZ).method_1344();
            }
            tessellator.method_1350();
        }
        buf.method_1328(2, class_290.field_1592);
        line.applyColour();
        for (int i = 0; i <= 40; ++i) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempY = this.radii.getY() * Math.cos(tempTheta);
            double tempZ = this.radii.getZ() * Math.sin(tempTheta);
            buf.method_22912(0.0, tempY, tempZ).method_1344();
        }
        tessellator.method_1350();
    }

    protected void drawXYPlane(LineStyle line) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        int zRad = (int)Math.floor(this.radii.getZ());
        for (int zBlock = -zRad; zBlock < zRad; ++zBlock) {
            buf.method_1328(2, class_290.field_1592);
            line.applyColour();
            for (int i = 0; i <= 40; ++i) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempX = this.radii.getX() * Math.sin(tempTheta) * Math.sin(Math.acos((double)zBlock / this.radii.getZ()));
                double tempY = this.radii.getY() * Math.cos(tempTheta) * Math.sin(Math.acos((double)zBlock / this.radii.getZ()));
                buf.method_22912(tempX, tempY, (double)zBlock).method_1344();
            }
            tessellator.method_1350();
        }
        buf.method_1328(2, class_290.field_1592);
        line.applyColour();
        for (int i = 0; i <= 40; ++i) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempX = this.radii.getX() * Math.cos(tempTheta);
            double tempY = this.radii.getY() * Math.sin(tempTheta);
            buf.method_22912(tempX, tempY, 0.0).method_1344();
        }
        tessellator.method_1350();
    }
}

