/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.CommandString;
import exopandora.worldhandler.builder.CommandSyntax;
import exopandora.worldhandler.builder.ICommandBuilderSyntax;
import exopandora.worldhandler.builder.types.ArgumentType;
import exopandora.worldhandler.builder.types.BlockResourceLocation;
import exopandora.worldhandler.builder.types.CoordinateDouble;
import exopandora.worldhandler.builder.types.CoordinateInt;
import exopandora.worldhandler.builder.types.GreedyString;
import exopandora.worldhandler.builder.types.ItemResourceLocation;
import exopandora.worldhandler.builder.types.TargetSelector;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class CommandBuilder
implements ICommandBuilderSyntax {
    private List<Map.Entry<CommandSyntax.Argument, String>> command;

    public CommandBuilder() {
        this.updateSyntax(this.getSyntax());
    }

    protected void setNode(int index, String node) {
        this.set(index, node != null && !node.isEmpty() ? node : null, ArgumentType.STRING);
    }

    protected void setNode(int index, GreedyString node) {
        this.set(index, node != null && !node.isEmpty() ? node : null, ArgumentType.GREEDY_STRING);
    }

    protected void setNode(int index, boolean node) {
        this.set(index, node, ArgumentType.BOOLEAN);
    }

    protected void setNode(int index, short node) {
        this.set(index, node, ArgumentType.SHORT);
    }

    protected void setNode(int index, byte node) {
        this.set(index, node, ArgumentType.BYTE);
    }

    protected void setNode(int index, int node) {
        this.set(index, node, ArgumentType.INT);
    }

    protected void setNode(int index, float node) {
        this.set(index, Float.valueOf(node), ArgumentType.FLOAT);
    }

    protected void setNode(int index, double node) {
        this.set(index, node, ArgumentType.DOUBLE);
    }

    protected void setNode(int index, long node) {
        this.set(index, node, ArgumentType.LONG);
    }

    protected void setNode(int index, ResourceLocation node) {
        this.set(index, node, ArgumentType.RESOURCE_LOCATION);
    }

    protected void setNode(int index, CoordinateInt coordinate) {
        this.set(index, coordinate, ArgumentType.COORDINATE_INT);
    }

    protected void setNode(int index, CoordinateDouble coordinate) {
        this.set(index, coordinate, ArgumentType.COORDINATE_DOUBLE);
    }

    protected void setNode(int index, TargetSelector target) {
        this.set(index, target, ArgumentType.TARGET_SELECTOR);
    }

    protected void setNode(int index, ItemResourceLocation resource) {
        this.set(index, resource, ArgumentType.ITEM_RESOURCE_LOCATION);
    }

    protected void setNode(int index, BlockResourceLocation resource) {
        this.set(index, resource, ArgumentType.BLOCK_RESOURCE_LOCATION);
    }

    protected void setNode(int index, CompoundNBT nbt) {
        this.set(index, nbt, ArgumentType.NBT);
    }

    protected void setPlayerName(int index, String username) {
        this.set(index, username != null && !username.isEmpty() ? username : null, ArgumentType.PLAYER);
    }

    private void set(int index, Object value, ArgumentType type) {
        if (index < this.command.size()) {
            CommandSyntax.Argument entry = this.command.get(index).getKey();
            ArgumentType expectedType = entry.getType();
            boolean typeMatch = expectedType.equals((Object)type);
            if (value != null && typeMatch) {
                this.command.get(index).setValue(value.toString());
            } else {
                this.command.get(index).setValue(entry.toString());
                if (!typeMatch) {
                    this.warn("set", expectedType, type, index);
                }
            }
        } else {
            WorldHandler.LOGGER.warn("Tried to set invalid index \"" + index + "\" for command \"" + this.getCommandName() + "\"");
        }
    }

    @Nullable
    protected String getNodeAsString(int index) {
        return (String)this.get(index, ArgumentType.STRING);
    }

    @Nullable
    protected String getNodeAsGreedyString(int index) {
        return (String)this.get(index, ArgumentType.GREEDY_STRING);
    }

    protected boolean getNodeAsBoolean(int index) {
        return (Boolean)this.get(index, ArgumentType.BOOLEAN);
    }

    protected short getNodeAsShort(int index) {
        return (Short)this.get(index, ArgumentType.SHORT);
    }

    protected byte getNodeAsByte(int index) {
        return (Byte)this.get(index, ArgumentType.BYTE);
    }

    protected int getNodeAsInt(int index) {
        return (Integer)this.get(index, ArgumentType.INT);
    }

    protected float getNodeAsFloat(int index) {
        return ((Float)this.get(index, ArgumentType.FLOAT)).floatValue();
    }

    protected double getNodeAsDouble(int index) {
        return (Double)this.get(index, ArgumentType.DOUBLE);
    }

    protected long getNodeAsLong(int index) {
        return (Long)this.get(index, ArgumentType.LONG);
    }

    protected CoordinateInt getNodeAsCoordinateInt(int index) {
        return (CoordinateInt)this.get(index, ArgumentType.COORDINATE_INT);
    }

    protected CoordinateDouble getNodeAsCoordinateDouble(int index) {
        return (CoordinateDouble)this.get(index, ArgumentType.COORDINATE_DOUBLE);
    }

    @Nullable
    protected ResourceLocation getNodeAsResourceLocation(int index) {
        return (ResourceLocation)this.get(index, ArgumentType.RESOURCE_LOCATION);
    }

    protected TargetSelector getNodeAsTargetSelector(int index) {
        return (TargetSelector)this.get(index, ArgumentType.TARGET_SELECTOR);
    }

    @Nullable
    protected ItemResourceLocation getNodeAsItemResourceLocation(int index) {
        return (ItemResourceLocation)this.get(index, ArgumentType.ITEM_RESOURCE_LOCATION);
    }

    @Nullable
    protected BlockResourceLocation getNodeAsBlockResourceLocation(int index) {
        return (BlockResourceLocation)this.get(index, ArgumentType.BLOCK_RESOURCE_LOCATION);
    }

    @Nullable
    protected CompoundNBT getNodeAsNBT(int index) {
        return (CompoundNBT)this.get(index, ArgumentType.NBT);
    }

    @Nullable
    private <T> T get(int index, ArgumentType type) {
        if (index < this.command.size()) {
            Map.Entry<CommandSyntax.Argument, String> entry = this.command.get(index);
            ArgumentType expected = entry.getKey().getType();
            String value = entry.getValue();
            if (expected.equals((Object)type)) {
                if (value.equals(entry.getKey().toString())) {
                    return null;
                }
                return expected.parse(value);
            }
            this.warn("get", expected, type, index);
            return type.parse(value);
        }
        return null;
    }

    private void warn(String function, ArgumentType expected, ArgumentType type, int index) {
        WorldHandler.LOGGER.warn("[" + function.toUpperCase() + "] Expected \"" + (Object)((Object)expected) + "\" instead of \"" + (Object)((Object)type) + "\" at index \"" + index + "\" for command \"" + this.getCommandName() + "\"");
    }

    private boolean isDefaultArgument(CommandSyntax.Argument argument, String value) {
        return argument.getDefault() != null ? value.equals(argument.getDefault().toString()) : value == null;
    }

    protected void updateSyntax(CommandSyntax syntax) {
        if (syntax != null) {
            this.command = syntax.getArguments().stream().map(entry -> new AbstractMap.SimpleEntry<CommandSyntax.Argument, String>((CommandSyntax.Argument)entry, entry.toString())).collect(Collectors.toList());
        }
    }

    @Override
    public String toCommand() {
        CommandString command = new CommandString(this.getCommandName());
        for (Map.Entry<CommandSyntax.Argument, String> entry : this.command) {
            if (this.isDefaultArgument(entry.getKey(), entry.getValue())) {
                command.append(entry.getKey().toString());
                continue;
            }
            command.append(entry.getValue());
        }
        return command.toString();
    }

    @Override
    public String toActualCommand() {
        CommandString command = new CommandString(this.getCommandName());
        for (Map.Entry<CommandSyntax.Argument, String> entry : this.command) {
            if (!entry.getKey().isRequired() && (entry.getKey().toString().equals(entry.getValue()) || this.isDefaultArgument(entry.getKey(), entry.getValue()))) break;
            if (entry.getKey().isRequired() && entry.getKey().toString().equals(entry.getValue()) && entry.getKey().getDefault() != null) {
                command.append(entry.getKey().getDefault().toString());
                continue;
            }
            command.append(entry.getValue());
        }
        return command.toString();
    }
}

