/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder;

import com.google.gson.annotations.SerializedName;
import exopandora.worldhandler.builder.types.ArgumentType;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CommandSyntax {
    private List<Argument> syntax = new ArrayList<Argument>();

    public CommandSyntax() {
    }

    public CommandSyntax(List<Argument> syntax) {
        this.syntax = syntax;
    }

    public CommandSyntax addRequired(String key, ArgumentType type) {
        this.syntax.add(new Argument(key, type, true, null));
        return this;
    }

    public CommandSyntax addRequired(String key, ArgumentType type, Object def) {
        this.syntax.add(new Argument(key, type, true, def));
        return this;
    }

    public CommandSyntax addOptional(String key, ArgumentType type) {
        this.syntax.add(new Argument(key, type, false, null));
        return this;
    }

    public CommandSyntax addOptional(String key, ArgumentType type, Object def) {
        this.syntax.add(new Argument(key, type, false, def));
        return this;
    }

    public List<Argument> getArguments() {
        return this.syntax;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Argument {
        @SerializedName(value="name")
        private final String key;
        @SerializedName(value="type")
        private final ArgumentType type;
        @SerializedName(value="required")
        private final boolean required;
        @SerializedName(value="default")
        private final Object def;

        public Argument(String key, ArgumentType type, boolean required, Object def) {
            this.key = key;
            this.type = type;
            this.required = required;
            this.def = def;
        }

        public String getKey() {
            return this.key;
        }

        public ArgumentType getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Object getDefault() {
            return this.def;
        }

        public String toString() {
            if (this.required) {
                return "<" + this.key + ">";
            }
            return "[" + this.key + "]";
        }
    }
}

