/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.impl;

import exopandora.worldhandler.builder.CommandBuilderNBT;
import exopandora.worldhandler.builder.CommandSyntax;
import exopandora.worldhandler.builder.component.impl.EntityNBT;
import exopandora.worldhandler.builder.impl.EnumAttributes;
import exopandora.worldhandler.builder.types.ArgumentType;
import exopandora.worldhandler.builder.types.Coordinate;
import exopandora.worldhandler.builder.types.CoordinateDouble;
import exopandora.worldhandler.util.MutableStringTextComponent;
import exopandora.worldhandler.util.ResourceHelper;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class BuilderSummon
extends CommandBuilderNBT {
    private final EntityNBT nbt = new EntityNBT();

    public BuilderSummon() {
        this.setX(new CoordinateDouble(0.0, Coordinate.EnumType.LOCAL));
        this.setY(new CoordinateDouble(0.0, Coordinate.EnumType.LOCAL));
        this.setZ(new CoordinateDouble(2.0, Coordinate.EnumType.LOCAL));
    }

    public void setName(String name) {
        this.setEntity(BuilderSummon.parseEntityName(name));
        this.updateCustomComponent(name);
    }

    public void setNameAndId(String name) {
        this.setName(name);
        this.nbt.setId(this.getEntity());
    }

    public void setEntity(ResourceLocation entity) {
        this.setNode(0, entity);
    }

    public ResourceLocation getEntity() {
        return this.getNodeAsResourceLocation(0);
    }

    public void setX(CoordinateDouble x) {
        this.setNode(1, x);
    }

    public CoordinateDouble getX() {
        return this.getNodeAsCoordinateDouble(1);
    }

    public void setY(CoordinateDouble y) {
        this.setNode(2, y);
    }

    public CoordinateDouble getY() {
        return this.getNodeAsCoordinateDouble(2);
    }

    public void setZ(CoordinateDouble z) {
        this.setNode(3, z);
    }

    public CoordinateDouble getZ() {
        return this.getNodeAsCoordinateDouble(3);
    }

    public void setId(ResourceLocation resource) {
        this.nbt.setId(resource);
    }

    public ResourceLocation getId() {
        return this.nbt.getId();
    }

    public void setAttribute(EnumAttributes attribute, double ammount) {
        this.nbt.setAttribute(attribute, ammount);
    }

    public void removeAttribute(EnumAttributes attribute) {
        this.nbt.removeAttribute(attribute);
    }

    public double getAttributeAmmount(EnumAttributes attribute) {
        return this.nbt.getAttributeAmmount(attribute);
    }

    public Set<EnumAttributes> getAttributes() {
        return this.nbt.getAttributes();
    }

    public void setCustomName(String name) {
        this.nbt.setCustomName(name);
    }

    @Nullable
    public MutableStringTextComponent getCustomName() {
        return this.nbt.getCustomName();
    }

    public void setPassenger(int index, String name) {
        this.nbt.setPassenger(index, BuilderSummon.parseEntityName(name));
    }

    public void setPassenger(int index, EntityNBT entity) {
        this.nbt.setPassenger(index, entity);
    }

    public void setPassenger(int index, ResourceLocation id) {
        this.setPassenger(index, new EntityNBT(id));
    }

    public void addPassenger(EntityNBT entity) {
        this.nbt.addPassenger(entity);
    }

    public void addPassenger(int index, EntityNBT entity) {
        this.nbt.addPassenger(index, entity);
    }

    public void removePassenger(int index) {
        this.nbt.removePassenger(index);
    }

    public int getPassengerCount() {
        return this.nbt.getPassengerCount();
    }

    public List<EntityNBT> getPassengers() {
        return this.nbt.getPassengers();
    }

    @Nullable
    public EntityNBT getPassenger(int index) {
        return this.nbt.getPassenger(index);
    }

    public boolean hasPassengers() {
        return this.nbt.hasPassengers();
    }

    public void setArmorItem(int index, Block block) {
        this.nbt.setArmorItem(index, block);
    }

    public void setArmorItem(int index, Item item) {
        this.nbt.setArmorItem(index, item);
    }

    public void setArmorItem(int index, ResourceLocation location) {
        this.nbt.setArmorItem(index, location);
    }

    public void setArmorItems(ResourceLocation[] armor) {
        this.nbt.setArmorItems(armor);
    }

    public ResourceLocation getArmorItem(int slot) {
        return this.nbt.getArmorItem(slot);
    }

    public void setHandItem(int index, Block block) {
        this.nbt.setHandItem(index, block);
    }

    public void setHandItem(int index, Item item) {
        this.nbt.setHandItem(index, item);
    }

    public void setHandItem(int index, ResourceLocation location) {
        this.nbt.setHandItem(index, location);
    }

    public ResourceLocation getHandItem(int slot) {
        return this.nbt.getHandItem(slot);
    }

    public double[] getMotion() {
        return this.nbt.getMotion();
    }

    public void setMotion(double x, double y, double z) {
        this.nbt.setMotion(x, y, z);
    }

    public double getMotionX() {
        return this.nbt.getMotionX();
    }

    public double getMotionY() {
        return this.nbt.getMotionY();
    }

    public double getMotionZ() {
        return this.nbt.getMotionZ();
    }

    public void setMotionX(double x) {
        this.nbt.setMotionX(x);
    }

    public void setMotionY(double y) {
        this.nbt.setMotionY(y);
    }

    public void setMotionZ(double z) {
        this.nbt.setMotionZ(z);
    }

    public void setAmplifier(Effect potion, byte amplifier) {
        this.nbt.setAmplifier(potion, amplifier);
    }

    public void setSeconds(Effect potion, int seconds) {
        this.nbt.setSeconds(potion, seconds);
    }

    public void setMinutes(Effect potion, int minutes) {
        this.nbt.setMinutes(potion, minutes);
    }

    public void setHours(Effect potion, int hours) {
        this.nbt.setHours(potion, hours);
    }

    public void setShowParticles(Effect potion, boolean showParticles) {
        this.nbt.setShowParticles(potion, showParticles);
    }

    public void setAmbient(Effect potion, boolean ambient) {
        this.nbt.setAmbient(potion, ambient);
    }

    public byte getAmplifier(Effect potion) {
        return this.nbt.getAmplifier(potion);
    }

    public int getSeconds(Effect potion) {
        return this.nbt.getSeconds(potion);
    }

    public int getMinutes(Effect potion) {
        return this.nbt.getMinutes(potion);
    }

    public int getHours(Effect potion) {
        return this.nbt.getHours(potion);
    }

    public boolean getShowParticles(Effect potion) {
        return this.nbt.getShowParticles(potion);
    }

    public boolean getAmbient(Effect potion) {
        return this.nbt.getAmbient(potion);
    }

    public Set<Effect> getEffects() {
        return this.nbt.getEffects();
    }

    public void setBlockState(BlockState blockState) {
        this.nbt.setBlockState(blockState);
    }

    public BlockState getBlockState() {
        return this.nbt.getBlockState();
    }

    public void setTime(int time) {
        this.nbt.setTime(time);
    }

    public int getTime() {
        return this.nbt.getTime();
    }

    public void setCommand(String command) {
        this.nbt.setCommand(command);
    }

    public String getCommand() {
        return this.nbt.getCommand();
    }

    @Override
    protected CompoundNBT buildNBT() {
        return this.nbt.serialize();
    }

    @Override
    public void setNBT(CompoundNBT nbt) {
        this.setNode(4, nbt);
    }

    @Override
    public String getCommandName() {
        return "summon";
    }

    @Override
    public CommandSyntax getSyntax() {
        CommandSyntax syntax = new CommandSyntax();
        syntax.addRequired("entity_name", ArgumentType.RESOURCE_LOCATION);
        syntax.addOptional("x", ArgumentType.COORDINATE_DOUBLE);
        syntax.addOptional("y", ArgumentType.COORDINATE_DOUBLE);
        syntax.addOptional("z", ArgumentType.COORDINATE_DOUBLE);
        syntax.addOptional("nbt", ArgumentType.NBT);
        return syntax;
    }

    private void updateCustomComponent(String name) {
        if (name != null && this.getEntity() != null) {
            if (EntityType.field_220360_g.getRegistryName().equals((Object)this.getEntity())) {
                this.nbt.setCustomComponent("CatType", (INBT)IntNBT.func_229692_a_((int)new Random().nextInt(11)));
            } else if (EntityType.field_200756_av.getRegistryName().equals((Object)this.getEntity())) {
                for (VillagerProfession profession : ForgeRegistries.PROFESSIONS) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)profession.toString())) continue;
                    CompoundNBT villagerData = new CompoundNBT();
                    villagerData.func_74778_a("profession", profession.getRegistryName().toString());
                    this.nbt.setCustomComponent("VillagerData", (INBT)villagerData);
                    break;
                }
            } else if (EntityType.field_200725_aD.getRegistryName().equals((Object)this.getEntity())) {
                if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"Baby")) {
                    this.nbt.setCustomComponent("IsBaby", (INBT)ByteNBT.func_229671_a_((byte)1));
                }
            } else if (EntityType.field_200795_i.getRegistryName().equals((Object)this.getEntity())) {
                if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"Jockey") && !this.nbt.hasPassengers()) {
                    ListNBT list = new ListNBT();
                    EntityNBT zombie = new EntityNBT(EntityType.field_200725_aD.getRegistryName());
                    zombie.setIsBaby(true);
                    list.add((Object)zombie.serialize());
                    this.nbt.setCustomComponent("Passengers", (INBT)list);
                }
            } else if (EntityType.field_200748_an.getRegistryName().equals((Object)this.getEntity())) {
                if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"Jockey") && !this.nbt.hasPassengers()) {
                    ListNBT list = new ListNBT();
                    EntityNBT skeleton = new EntityNBT(EntityType.field_200741_ag.getRegistryName());
                    skeleton.setHandItem(0, Items.field_151031_f);
                    list.add((Object)skeleton.serialize());
                    this.nbt.setCustomComponent("Passengers", (INBT)list);
                }
            } else {
                this.nbt.resetCustomComponent();
            }
        } else {
            this.nbt.resetCustomComponent();
        }
    }

    @Nullable
    public static ResourceLocation parseEntityName(String entityName) {
        String name = ResourceHelper.stripToResourceLocation(entityName);
        for (EntityType type : ForgeRegistries.ENTITIES.getValues()) {
            if (!type.func_200720_b() || !entityName.equalsIgnoreCase(I18n.func_135052_a((String)type.func_210760_d(), (Object[])new Object[0]))) continue;
            return type.getRegistryName();
        }
        String entity = name.replaceAll("_", "");
        if (entity.equalsIgnoreCase("RedCow")) {
            return EntityType.field_200780_T.getRegistryName();
        }
        if (entity.equalsIgnoreCase("ChickenJockey")) {
            return EntityType.field_200795_i.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Pigman") || entity.equalsIgnoreCase("ZombiePig") || entity.equalsIgnoreCase("ZombiePigman")) {
            return EntityType.field_200785_Y.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Wither")) {
            return EntityType.field_200760_az.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Dog")) {
            return EntityType.field_200724_aC.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Dragon")) {
            return EntityType.field_200802_p.getRegistryName();
        }
        if (entity.equalsIgnoreCase("SnowMan")) {
            return EntityType.field_200745_ak.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Horse") || entity.equalsIgnoreCase("ZombieHorse") || entity.equalsIgnoreCase("SkeletonHorse")) {
            return EntityType.field_200762_B.getRegistryName();
        }
        if (entity.equalsIgnoreCase("LavaCube") || entity.equalsIgnoreCase("MagmaSlime") || entity.equalsIgnoreCase("MagmaCube")) {
            return EntityType.field_200771_K.getRegistryName();
        }
        if (entity.equalsIgnoreCase("SpiderJockey")) {
            return EntityType.field_200748_an.getRegistryName();
        }
        if (entity.equalsIgnoreCase("IronGolem")) {
            return EntityType.field_200757_aw.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Ozelot") || entity.equals("Ocelot")) {
            return EntityType.field_200781_U.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Kitty") || entity.equalsIgnoreCase("Kitten")) {
            return EntityType.field_220360_g.getRegistryName();
        }
        if (entity.equalsIgnoreCase("TESTIFICATE") || entity.equalsIgnoreCase("Blacksmith") || entity.equalsIgnoreCase("Farmer") || entity.equalsIgnoreCase("Fisherman") || entity.equalsIgnoreCase("Shepherd") || entity.equalsIgnoreCase("Fletcher") || entity.equalsIgnoreCase("Librarian") || entity.equalsIgnoreCase("Cleric") || entity.equalsIgnoreCase("Priest") || entity.equalsIgnoreCase("Armorer") || entity.equalsIgnoreCase("WeaponSmith") || entity.equalsIgnoreCase("ToolSmith") || entity.equalsIgnoreCase("Butcher") || entity.equalsIgnoreCase("Leatherworker") || entity.equalsIgnoreCase("Carthographer") || entity.equalsIgnoreCase("Nitwit")) {
            return EntityType.field_200756_av.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Octopus") || entity.equalsIgnoreCase("Kraken")) {
            return EntityType.field_200749_ao.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Exwife")) {
            return EntityType.field_200811_y.getRegistryName();
        }
        if (entity.equalsIgnoreCase("TNTMinecart")) {
            return EntityType.field_200778_R.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Minecart")) {
            return EntityType.field_200772_L.getRegistryName();
        }
        if (entity.equalsIgnoreCase("HopperMinecart")) {
            return EntityType.field_200776_P.getRegistryName();
        }
        if (entity.equalsIgnoreCase("ChestMinecart")) {
            return EntityType.field_200773_M.getRegistryName();
        }
        if (entity.equalsIgnoreCase("SpawnerMinecart")) {
            return EntityType.field_200777_Q.getRegistryName();
        }
        if (entity.equalsIgnoreCase("FurnaceMinecart")) {
            return EntityType.field_200775_O.getRegistryName();
        }
        if (entity.equalsIgnoreCase("CommandBlockMinecart") || entity.equalsIgnoreCase("MinecartCommand") || entity.equalsIgnoreCase("CommandMinecart")) {
            return EntityType.field_200774_N.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Wizard")) {
            return EntityType.field_200806_t.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Johnny")) {
            return EntityType.field_200758_ax.getRegistryName();
        }
        if (entity.equalsIgnoreCase("BabyZombie")) {
            return EntityType.field_200725_aD.getRegistryName();
        }
        if (entity == null || entity.isEmpty()) {
            return null;
        }
        return ResourceHelper.stringToResourceLocation(name);
    }
}

