/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import exopandora.worldhandler.config.ConfigCategoryButcher;
import exopandora.worldhandler.config.ConfigCategorySettings;
import exopandora.worldhandler.config.ConfigCategorySkin;
import exopandora.worldhandler.config.ConfigCategorySliders;
import exopandora.worldhandler.event.KeyHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    private static ModConfig MOD_CONFIG;
    private static CommentedFileConfig CONFIG_DATA;

    public static ConfigCategorySettings getSettings() {
        return CLIENT.getSettings();
    }

    public static ConfigCategoryButcher getButcher() {
        return CLIENT.getButcher();
    }

    public static ConfigCategorySkin getSkin() {
        return CLIENT.getSkin();
    }

    public static ConfigCategorySliders getSliders() {
        return CLIENT.getSliders();
    }

    protected static <T> void set(ForgeConfigSpec.ConfigValue<T> configValue, T value) {
        if (configValue != null && value != null && (!value.equals(configValue.get()) || configValue.get() instanceof List)) {
            CONFIG_DATA.set(configValue.getPath(), value);
        }
    }

    @SubscribeEvent
    public static void configLoad(ModConfig.Loading event) {
        if (event.getConfig().getType().equals((Object)ModConfig.Type.CLIENT)) {
            MOD_CONFIG = event.getConfig();
            CONFIG_DATA = (CommentedFileConfig)MOD_CONFIG.getConfigData();
        }
    }

    @SubscribeEvent
    public static void configReload(ModConfig.Reloading event) {
        if (event.getConfig().getType().equals((Object)ModConfig.Type.CLIENT) && CONFIG_DATA != null) {
            CONFIG_DATA.load();
            KeyHandler.updatePosKeys();
        }
    }

    public static void setupDirectories(Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        CLIENT = (ClientConfig)pair.getLeft();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientConfig {
        private final ConfigCategorySettings settings;
        private final ConfigCategoryButcher butcher;
        private final ConfigCategorySkin skin;
        private final ConfigCategorySliders sliders;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.settings = new ConfigCategorySettings(builder);
            this.butcher = new ConfigCategoryButcher(builder);
            this.skin = new ConfigCategorySkin(builder);
            this.sliders = new ConfigCategorySliders(builder);
        }

        public ConfigCategorySettings getSettings() {
            return this.settings;
        }

        public ConfigCategoryButcher getButcher() {
            return this.butcher;
        }

        public ConfigCategorySkin getSkin() {
            return this.skin;
        }

        public ConfigCategorySliders getSliders() {
            return this.sliders;
        }
    }
}

