/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import com.google.common.base.Predicates;
import exopandora.worldhandler.config.Config;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategoryButcher {
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> entities;

    public ConfigCategoryButcher(ForgeConfigSpec.Builder builder) {
        builder.push("butcher");
        this.entities = builder.defineList("entities", Collections.emptyList(), this::isValid);
        builder.pop();
    }

    public List<ResourceLocation> getEntities() {
        return ((List)this.entities.get()).stream().map(ResourceLocation::func_208304_a).filter((Predicate<ResourceLocation>)Predicates.notNull()).collect(Collectors.toList());
    }

    public boolean containsEntity(ResourceLocation entity) {
        return this.getEntities().contains(entity);
    }

    public void addEntity(ResourceLocation entity) {
        if (this.isValid(entity)) {
            List entities = (List)this.entities.get();
            entities.add(entity.toString());
            Config.set(this.entities, entities);
        }
    }

    public boolean removeEntity(ResourceLocation entity) {
        List entities = (List)this.entities.get();
        boolean removed = entities.remove(entity.toString());
        if (removed) {
            Config.set(this.entities, entities);
        }
        return removed;
    }

    private boolean isValid(Object string) {
        if (string != null) {
            return ForgeRegistries.ENTITIES.containsKey(ResourceLocation.func_208304_a((String)string.toString()));
        }
        return false;
    }
}

