/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import exopandora.worldhandler.builder.impl.BuilderSetBlock;
import exopandora.worldhandler.config.Config;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategorySettings {
    private final ForgeConfigSpec.BooleanValue commandSyntax;
    private final ForgeConfigSpec.BooleanValue shortcuts;
    private final ForgeConfigSpec.BooleanValue shortcutKeys;
    private final ForgeConfigSpec.BooleanValue tooltips;
    private final ForgeConfigSpec.BooleanValue watch;
    private final ForgeConfigSpec.BooleanValue smoothWatch;
    private final ForgeConfigSpec.BooleanValue pause;
    private final ForgeConfigSpec.BooleanValue customTimes;
    private final ForgeConfigSpec.BooleanValue permissionQuery;
    private final ForgeConfigSpec.BooleanValue highlightBlocks;
    private final ForgeConfigSpec.IntValue dawn;
    private final ForgeConfigSpec.IntValue noon;
    private final ForgeConfigSpec.IntValue sunset;
    private final ForgeConfigSpec.IntValue midnight;
    private final ForgeConfigSpec.ConfigValue<BuilderSetBlock.EnumMode> blockPlacingMode;

    public ConfigCategorySettings(ForgeConfigSpec.Builder builder) {
        builder.push("settings");
        this.commandSyntax = builder.translation("gui.worldhandler.config.settings.command_syntax").comment("Whether or not to display the current command at the bottom").define("command_syntax", false);
        this.shortcuts = builder.translation("gui.worldhandler.config.settings.shortcuts").comment("Whether or not to display a row of quick access buttons at the top").define("shortcuts", false);
        this.shortcutKeys = builder.translation("gui.worldhandler.config.settings.key_shortcuts").comment("Whether or not to enable button keys for pos1 and pos2").define("key_shortcuts", false);
        this.tooltips = builder.translation("gui.worldhandler.config.settings.tooltips").comment("Whether or not to display tooltips for buttons").define("tooltips", true);
        this.watch = builder.translation("gui.worldhandler.config.settings.watch").comment("Whether or not to display a watch").define("watch", true);
        this.smoothWatch = builder.translation("gui.worldhandler.config.settings.smooth_watch").comment("Whether or not the watch pointers move smoothly").define("smooth_watch", true);
        this.pause = builder.translation("gui.worldhandler.config.settings.pause_game").comment("Whether or not to pause the game when the gui is opened").define("pause_game", false);
        this.customTimes = builder.translation("gui.worldhandler.config.settings.custom_times").comment("Whether or not to use the custom times").define("custom_times", false);
        this.permissionQuery = builder.translation("gui.worldhandler.config.settings.permission_query").comment("Whether or not the permission query is enabled").define("permission_query", true);
        this.highlightBlocks = builder.translation("gui.worldhandler.config.settings.highlight_blocks").comment("Whether or not selected blocks will be highlighted").define("highlight_blocks", true);
        this.dawn = builder.translation("gui.worldhandler.config.settings.custom_time_dawn").comment("Ticks upon dawn").defineInRange("custom_time_dawn", 1000, 0, 24000);
        this.noon = builder.translation("gui.worldhandler.config.settings.custom_time_noon").comment("Ticks upon noon").defineInRange("custom_time_noon", 6000, 0, 24000);
        this.sunset = builder.translation("gui.worldhandler.config.settings.custom_time_sunset").comment("Ticks upon sunset").defineInRange("custom_time_sunset", 12500, 0, 24000);
        this.midnight = builder.translation("gui.worldhandler.config.settings.custom_time_midnight").comment("Ticks upon midnight").defineInRange("custom_time_midnight", 18000, 0, 24000);
        this.blockPlacingMode = builder.translation("gui.worldhandler.config.settings.block_placing_mode").comment("Block placing mode (keep, replace, destroy)").defineEnum("block_placing_mode", (Enum)BuilderSetBlock.EnumMode.KEEP, (Enum[])BuilderSetBlock.EnumMode.values());
        builder.pop();
    }

    public boolean commandSyntax() {
        return (Boolean)this.commandSyntax.get();
    }

    public void setCommandSyntax(boolean enabled) {
        Config.set(this.commandSyntax, enabled);
    }

    public boolean shortcuts() {
        return (Boolean)this.shortcuts.get();
    }

    public void setShortcuts(boolean enabled) {
        Config.set(this.shortcuts, enabled);
    }

    public boolean shortcutKeys() {
        return (Boolean)this.shortcutKeys.get();
    }

    public void setShortcutKeys(boolean enabled) {
        Config.set(this.shortcutKeys, enabled);
    }

    public boolean tooltips() {
        return (Boolean)this.tooltips.get();
    }

    public void setTooltips(boolean enabled) {
        Config.set(this.tooltips, enabled);
    }

    public boolean watch() {
        return (Boolean)this.watch.get();
    }

    public void setWatch(boolean enabled) {
        Config.set(this.watch, enabled);
    }

    public boolean smoothWatch() {
        return (Boolean)this.smoothWatch.get();
    }

    public void setSmoothWatch(boolean enabled) {
        Config.set(this.smoothWatch, enabled);
    }

    public boolean pause() {
        return (Boolean)this.pause.get();
    }

    public void setPause(boolean enabled) {
        Config.set(this.pause, enabled);
    }

    public boolean customTimes() {
        return (Boolean)this.customTimes.get();
    }

    public void setCustomTimes(boolean enabled) {
        Config.set(this.customTimes, enabled);
    }

    public boolean permissionQuery() {
        return (Boolean)this.permissionQuery.get();
    }

    public void setPermissionQuery(boolean enabled) {
        Config.set(this.permissionQuery, enabled);
    }

    public boolean highlightBlocks() {
        return (Boolean)this.highlightBlocks.get();
    }

    public void setHighlightBlocks(boolean enabled) {
        Config.set(this.highlightBlocks, enabled);
    }

    public int getDawn() {
        return (Integer)this.dawn.get();
    }

    public void setDawn(int ticks) {
        Config.set(this.dawn, ticks);
    }

    public int getNoon() {
        return (Integer)this.noon.get();
    }

    public void setNoon(int ticks) {
        Config.set(this.noon, ticks);
    }

    public int getSunset() {
        return (Integer)this.sunset.get();
    }

    public void setSunset(int ticks) {
        Config.set(this.sunset, ticks);
    }

    public int getMidnight() {
        return (Integer)this.midnight.get();
    }

    public void setMidnight(int ticks) {
        Config.set(this.midnight, ticks);
    }

    public BuilderSetBlock.EnumMode getBlockPlacingMode() {
        return (BuilderSetBlock.EnumMode)((Object)this.blockPlacingMode.get());
    }

    public void setBlockPlacingMode(BuilderSetBlock.EnumMode mode) {
        Config.set(this.blockPlacingMode, mode);
    }
}

