/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.util.ActionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiButtonPiano
extends GuiButtonBase {
    private static final ResourceLocation NOTE = new ResourceLocation("worldhandler", "textures/misc/note.png");
    private final Type type;
    private final SoundEvent sound;
    private final float pitch;

    public GuiButtonPiano(int x, int y, int widthIn, int heightIn, String buttonText, SoundEvent sound, float pitch, Type type, ActionHandler actionHandler) {
        super(x, y, widthIn, heightIn, buttonText, actionHandler);
        this.sound = sound;
        this.pitch = pitch;
        this.type = type;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        switch (this.type) {
            case LEFT: {
                this.isHovered = this.isHoveringLeft(mouseX, mouseY);
                break;
            }
            case NORMAL: {
                this.isHovered = this.isHoveringNormal(mouseX, mouseY);
                break;
            }
            case RIGHT: {
                this.isHovered = this.isHoveringRight(mouseX, mouseY);
                break;
            }
            case BLACK: {
                this.isHovered = this.isHoveringBlack(mouseX, mouseY);
                break;
            }
        }
        int hoverstate = this.getYImage(this.isHovered);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Config.getSkin().getButtonAlphaF());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(NOTE);
        switch (this.type) {
            case LEFT: 
            case NORMAL: 
            case RIGHT: {
                this.drawWhiteKey(hoverstate);
                break;
            }
            case BLACK: {
                this.drawBlackKey(hoverstate);
                break;
            }
        }
    }

    protected void drawWhiteKey(int hoverstate) {
        int textColor = this.getFGColor();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.blit(this.x, this.y, 25 + hoverstate * 15 - 15, 0, 15, 92);
        fontRenderer.func_211126_b(this.getMessage(), (float)(this.x + this.width / 2 - fontRenderer.func_78256_a(this.getMessage()) / 2), (float)(this.y + (this.height - 8) / 2 + 36), textColor);
    }

    protected void drawBlackKey(int hoverstate) {
        this.blit(this.x, this.y, 55 + hoverstate * -9 + 18, 0, 9, 58);
    }

    public int getFGColor() {
        int textColor = 0;
        if (!this.active) {
            textColor = 0xA0A0A0;
        } else if (this.isHovered()) {
            textColor = 0x8B8B8B;
        }
        return textColor;
    }

    public void playDownSound(SoundHandler soundHandler) {
        soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)this.sound, (float)this.pitch));
    }

    private boolean isHoveringBlack(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    private boolean isHoveringLeft(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + 10) && mouseY < (double)(this.y + 60) || mouseX >= (double)this.x && mouseY >= (double)(this.y + 58) && mouseX < (double)(this.x + 14) && mouseY < (double)(this.y + 93);
    }

    private boolean isHoveringNormal(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x + 4) && mouseY >= (double)this.y && mouseX < (double)(this.x + 10) && mouseY < (double)(this.y + 60) || mouseX >= (double)this.x && mouseY >= (double)(this.y + 58) && mouseX < (double)(this.x + 14) && mouseY < (double)(this.y + 93);
    }

    private boolean isHoveringRight(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x + 4) && mouseY >= (double)this.y && mouseX < (double)(this.x + 14) && mouseY < (double)(this.y + 60) || mouseX >= (double)this.x && mouseY >= (double)(this.y + 58) && mouseX < (double)(this.x + 14) && mouseY < (double)(this.y + 93);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        switch (this.type) {
            case LEFT: {
                return this.active && this.visible && this.isHoveringLeft(mouseX, mouseY);
            }
            case NORMAL: {
                return this.active && this.visible && this.isHoveringNormal(mouseX, mouseY);
            }
            case RIGHT: {
                return this.active && this.visible && this.isHoveringRight(mouseX, mouseY);
            }
            case BLACK: {
                return this.active && this.visible && this.isHoveringBlack(mouseX, mouseY);
            }
        }
        return false;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        LEFT,
        NORMAL,
        RIGHT,
        BLACK;

    }
}

