/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.gui.DummyScreen;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.Connection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.MultiplayerWarningScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.I18n;
import net.minecraft.realms.RealmsBridge;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentChangeWorld
extends ContentChild {
    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        container.add(new GuiButtonBase(x + 58, y + 24, 116, 20, I18n.func_135052_a((String)"gui.worldhandler.change_world.singleplayer", (Object[])new Object[0]), () -> {
            Connection connection = ContentChangeWorld.disconnect();
            Minecraft.func_71410_x().func_147108_a((Screen)new WorldSelectionScreen((Screen)new DummyScreen(() -> ContentChangeWorld.reconnect(connection))));
        }));
        container.add(new GuiButtonBase(x + 58, y + 48, 116, 20, I18n.func_135052_a((String)"gui.worldhandler.change_world.multiplayer", (Object[])new Object[0]), () -> {
            Connection connection = ContentChangeWorld.disconnect();
            DummyScreen dummy = new DummyScreen(() -> ContentChangeWorld.reconnect(connection));
            if (Minecraft.func_71410_x().field_71474_y.field_230152_Z_) {
                Minecraft.func_71410_x().func_147108_a((Screen)new MultiplayerScreen((Screen)dummy));
            } else {
                Minecraft.func_71410_x().func_147108_a((Screen)new MultiplayerWarningScreen((Screen)dummy));
            }
        }));
    }

    private static Connection disconnect() {
        boolean isIntegrated = Minecraft.func_71410_x().func_71387_A();
        boolean isRealms = Minecraft.func_71410_x().func_181540_al();
        ServerData data = Minecraft.func_71410_x().func_147104_D();
        if (isIntegrated) {
            String worldName = Minecraft.func_71410_x().func_71401_C().func_71221_J();
            String folderName = Minecraft.func_71410_x().func_71401_C().func_71270_I();
            Minecraft.func_71410_x().field_71441_e.func_72882_A();
            Minecraft.func_71410_x().func_213231_b((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("menu.savingLevel", new Object[0])));
            return new Connection.IntegratedConnection(Connection.Type.INTEGRATED, worldName, folderName);
        }
        Minecraft.func_71410_x().field_71441_e.func_72882_A();
        Minecraft.func_71410_x().func_213254_o();
        if (isRealms) {
            return null;
        }
        return new Connection.DedicatedConnection(Connection.Type.DEDICATED, data);
    }

    private static void reconnect(Connection connection) {
        if (connection == null) {
            RealmsBridge realmsbridge = new RealmsBridge();
            realmsbridge.switchToRealms((Screen)new MainMenuScreen());
        } else if (connection instanceof Connection.IntegratedConnection) {
            Connection.IntegratedConnection integrated = (Connection.IntegratedConnection)connection;
            Minecraft.func_71410_x().func_71371_a(integrated.getFolderName(), integrated.getWorldName(), null);
            Minecraft.func_71410_x().field_71417_B.func_198034_i();
        } else if (connection instanceof Connection.DedicatedConnection) {
            Connection.DedicatedConnection dedicated = (Connection.DedicatedConnection)connection;
            Minecraft.func_71410_x().func_147108_a((Screen)new ConnectingScreen((Screen)new MainMenuScreen(), Minecraft.func_71410_x(), dedicated.getData()));
            Minecraft.func_71410_x().field_71417_B.func_198034_i();
        }
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.change_world", (Object[])new Object[0]);
    }
}

