/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderCustomItem;
import exopandora.worldhandler.builder.impl.EnumAttributes;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.button.LogicSliderAttribute;
import exopandora.worldhandler.gui.button.LogicSliderSimple;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.menu.impl.MenuColorField;
import exopandora.worldhandler.gui.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.ResourceHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ContentCustomItem
extends Content {
    private GuiTextFieldTooltip itemField;
    private GuiTextFieldTooltip itemLore1Field;
    private GuiTextFieldTooltip itemLore2Field;
    private final BuilderCustomItem builderCutomItem = new BuilderCustomItem();
    private int startPage;
    private Page page = Page.START;
    private String item;
    private final List<EnumAttributes> attributes = Stream.concat(EnumAttributes.getAttributesFor(EnumAttributes.Applyable.BOTH).stream(), EnumAttributes.getAttributesFor(EnumAttributes.Applyable.PLAYER).stream()).collect(Collectors.toList());

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderCutomItem;
    }

    @Override
    public void init(Container container) {
        for (EnumAttributes attribute : this.builderCutomItem.getAttributes()) {
            double ammount = this.builderCutomItem.getAttributeAmmount(attribute);
            if (!(ammount > Config.getSliders().getMaxItemAttributes())) continue;
            this.builderCutomItem.setAttribute(attribute, Config.getSliders().getMaxItemAttributes());
        }
        for (Enchantment enchantment : this.builderCutomItem.getEnchantments()) {
            short level = this.builderCutomItem.getEnchantmentLevel(enchantment);
            if (!((double)level > Config.getSliders().getMaxItemEnchantment())) continue;
            this.builderCutomItem.setEnchantment(enchantment, (short)Config.getSliders().getMaxItemEnchantment());
        }
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        this.itemField = new GuiTextFieldTooltip(x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.custom_item.start.item_id", (Object[])new Object[0]));
        this.itemField.func_200675_a((Predicate)Predicates.notNull());
        this.itemField.func_146180_a(this.item);
        this.itemField.func_212954_a(text -> {
            this.item = text;
            this.builderCutomItem.setItem(this.item);
            container.initButtons();
        });
        this.itemLore1Field = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.custom_item.start.lore_1", (Object[])new Object[0]));
        this.itemLore1Field.func_200675_a((Predicate)Predicates.notNull());
        this.itemLore1Field.func_146180_a(this.builderCutomItem.getLore1());
        this.itemLore1Field.func_212954_a(text -> {
            this.builderCutomItem.setLore1((String)text);
            container.initButtons();
        });
        this.itemLore2Field = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.custom_item.start.lore_2", (Object[])new Object[0]));
        this.itemLore2Field.func_200675_a((Predicate)Predicates.notNull());
        this.itemLore2Field.func_146180_a(this.builderCutomItem.getLore2());
        this.itemLore2Field.func_212954_a(text -> {
            this.builderCutomItem.setLore2((String)text);
            container.initButtons();
        });
        if (Page.START.equals((Object)this.page)) {
            if (this.startPage == 1) {
                container.add(new MenuColorField(x, y, "gui.worldhandler.items.custom_item.start.custom_name", this.builderCutomItem.getName()));
            }
        } else if (Page.ENCHANT.equals((Object)this.page)) {
            MenuPageList<Enchantment> enchantments = new MenuPageList<Enchantment>(x + 118, y, new ArrayList(ForgeRegistries.ENCHANTMENTS.getValues()), 114, 20, 3, container, new ILogicPageList<Enchantment>(){

                @Override
                public String translate(Enchantment item) {
                    return I18n.func_135052_a((String)item.func_77320_a(), (Object[])new Object[0]);
                }

                @Override
                public String toTooltip(Enchantment item) {
                    return item.getRegistryName().toString();
                }

                @Override
                public void onClick(Enchantment item) {
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, String text, Enchantment item, ActionHandler actionHandler) {
                    return new GuiSlider(x, y, width, height, 0.0, Config.getSliders().getMaxItemEnchantment(), 0.0, container, new LogicSliderSimple(this.toTooltip(item), text, value -> ContentCustomItem.this.builderCutomItem.setEnchantment(item, value.shortValue())));
                }

                @Override
                public boolean doDisable() {
                    return false;
                }

                @Override
                public String getId() {
                    return "enchantments";
                }
            });
            container.add(enchantments);
        } else if (Page.ATTRIBUTES.equals((Object)this.page)) {
            MenuPageList<EnumAttributes> attributes = new MenuPageList<EnumAttributes>(x + 118, y, this.attributes, 114, 20, 3, container, new ILogicPageList<EnumAttributes>(){

                @Override
                public String translate(EnumAttributes item) {
                    return item.getTranslation();
                }

                @Override
                public String toTooltip(EnumAttributes item) {
                    return item.getAttribute();
                }

                @Override
                public void onClick(EnumAttributes item) {
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, String text, EnumAttributes item, ActionHandler actionHandler) {
                    return new GuiSlider(x, y, width, height, -Config.getSliders().getMaxItemAttributes(), Config.getSliders().getMaxItemEnchantment(), 0.0, container, new LogicSliderAttribute(item, text, value -> ContentCustomItem.this.builderCutomItem.setAttribute(item, value.intValue())));
                }

                @Override
                public boolean doDisable() {
                    return false;
                }

                @Override
                public String getId() {
                    return "attributes";
                }
            });
            container.add(attributes);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        GuiButtonBase button4;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.custom_item.start", (Object[])new Object[0]), () -> {
            this.page = Page.START;
            container.init();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.custom_item.enchantment", (Object[])new Object[0]), () -> {
            this.page = Page.ENCHANT;
            container.init();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.custom_item.attributes", (Object[])new Object[0]), () -> {
            this.page = Page.ATTRIBUTES;
            container.init();
        });
        container.add(button3);
        if (Page.START.equals((Object)this.page)) {
            button1.active = false;
            GuiButtonBase button5 = new GuiButtonBase(x + 118, y + 72, 56, 20, "<", () -> {
                --this.startPage;
                container.init();
            });
            container.add(button5);
            GuiButtonBase button6 = new GuiButtonBase(x + 118 + 60, y + 72, 55, 20, ">", () -> {
                ++this.startPage;
                container.init();
            });
            container.add(button6);
            if (this.startPage == 0) {
                button5.active = false;
                container.add(this.itemField);
                container.add(this.itemLore1Field);
                container.add(this.itemLore2Field);
            } else if (this.startPage == 1) {
                button6.active = false;
            }
        } else if (Page.ENCHANT.equals((Object)this.page)) {
            button2.active = false;
        } else if (Page.ATTRIBUTES.equals((Object)this.page)) {
            button3.active = false;
        }
        if (!this.builderCutomItem.needsCommandBlock() && !this.builderCutomItem.getName().isSpecial()) {
            button4 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.custom_item.custom_item", (Object[])new Object[0]), this::send);
            container.add(button4);
        } else {
            button4 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]), this::send);
            container.add(button4);
        }
        button4.active = ResourceHelper.isRegistered(ResourceHelper.stringToResourceLocation(this.item), ForgeRegistries.ITEMS);
    }

    private void send() {
        CommandHelper.sendCommand(this.builderCutomItem, this.builderCutomItem.getName().isSpecial());
    }

    @Override
    public void tick(Container container) {
        if (Page.START.equals((Object)this.page) && this.startPage == 0) {
            this.itemField.func_146178_a();
            this.itemLore1Field.func_146178_a();
            this.itemLore2Field.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page) && this.startPage == 0) {
            this.itemField.renderButton(mouseX, mouseY, partialTicks);
            this.itemLore1Field.renderButton(mouseX, mouseY, partialTicks);
            this.itemLore2Field.renderButton(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public Category getCategory() {
        return Categories.ITEMS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.items.custom_item", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.items.custom_item", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.CUSTOM_ITEM;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderCutomItem.setPlayer(username);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Page {
        START,
        ENCHANT,
        ATTRIBUTES;

    }
}

