/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderExperience;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.LogicSliderSimple;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentExperience
extends Content {
    private final BuilderExperience builderExperience = new BuilderExperience();
    private GuiButtonBase buttonAdd;
    private GuiButtonBase buttonRemove;

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderExperience;
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderExperience.getLevel() > Config.getSliders().getMaxExperience()) {
            this.builderExperience.setLevel((int)Config.getSliders().getMaxExperience());
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        boolean enabled;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        container.add(new GuiSlider(x + 58, y, 114, 20, 0.0, Config.getSliders().getMaxExperience(), 0.0, container, new LogicSliderSimple("experience", I18n.func_135052_a((String)"gui.worldhandler.title.player.experience", (Object[])new Object[0]), value -> this.builderExperience.setLevel((int)value))));
        this.buttonAdd = new GuiButtonBase(x + 58, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]), () -> {
            CommandHelper.sendCommand(this.builderExperience.getBuilderForAddLevels());
            container.init();
        });
        container.add(this.buttonAdd);
        this.buttonRemove = new GuiButtonBase(x + 58, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.remove", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderExperience.getBuilderForRemoveLevels()));
        container.add(this.buttonRemove);
        container.add(new GuiButtonTooltip(x + 58, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.reset", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.set_to_0", (Object[])new Object[0]), () -> {
            CommandHelper.sendCommand(this.builderExperience.getBuilderForResetLevels());
            container.init();
        }));
        this.buttonAdd.active = enabled = this.builderExperience.getLevel() > 0;
        this.buttonRemove.active = enabled;
    }

    @Override
    public void tick(Container container) {
        boolean enabled;
        this.buttonAdd.active = enabled = this.builderExperience.getLevel() > 0;
        this.buttonRemove.active = enabled;
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.player.experience", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.player.experience", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.EXPERIENCE;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderExperience.setPlayer(username);
    }
}

