/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderRecipe;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentRecipes
extends Content {
    private final BuilderRecipe builderRecipe = new BuilderRecipe();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderRecipe;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        List recipes = Minecraft.func_71410_x().field_71439_g.func_199507_B().func_199642_d().stream().flatMap(recipe -> recipe.func_192711_b().stream()).filter(recipe -> !recipe.func_192399_d()).collect(Collectors.toList());
        MenuPageList list = new MenuPageList(x, y, recipes, 114, 20, 3, container, new ILogicPageList<IRecipe<?>>(){

            @Override
            public String translate(IRecipe<?> item) {
                if (!item.func_77571_b().equals(ItemStack.field_190927_a)) {
                    return item.func_77571_b().func_200301_q().func_150254_d();
                }
                return item.func_199560_c().toString();
            }

            @Override
            public String toTooltip(IRecipe<?> item) {
                return item.func_199560_c().toString();
            }

            @Override
            public void onClick(IRecipe<?> item) {
                ContentRecipes.this.builderRecipe.setRecipe(item);
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, String text, IRecipe<?> item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, text, this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "recipe";
            }
        });
        container.add(list);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.recipes.give", (Object[])new Object[0]), () -> {
            CommandHelper.sendCommand(this.builderRecipe.getBuilderForMode(BuilderRecipe.EnumMode.GIVE));
            container.initButtons();
        }));
        container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.recipes.take", (Object[])new Object[0]), () -> {
            CommandHelper.sendCommand(this.builderRecipe.getBuilderForMode(BuilderRecipe.EnumMode.TAKE));
            container.initButtons();
        }));
    }

    @Override
    public Category getCategory() {
        return Categories.ITEMS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.items.recipes", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.items.recipes", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.RECIPES;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderRecipe.setPlayer(username);
    }
}

