/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderScoreboardObjectives;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.impl.ContentScoreboard;
import exopandora.worldhandler.gui.menu.impl.ILogicButtonList;
import exopandora.worldhandler.gui.menu.impl.MenuButtonList;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.RegistryHelper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ContentScoreboardObjectives
extends ContentScoreboard {
    private GuiTextFieldTooltip objectField;
    private Page page = Page.CREATE;
    private final BuilderScoreboardObjectives builderObjectives = new BuilderScoreboardObjectives();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderObjectives;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.objectField = new GuiTextFieldTooltip(x + 118, y + this.page.getShift(), 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.objective", (Object[])new Object[0]));
        this.objectField.func_200675_a((Predicate)Predicates.notNull());
        this.objectField.func_146180_a(ContentScoreboard.getObjective());
        this.objectField.func_212954_a(text -> {
            ContentScoreboard.setObjective(text);
            this.builderObjectives.setObjective(ContentScoreboard.getObjective());
            container.initButtons();
        });
        if (Page.CREATE.equals((Object)this.page)) {
            MenuButtonList objectives = new MenuButtonList(x + 118, y + 24, HELPER.getObjectives(), 2, new ILogicButtonList(){

                @Override
                public String translate(String key, int depth) {
                    String translation;
                    ResourceLocation resource = this.makeResourceLocation(key);
                    if (resource != null) {
                        StatType type = (StatType)ForgeRegistries.STAT_TYPES.getValue(resource);
                        if (type != null) {
                            if (type.equals(Stats.field_199092_j)) {
                                return I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.stat.custom", (Object[])new Object[0]);
                            }
                            if (type.equals(Stats.field_199090_h)) {
                                return I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.stat.killed", (Object[])new Object[0]);
                            }
                            if (type.equals(Stats.field_199091_i)) {
                                return I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.stat.killed_by", (Object[])new Object[0]);
                            }
                            return I18n.func_135052_a((String)type.func_199078_c(), (Object[])new Object[0]);
                        }
                        String translation2 = RegistryHelper.translate(resource);
                        if (translation2 != null) {
                            return I18n.func_135052_a((String)translation2, (Object[])new Object[0]);
                        }
                    }
                    if (!(translation = "stat." + key).equals(I18n.func_135052_a((String)translation, (Object[])new Object[0]))) {
                        return I18n.func_135052_a((String)translation, (Object[])new Object[0]);
                    }
                    if (Arrays.stream(TextFormatting.values()).map(TextFormatting::func_96297_d).anyMatch((Predicate<String>)Predicates.equalTo((Object)key))) {
                        return I18n.func_135052_a((String)("gui.worldhandler.color." + key), (Object[])new Object[0]);
                    }
                    return I18n.func_135052_a((String)("gui.worldhandler.scoreboard.objectives.stat." + key), (Object[])new Object[0]);
                }

                @Override
                public void onClick(String key, int depth) {
                    ContentScoreboardObjectives.this.builderObjectives.setCriteria(key);
                }

                @Override
                public String buildEventKey(List<String> keys, int depth) {
                    if (this.isRegistryItem(keys.get(keys.size() - 1))) {
                        return String.join((CharSequence)":", keys);
                    }
                    return ILogicButtonList.super.buildEventKey(keys, depth);
                }

                @Override
                public String getId() {
                    return "objectives";
                }

                @Nullable
                private ResourceLocation makeResourceLocation(String key) {
                    return ResourceLocation.func_208304_a((String)key.replace(".", ":"));
                }

                @Nullable
                private boolean isRegistryItem(String key) {
                    return this.isRegistryItem(this.makeResourceLocation(key));
                }

                @Nullable
                private boolean isRegistryItem(ResourceLocation resource) {
                    IForgeRegistry[] registries;
                    for (IForgeRegistry registry : registries = new IForgeRegistry[]{ForgeRegistries.BLOCKS, ForgeRegistries.ITEMS, ForgeRegistries.ENTITIES}) {
                        if (!registry.containsKey(resource)) continue;
                        return true;
                    }
                    return ForgeRegistries.STAT_TYPES.containsKey(resource);
                }
            });
            container.add(objectives);
        } else if (Page.DISPLAY.equals((Object)this.page) || Page.UNDISPLAY.equals((Object)this.page)) {
            MenuButtonList slots = new MenuButtonList(x + 118, y + 24 - this.page.getShift(), HELPER.getSlots(), 2, new ILogicButtonList(){

                @Override
                public String translate(String key, int depth) {
                    if (depth == 0) {
                        return I18n.func_135052_a((String)("gui.worldhandler.scoreboard.slot." + key), (Object[])new Object[0]);
                    }
                    if (depth == 1) {
                        return I18n.func_135052_a((String)("gui.worldhandler.color." + key), (Object[])new Object[0]);
                    }
                    return key;
                }

                @Override
                public void onClick(String key, int depth) {
                    ContentScoreboardObjectives.this.builderObjectives.setSlot(key);
                }

                @Override
                public String getId() {
                    return "slots";
                }
            });
            container.add(slots);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.create", (Object[])new Object[0]), () -> {
            this.page = Page.CREATE;
            container.init();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.display", (Object[])new Object[0]), () -> {
            this.page = Page.DISPLAY;
            container.init();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.undisplay", (Object[])new Object[0]), () -> {
            this.page = Page.UNDISPLAY;
            container.init();
        });
        container.add(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.remove", (Object[])new Object[0]), () -> {
            this.page = Page.REMOVE;
            container.init();
        });
        container.add(button4);
        button1.active = !Page.CREATE.equals((Object)this.page);
        button2.active = !Page.DISPLAY.equals((Object)this.page);
        button3.active = !Page.UNDISPLAY.equals((Object)this.page);
        boolean bl = button4.active = !Page.REMOVE.equals((Object)this.page);
        if (Page.UNDISPLAY.equals((Object)this.page)) {
            this.builderObjectives.setObjective(null);
        } else if (Page.REMOVE.equals((Object)this.page)) {
            this.builderObjectives.setMode(BuilderScoreboardObjectives.EnumMode.REMOVE);
        }
        if (!Page.UNDISPLAY.equals((Object)this.page)) {
            container.add(this.objectField);
            this.builderObjectives.setObjective(ContentScoreboard.getObjective());
        }
        button1 = new GuiButtonBase(x + 118, y + 72 - this.page.getShift(), 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.perform", (Object[])new Object[0]), () -> {
            CommandHelper.sendCommand(this.builderObjectives);
            container.init();
        });
        container.add(button1);
        button1.active = Page.UNDISPLAY.equals((Object)this.page) || ContentScoreboard.isObjectiveValid();
    }

    @Override
    public void tick(Container container) {
        if (!Page.UNDISPLAY.equals((Object)this.page)) {
            this.objectField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (!Page.UNDISPLAY.equals((Object)this.page)) {
            this.objectField.renderButton(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.scoreboard.objectives", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_OBJECTIVES;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Page {
        CREATE(0),
        DISPLAY(0),
        UNDISPLAY(12),
        REMOVE(24);

        private final int shift;

        private Page(int shift) {
            this.shift = shift;
        }

        public int getShift() {
            return this.shift;
        }
    }
}

