/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderMultiCommand;
import exopandora.worldhandler.builder.impl.BuilderScoreboardPlayers;
import exopandora.worldhandler.builder.impl.BuilderTag;
import exopandora.worldhandler.builder.impl.BuilderTrigger;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.button.LogicSliderSimple;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.impl.ContentScoreboard;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentScoreboardPlayers
extends ContentScoreboard {
    private GuiTextFieldTooltip objectField;
    private GuiTextFieldTooltip tagField;
    private final BuilderScoreboardPlayers builderPlayers = new BuilderScoreboardPlayers();
    private final BuilderTag builderTag = new BuilderTag();
    private final BuilderTrigger builderTrigger = new BuilderTrigger();
    private final BuilderMultiCommand builderTriggerMulti = new BuilderMultiCommand(this.builderTrigger, this.builderPlayers);
    private Page page = Page.ADD_SET_REMOVE;
    private String tag;
    private GuiButtonBase addButton;
    private GuiButtonBase removeButton;

    @Override
    public ICommandBuilder getCommandBuilder() {
        if (Page.ADD_SET_REMOVE.equals((Object)this.page)) {
            return this.builderPlayers;
        }
        if (Page.TAG.equals((Object)this.page)) {
            return this.builderTag;
        }
        if (Page.ENABLE.equals((Object)this.page)) {
            return this.builderTriggerMulti;
        }
        return null;
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderPlayers.getPoints() > Config.getSliders().getMaxPlayerPoints()) {
            this.builderPlayers.setPoints((int)Config.getSliders().getMaxPlayerPoints());
        }
        if ((double)this.builderTrigger.getValue() > Config.getSliders().getMaxTriggerValue()) {
            this.builderTrigger.setValue((int)Config.getSliders().getMaxTriggerValue());
        }
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.objectField = new GuiTextFieldTooltip(x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.objective", (Object[])new Object[0]));
        this.objectField.func_200675_a((Predicate)Predicates.notNull());
        this.objectField.func_146180_a(ContentScoreboard.getObjective());
        this.objectField.func_212954_a(text -> {
            ContentScoreboard.setObjective(text);
            this.builderPlayers.setObjective(ContentScoreboard.getObjective());
            this.builderTrigger.setObjective(ContentScoreboard.getObjective());
            container.initButtons();
        });
        this.tagField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.tag", (Object[])new Object[0]));
        this.tagField.func_200675_a(string -> string != null && !string.contains(" "));
        this.tagField.func_146180_a(this.tag);
        this.tagField.func_212954_a(text -> {
            this.tag = text;
            this.builderTag.setName(this.tag);
            container.initButtons();
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.points", (Object[])new Object[0]), () -> {
            this.page = Page.ADD_SET_REMOVE;
            container.init();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.tag", (Object[])new Object[0]), () -> {
            this.page = Page.TAG;
            container.init();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.trigger", (Object[])new Object[0]), () -> {
            this.page = Page.ENABLE;
            container.init();
        });
        container.add(button3);
        button1.active = !Page.ADD_SET_REMOVE.equals((Object)this.page);
        button2.active = !Page.TAG.equals((Object)this.page);
        button3.active = !Page.ENABLE.equals((Object)this.page);
        boolean enabled = ContentScoreboard.isObjectiveValid();
        this.builderPlayers.setMode(this.page.getMode());
        if (Page.ADD_SET_REMOVE.equals((Object)this.page)) {
            boolean points;
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, Config.getSliders().getMaxPlayerPoints(), 0.0, container, new LogicSliderSimple("points", I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.points", (Object[])new Object[0]), value -> this.builderPlayers.setPoints((int)value))));
            this.addButton = new GuiButtonBase(x + 118, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPlayers.getBuilderForPoints(BuilderScoreboardPlayers.EnumMode.ADD));
                container.init();
            });
            container.add(this.addButton);
            this.removeButton = new GuiButtonBase(x + 118 + 57 + 1, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.remove", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPlayers.getBuilderForPoints(BuilderScoreboardPlayers.EnumMode.REMOVE));
                container.init();
            });
            container.add(this.removeButton);
            button1 = new GuiButtonTooltip(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.reset", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.set_to_0", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPlayers.getBuilderForPoints(BuilderScoreboardPlayers.EnumMode.SET, 0));
                container.init();
            });
            container.add(button1);
            this.addButton.active = points = enabled && this.builderPlayers.getPoints() > 0;
            this.removeButton.active = points;
            button1.active = enabled;
        } else if (Page.TAG.equals((Object)this.page)) {
            boolean tag;
            button1 = new GuiButtonBase(x + 118, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTag.getBuilderForMode(BuilderTag.EnumMode.ADD));
                container.init();
            });
            container.add(button1);
            button2 = new GuiButtonBase(x + 118, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.remove", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTag.getBuilderForMode(BuilderTag.EnumMode.REMOVE));
                container.init();
            });
            container.add(button2);
            button1.active = tag = this.tag != null && !this.tag.isEmpty();
            button2.active = tag;
        } else if (Page.ENABLE.equals((Object)this.page)) {
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, Config.getSliders().getMaxTriggerValue(), 0.0, container, new LogicSliderSimple("enable", I18n.func_135052_a((String)"gui.worldhandler.generic.value", (Object[])new Object[0]), value -> this.builderTrigger.setValue((int)value))));
            this.addButton = new GuiButtonBase(x + 118, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTrigger.getBuilderForMode(BuilderTrigger.EnumMode.ADD));
                container.init();
            });
            container.add(this.addButton);
            this.removeButton = new GuiButtonBase(x + 118 + 57 + 1, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.set", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTrigger.getBuilderForMode(BuilderTrigger.EnumMode.SET));
                container.init();
            });
            container.add(this.removeButton);
            button1 = new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.enable", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPlayers.getBuilderForEnable());
                container.init();
            });
            container.add(button1);
            this.addButton.active = enabled && this.builderTrigger.getValue() > 0;
            this.removeButton.active = enabled;
            button1.active = enabled;
        }
        if (Page.TAG.equals((Object)this.page)) {
            container.add(this.tagField);
        } else {
            container.add(this.objectField);
            this.builderPlayers.setObjective(ContentScoreboard.getObjective());
            this.builderTrigger.setObjective(ContentScoreboard.getObjective());
        }
    }

    @Override
    public void tick(Container container) {
        if (Page.TAG.equals((Object)this.page)) {
            this.tagField.func_146178_a();
        } else {
            boolean enabled = ContentScoreboard.isObjectiveValid();
            if (Page.ADD_SET_REMOVE.equals((Object)this.page)) {
                boolean points;
                this.addButton.active = points = enabled && this.builderPlayers.getPoints() > 0;
                this.removeButton.active = points;
            } else if (Page.ENABLE.equals((Object)this.page)) {
                this.addButton.active = enabled && this.builderTrigger.getValue() > 0;
                this.removeButton.active = enabled;
            }
            this.objectField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.TAG.equals((Object)this.page)) {
            this.tagField.renderButton(mouseX, mouseY, partialTicks);
        } else {
            this.objectField.renderButton(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.scoreboard.players", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_PLAYERS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderPlayers.setPlayer(username);
        this.builderTag.setPlayer(username);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Page {
        ADD_SET_REMOVE("add|set|remove"),
        TAG("tag"),
        ENABLE("enable");

        private final String mode;

        private Page(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }
    }
}

