/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderTeams;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.impl.ContentScoreboard;
import exopandora.worldhandler.gui.menu.impl.ILogicButtonList;
import exopandora.worldhandler.gui.menu.impl.MenuButtonList;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentScoreboardTeams
extends ContentScoreboard {
    private GuiTextFieldTooltip teamField;
    private String team;
    private Page page = Page.ADD;
    private final BuilderTeams builderTeams = new BuilderTeams();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderTeams;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.teamField = new GuiTextFieldTooltip(x + 118, y + this.page.getShift(), 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.team", (Object[])new Object[0]));
        this.teamField.func_200675_a((Predicate)Predicates.notNull());
        this.teamField.func_146180_a(this.team);
        this.teamField.func_212954_a(text -> {
            this.team = text;
            this.builderTeams.setTeam(this.team);
            container.initButtons();
        });
        if (Page.OPTION.equals((Object)this.page)) {
            MenuButtonList options = new MenuButtonList(x + 118, y + 24, HELPER.getOptions(), 2, new ILogicButtonList(){

                @Override
                public String translate(String key, int depth) {
                    if (depth == 0) {
                        return I18n.func_135052_a((String)("gui.worldhandler.scoreboard.team.options." + key), (Object[])new Object[0]);
                    }
                    if (depth == 1) {
                        if (Arrays.stream(TextFormatting.values()).map(TextFormatting::func_96297_d).anyMatch((Predicate<String>)Predicates.equalTo((Object)key))) {
                            return I18n.func_135052_a((String)("gui.worldhandler.color." + key), (Object[])new Object[0]);
                        }
                        return I18n.func_135052_a((String)("gui.worldhandler.scoreboard.team.suboption." + key), (Object[])new Object[0]);
                    }
                    return key;
                }

                @Override
                public String buildEventKey(List<String> keys, int depth) {
                    return ILogicButtonList.super.buildTranslationKey(keys, depth);
                }

                @Override
                public void onClick(String key, int depth) {
                    if (depth == 0) {
                        ContentScoreboardTeams.this.builderTeams.setRule(key);
                    } else if (depth == 1) {
                        ContentScoreboardTeams.this.builderTeams.setValue(key);
                    }
                }

                @Override
                public String getId() {
                    return "options";
                }
            });
            container.add(options);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        boolean enabled;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.create", (Object[])new Object[0]), () -> {
            this.page = Page.ADD;
            container.init();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.join", (Object[])new Object[0]) + " / " + I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.leave", (Object[])new Object[0]), () -> {
            this.page = Page.JOIN_OR_LEAVE;
            container.init();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.remove", (Object[])new Object[0]) + " / " + I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.empty", (Object[])new Object[0]), () -> {
            this.page = Page.REMOVE_OR_EMPTY;
            container.init();
        });
        container.add(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.options", (Object[])new Object[0]), () -> {
            this.page = Page.OPTION;
            container.init();
        });
        container.add(button4);
        button1.active = !Page.ADD.equals((Object)this.page);
        button2.active = !Page.JOIN_OR_LEAVE.equals((Object)this.page);
        button3.active = !Page.REMOVE_OR_EMPTY.equals((Object)this.page);
        button4.active = !Page.OPTION.equals((Object)this.page);
        this.builderTeams.setMode(this.page.getMode());
        boolean bl = enabled = this.team != null && this.team.length() > 0;
        if (Page.ADD.equals((Object)this.page)) {
            this.builderTeams.setTeam(this.team);
        } else if (Page.JOIN_OR_LEAVE.equals((Object)this.page)) {
            this.builderTeams.setPlayer(container.getPlayer());
            button1 = new GuiButtonBase(x + 118, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.join", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams.getBuilderForMode(BuilderTeams.EnumMode.JOIN));
                container.initButtons();
            });
            container.add(button1);
            container.add(new GuiButtonBase(x + 118, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.leave", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams.getBuilderForMode(BuilderTeams.EnumMode.LEAVE));
                container.initButtons();
            }));
            button1.active = enabled;
        } else if (Page.REMOVE_OR_EMPTY.equals((Object)this.page)) {
            button1 = new GuiButtonBase(x + 118, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.remove", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams.getBuilderForMode(BuilderTeams.EnumMode.REMOVE));
                container.initButtons();
            });
            container.add(button1);
            button2 = new GuiButtonBase(x + 118, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.empty", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams.getBuilderForMode(BuilderTeams.EnumMode.EMPTY));
                container.initButtons();
            });
            container.add(button2);
            button1.active = enabled;
            button2.active = enabled;
        }
        if (Page.ADD.equals((Object)this.page) || Page.OPTION.equals((Object)this.page)) {
            button1 = new GuiButtonBase(x + 118, y + 72 - this.page.getShift(), 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.perform", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams);
                container.initButtons();
            });
            container.add(button1);
            button1.active = enabled;
        }
        container.add(this.teamField);
    }

    @Override
    public void tick(Container container) {
        this.teamField.func_146178_a();
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.teamField.renderButton(mouseX, mouseY, partialTicks);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.scoreboard.teams", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_TEAMS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        if (Page.JOIN_OR_LEAVE.equals((Object)this.page)) {
            this.builderTeams.setPlayer(username);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Page {
        ADD("add", 24),
        JOIN_OR_LEAVE("join|leave", 12),
        REMOVE_OR_EMPTY("remove|empty", 12),
        OPTION("option", 0);

        private final String mode;
        private final int shift;

        private Page(String mode, int shift) {
            this.shift = shift;
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public int getShift() {
            return this.shift;
        }
    }
}

