/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.gui.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentSettings
extends ContentChild {
    private static final List<Setting<?>> SETTINGS = new ArrayList();
    private Setting<?> setting;
    private GuiTextFieldTooltip valueField;

    @Override
    public void initGui(final Container container, int x, int y) {
        MenuPageList settings = new MenuPageList(x, y, SETTINGS, 114, 20, 3, container, new ILogicPageList<Setting<?>>(){

            @Override
            public String translate(Setting<?> item) {
                return I18n.func_135052_a((String)("gui.worldhandler.config.settings." + item.getKey()), (Object[])new Object[0]);
            }

            @Override
            public String toTooltip(Setting<?> item) {
                return null;
            }

            @Override
            public void onClick(Setting<?> item) {
                ContentSettings.this.setting = item;
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, String text, Setting<?> item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, text, this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "settings";
            }
        });
        container.add(settings);
        this.valueField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.value", (Object[])new Object[0]));
        this.valueField.func_200675_a(string -> {
            if (string == null) {
                return false;
            }
            if (!string.isEmpty()) {
                try {
                    Integer.parseInt(string);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        if (this.setting instanceof Setting.BooleanSetting) {
            Setting.BooleanSetting setting = (Setting.BooleanSetting)this.setting;
            GuiButtonBase button1 = new GuiButtonBase(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.enable", (Object[])new Object[0]), () -> {
                setting.set(true);
                container.init();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.disable", (Object[])new Object[0]), () -> {
                setting.set(false);
                container.init();
            });
            container.add(button2);
            boolean enabled = (Boolean)setting.get();
            button1.active = !enabled;
            button2.active = enabled;
        } else if (this.setting instanceof Setting.IntegerSetting) {
            Setting.IntegerSetting setting = (Setting.IntegerSetting)this.setting;
            this.valueField.func_146180_a(String.valueOf(setting.get()));
            container.add(this.valueField);
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.set", (Object[])new Object[0]), () -> {
                String text = this.valueField.func_146179_b();
                if (text.isEmpty()) {
                    setting.set(0);
                } else {
                    setting.set(Integer.parseInt(text));
                }
                container.init();
            }));
        }
    }

    @Override
    public void tick(Container container) {
        if (this.setting instanceof Setting.IntegerSetting) {
            this.valueField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.setting instanceof Setting.IntegerSetting) {
            this.valueField.renderButton(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.settings", (Object[])new Object[0]);
    }

    static {
        SETTINGS.add(new Setting.BooleanSetting("command_syntax", Config.CLIENT.getSettings()::commandSyntax, Config.CLIENT.getSettings()::setCommandSyntax));
        SETTINGS.add(new Setting.BooleanSetting("shortcuts", Config.CLIENT.getSettings()::shortcuts, Config.CLIENT.getSettings()::setShortcuts));
        SETTINGS.add(new Setting.BooleanSetting("key_shortcuts", Config.CLIENT.getSettings()::shortcutKeys, Config.CLIENT.getSettings()::setShortcutKeys));
        SETTINGS.add(new Setting.BooleanSetting("tooltips", Config.CLIENT.getSettings()::tooltips, Config.CLIENT.getSettings()::setTooltips));
        SETTINGS.add(new Setting.BooleanSetting("watch", Config.CLIENT.getSettings()::watch, Config.CLIENT.getSettings()::setWatch));
        SETTINGS.add(new Setting.BooleanSetting("smooth_watch", Config.CLIENT.getSettings()::smoothWatch, Config.CLIENT.getSettings()::setSmoothWatch));
        SETTINGS.add(new Setting.BooleanSetting("pause_game", Config.CLIENT.getSettings()::pause, Config.CLIENT.getSettings()::setPause));
        SETTINGS.add(new Setting.BooleanSetting("custom_times", Config.CLIENT.getSettings()::customTimes, Config.CLIENT.getSettings()::setCustomTimes));
        SETTINGS.add(new Setting.BooleanSetting("permission_query", Config.CLIENT.getSettings()::permissionQuery, Config.CLIENT.getSettings()::setPermissionQuery));
        SETTINGS.add(new Setting.BooleanSetting("highlight_blocks", Config.CLIENT.getSettings()::highlightBlocks, Config.CLIENT.getSettings()::setHighlightBlocks));
        SETTINGS.add(new Setting.IntegerSetting("custom_time_dawn", Config.CLIENT.getSettings()::getDawn, Config.CLIENT.getSettings()::setDawn));
        SETTINGS.add(new Setting.IntegerSetting("custom_time_noon", Config.CLIENT.getSettings()::getNoon, Config.CLIENT.getSettings()::setNoon));
        SETTINGS.add(new Setting.IntegerSetting("custom_time_sunset", Config.CLIENT.getSettings()::getSunset, Config.CLIENT.getSettings()::setSunset));
        SETTINGS.add(new Setting.IntegerSetting("custom_time_midnight", Config.CLIENT.getSettings()::getMidnight, Config.CLIENT.getSettings()::setMidnight));
    }

    public static abstract class Setting<T> {
        private final String key;
        private final Supplier<T> getter;
        private final Consumer<T> setter;

        public Setting(String key, Supplier<T> getter, Consumer<T> setter) {
            this.key = key;
            this.getter = getter;
            this.setter = setter;
        }

        public String getKey() {
            return this.key;
        }

        public T get() {
            return this.getter.get();
        }

        public void set(T value) {
            this.setter.accept(value);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class IntegerSetting
        extends Setting<Integer> {
            public IntegerSetting(String key, Supplier<Integer> getter, Consumer<Integer> setter) {
                super(key, getter, setter);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class BooleanSetting
        extends Setting<Boolean> {
            public BooleanSetting(String key, Supplier<Boolean> getter, Consumer<Boolean> setter) {
                super(key, getter, setter);
            }
        }
    }
}

