/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderSummon;
import exopandora.worldhandler.builder.impl.EnumAttributes;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonItem;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.button.LogicSliderAttribute;
import exopandora.worldhandler.gui.button.LogicSliderSimple;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ContentSummon
extends Content {
    private GuiTextFieldTooltip mobField;
    private GuiTextFieldTooltip customNameField;
    private GuiTextFieldTooltip passengerField;
    private int potionPage = 0;
    private int equipmentPage = 0;
    private Page page = Page.START;
    private String mob;
    private String name;
    private String passenger;
    private final BuilderSummon builderSummon = new BuilderSummon();
    private final List<EnumAttributes> attributes = Stream.concat(EnumAttributes.getAttributesFor(EnumAttributes.Applyable.BOTH).stream(), EnumAttributes.getAttributesFor(EnumAttributes.Applyable.MOB).stream()).collect(Collectors.toList());

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderSummon;
    }

    @Override
    public void init(Container container) {
        for (EnumAttributes attribute : this.builderSummon.getAttributes()) {
            double ammount = this.builderSummon.getAttributeAmmount(attribute);
            if (!(ammount > Config.getSliders().getMaxSummonAttributes())) continue;
            this.builderSummon.setAttribute(attribute, Config.getSliders().getMaxSummonAttributes());
        }
        for (Effect potion : this.builderSummon.getEffects()) {
            int minutes;
            byte amplifier = this.builderSummon.getAmplifier(potion);
            if ((double)amplifier > Config.getSliders().getMaxSummonPotionAmplifier()) {
                this.builderSummon.setAmplifier(potion, (byte)Config.getSliders().getMaxSummonPotionAmplifier());
            }
            if (!((double)(minutes = this.builderSummon.getMinutes(potion)) > Config.getSliders().getMaxSummonPotionMinutes())) continue;
            this.builderSummon.setMinutes(potion, (int)Config.getSliders().getMaxSummonPotionMinutes());
        }
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        this.mobField = new GuiTextFieldTooltip(x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.start.mob_id", (Object[])new Object[0]) + " (" + I18n.func_135052_a((String)"gui.worldhandler.generic.name", (Object[])new Object[0]) + ")");
        this.mobField.func_200675_a((Predicate)Predicates.notNull());
        this.mobField.func_146180_a(this.mob);
        this.mobField.func_212954_a(text -> {
            this.mob = text;
            this.builderSummon.setName(this.mob);
            container.initButtons();
        });
        this.customNameField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.start.custom_name", (Object[])new Object[0]));
        this.customNameField.func_200675_a((Predicate)Predicates.notNull());
        this.customNameField.func_146180_a(this.name);
        this.customNameField.func_212954_a(text -> {
            this.name = text;
            this.builderSummon.setCustomName(this.name);
            container.initButtons();
        });
        this.passengerField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.start.passenger_mob_id", (Object[])new Object[0]));
        this.passengerField.func_200675_a((Predicate)Predicates.notNull());
        this.passengerField.func_146180_a(this.passenger);
        this.passengerField.func_212954_a(text -> {
            this.passenger = this.passengerField.func_146179_b();
            this.builderSummon.setPassenger(0, this.passenger);
            container.initButtons();
        });
        if (Page.ATTRIBUTES.equals((Object)this.page)) {
            MenuPageList<EnumAttributes> attributes = new MenuPageList<EnumAttributes>(x + 118, y, this.attributes, 114, 20, 3, container, new ILogicPageList<EnumAttributes>(){

                @Override
                public String translate(EnumAttributes item) {
                    return item.getTranslation();
                }

                @Override
                public String toTooltip(EnumAttributes item) {
                    return item.getAttribute();
                }

                @Override
                public void onClick(EnumAttributes item) {
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, String text, EnumAttributes item, ActionHandler actionHandler) {
                    return new GuiSlider(x, y, width, height, -Config.getSliders().getMaxSummonAttributes(), Config.getSliders().getMaxSummonAttributes(), 0.0, container, new LogicSliderAttribute(item, text, value -> ContentSummon.this.builderSummon.setAttribute(item, value.intValue())));
                }

                @Override
                public boolean doDisable() {
                    return false;
                }

                @Override
                public String getId() {
                    return "attributes";
                }
            });
            container.add(attributes);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button4 = new GuiButtonBase(x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.start", (Object[])new Object[0]), () -> {
            this.page = Page.START;
            container.init();
        });
        container.add(button4);
        GuiButtonBase button5 = new GuiButtonBase(x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.potion_effects", (Object[])new Object[0]), () -> {
            this.page = Page.POTIONS;
            container.init();
        });
        container.add(button5);
        GuiButtonBase button6 = new GuiButtonBase(x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.attributes", (Object[])new Object[0]), () -> {
            this.page = Page.ATTRIBUTES;
            container.init();
        });
        container.add(button6);
        GuiButtonBase button7 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.equipment", (Object[])new Object[0]), () -> {
            this.page = Page.EQUIPMENT;
            container.init();
        });
        container.add(button7);
        if (Page.START.equals((Object)this.page)) {
            GuiButtonBase button3;
            button4.active = false;
            container.add(this.mobField);
            container.add(this.customNameField);
            container.add(this.passengerField);
            if (!this.builderSummon.needsCommandBlock() && !this.builderSummon.getCustomName().isSpecial()) {
                button3 = new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.title.entities.summon", (Object[])new Object[0]), this::send);
                container.add(button3);
            } else {
                button3 = new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]), this::send);
                container.add(button3);
            }
            button3.active = ForgeRegistries.ENTITIES.containsKey(this.builderSummon.getEntity());
        } else if (Page.POTIONS.equals((Object)this.page)) {
            button5.active = false;
            GuiButtonBase button1 = new GuiButtonBase(x + 118, y + 72, 56, 20, "<", () -> {
                --this.potionPage;
                container.init();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x + 118 + 60, y + 72, 55, 20, ">", () -> {
                ++this.potionPage;
                container.init();
            });
            container.add(button2);
            int count = 0;
            for (ResourceLocation location : this.getSortedPotionList()) {
                Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(location);
                if (potion.equals(Effects.field_76433_i) || potion.equals(Effects.field_76432_h)) continue;
                if (this.potionPage == 0) {
                    button1.active = false;
                }
                if (this.potionPage == ForgeRegistries.POTIONS.getKeys().size() - 3) {
                    button2.active = false;
                }
                if (count == this.potionPage) {
                    container.add(new GuiSlider(x + 118, y, 114, 20, 0.0, Config.getSliders().getMaxSummonPotionAmplifier(), 0.0, container, new LogicSliderSimple("amplifier" + potion.getRegistryName(), I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]), value -> this.builderSummon.setAmplifier(potion, value.byteValue()))));
                    container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, Config.getSliders().getMaxSummonPotionMinutes(), 0.0, container, new LogicSliderSimple("duration" + potion.getRegistryName(), I18n.func_135052_a((String)"gui.worldhandler.potion.time.minutes", (Object[])new Object[0]), value -> this.builderSummon.setMinutes(potion, (int)value))));
                    container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.particles", (Object[])new Object[]{this.builderSummon.getShowParticles(potion) ? I18n.func_135052_a((String)"gui.worldhandler.generic.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.worldhandler.generic.off", (Object[])new Object[0])}), () -> {
                        this.builderSummon.setShowParticles(potion, !this.builderSummon.getShowParticles(potion));
                        container.init();
                    }));
                    break;
                }
                ++count;
            }
        } else if (Page.ATTRIBUTES.equals((Object)this.page)) {
            button6.active = false;
        } else if (Page.EQUIPMENT.equals((Object)this.page)) {
            GuiButtonBase button1 = new GuiButtonBase(x + 118, y + 72, 56, 20, "<", () -> {
                --this.equipmentPage;
                container.init();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x + 118 + 60, y + 72, 54, 20, ">", () -> {
                ++this.equipmentPage;
                container.init();
            });
            container.add(button2);
            if (this.equipmentPage == 0) {
                button1.active = false;
                GuiButtonItem button8 = new GuiButtonItem(x + 118, y, 18, 20, Items.field_151024_Q, () -> {
                    this.builderSummon.setArmorItem(3, Items.field_151024_Q);
                    container.init();
                });
                container.add(button8);
                GuiButtonItem button9 = new GuiButtonItem(x + 118 + 20 - 1, y, 18, 20, Items.field_151028_Y, () -> {
                    this.builderSummon.setArmorItem(3, Items.field_151028_Y);
                    container.init();
                });
                container.add(button9);
                GuiButtonItem button10 = new GuiButtonItem(x + 118 + 40 - 2, y, 18, 20, Items.field_151020_U, () -> {
                    this.builderSummon.setArmorItem(3, Items.field_151020_U);
                    container.init();
                });
                container.add(button10);
                GuiButtonItem button11 = new GuiButtonItem(x + 118 + 60 - 3, y, 18, 20, Items.field_151169_ag, () -> {
                    this.builderSummon.setArmorItem(3, Items.field_151169_ag);
                    container.init();
                });
                container.add(button11);
                GuiButtonItem button12 = new GuiButtonItem(x + 118 + 80 - 4, y, 18, 20, Items.field_151161_ac, () -> {
                    this.builderSummon.setArmorItem(3, Items.field_151161_ac);
                    container.init();
                });
                container.add(button12);
                GuiButtonBase button13 = new GuiButtonBase(x + 118 + 100 - 5, y, 20, 20, null, () -> {
                    this.builderSummon.setArmorItem(3, Blocks.field_150350_a);
                    container.init();
                });
                container.add(button13);
                GuiButtonItem button14 = new GuiButtonItem(x + 118, y + 24, 18, 20, Items.field_151027_R, () -> {
                    this.builderSummon.setArmorItem(2, Items.field_151027_R);
                    container.init();
                });
                container.add(button14);
                GuiButtonItem button15 = new GuiButtonItem(x + 118 + 20 - 1, y + 24, 18, 20, Items.field_151030_Z, () -> {
                    this.builderSummon.setArmorItem(2, Items.field_151030_Z);
                    container.init();
                });
                container.add(button15);
                GuiButtonItem button16 = new GuiButtonItem(x + 118 + 40 - 2, y + 24, 18, 20, Items.field_151023_V, () -> {
                    this.builderSummon.setArmorItem(2, Items.field_151023_V);
                    container.init();
                });
                container.add(button16);
                GuiButtonItem button17 = new GuiButtonItem(x + 118 + 60 - 3, y + 24, 18, 20, Items.field_151171_ah, () -> {
                    this.builderSummon.setArmorItem(2, Items.field_151171_ah);
                    container.init();
                });
                container.add(button17);
                GuiButtonItem button18 = new GuiButtonItem(x + 118 + 80 - 4, y + 24, 18, 20, Items.field_151163_ad, () -> {
                    this.builderSummon.setArmorItem(2, Items.field_151163_ad);
                    container.init();
                });
                container.add(button18);
                GuiButtonBase button19 = new GuiButtonBase(x + 118 + 100 - 5, y + 24, 20, 20, null, () -> {
                    this.builderSummon.setArmorItem(2, Blocks.field_150350_a);
                    container.init();
                });
                container.add(button19);
                GuiButtonItem button20 = new GuiButtonItem(x + 118, y + 48, 18, 20, Items.field_151026_S, () -> {
                    this.builderSummon.setArmorItem(1, Items.field_151026_S);
                    container.init();
                });
                container.add(button20);
                GuiButtonItem button21 = new GuiButtonItem(x + 118 + 20 - 1, y + 48, 18, 20, Items.field_151165_aa, () -> {
                    this.builderSummon.setArmorItem(1, Items.field_151165_aa);
                    container.init();
                });
                container.add(button21);
                GuiButtonItem button22 = new GuiButtonItem(x + 118 + 40 - 2, y + 48, 18, 20, Items.field_151022_W, () -> {
                    this.builderSummon.setArmorItem(1, Items.field_151022_W);
                    container.init();
                });
                container.add(button22);
                GuiButtonItem button23 = new GuiButtonItem(x + 118 + 60 - 3, y + 48, 18, 20, Items.field_151149_ai, () -> {
                    this.builderSummon.setArmorItem(1, Items.field_151149_ai);
                    container.init();
                });
                container.add(button23);
                GuiButtonItem button24 = new GuiButtonItem(x + 118 + 80 - 4, y + 48, 18, 20, Items.field_151173_ae, () -> {
                    this.builderSummon.setArmorItem(1, Items.field_151173_ae);
                    container.init();
                });
                container.add(button24);
                GuiButtonBase button25 = new GuiButtonBase(x + 118 + 100 - 5, y + 48, 20, 20, null, () -> {
                    this.builderSummon.setArmorItem(1, Blocks.field_150350_a);
                    container.init();
                });
                container.add(button25);
                button8.active = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151024_Q.getRegistryName());
                button9.active = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151028_Y.getRegistryName());
                button10.active = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151020_U.getRegistryName());
                button11.active = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151169_ag.getRegistryName());
                button12.active = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151161_ac.getRegistryName());
                button13.active = !this.builderSummon.getArmorItem(3).equals((Object)Blocks.field_150350_a.getRegistryName());
                button14.active = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151027_R.getRegistryName());
                button15.active = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151030_Z.getRegistryName());
                button16.active = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151023_V.getRegistryName());
                button17.active = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151171_ah.getRegistryName());
                button18.active = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151163_ad.getRegistryName());
                button19.active = !this.builderSummon.getArmorItem(2).equals((Object)Blocks.field_150350_a.getRegistryName());
                button20.active = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151026_S.getRegistryName());
                button21.active = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151165_aa.getRegistryName());
                button22.active = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151022_W.getRegistryName());
                button23.active = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151149_ai.getRegistryName());
                button24.active = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151173_ae.getRegistryName());
                button25.active = !this.builderSummon.getArmorItem(1).equals((Object)Blocks.field_150350_a.getRegistryName());
            } else if (this.equipmentPage == 1) {
                button2.active = false;
                GuiButtonItem button8 = new GuiButtonItem(x + 118, y, 18, 20, Items.field_151021_T, () -> {
                    this.builderSummon.setArmorItem(0, Items.field_151021_T);
                    container.init();
                });
                container.add(button8);
                GuiButtonItem button9 = new GuiButtonItem(x + 118 + 20 - 1, y, 18, 20, Items.field_151167_ab, () -> {
                    this.builderSummon.setArmorItem(0, Items.field_151167_ab);
                    container.init();
                });
                container.add(button9);
                GuiButtonItem button10 = new GuiButtonItem(x + 118 + 40 - 2, y, 18, 20, Items.field_151029_X, () -> {
                    this.builderSummon.setArmorItem(0, Items.field_151029_X);
                    container.init();
                });
                container.add(button10);
                GuiButtonItem button11 = new GuiButtonItem(x + 118 + 60 - 3, y, 18, 20, Items.field_151151_aj, () -> {
                    this.builderSummon.setArmorItem(0, Items.field_151151_aj);
                    container.init();
                });
                container.add(button11);
                GuiButtonItem button12 = new GuiButtonItem(x + 118 + 80 - 4, y, 18, 20, Items.field_151175_af, () -> {
                    this.builderSummon.setArmorItem(0, Items.field_151175_af);
                    container.init();
                });
                container.add(button12);
                GuiButtonBase button13 = new GuiButtonBase(x + 118 + 100 - 5, y, 20, 20, null, () -> {
                    this.builderSummon.setArmorItem(0, Blocks.field_150350_a);
                    container.init();
                });
                container.add(button13);
                GuiButtonItem button14 = new GuiButtonItem(x + 118, y + 24, 18, 20, Items.field_151041_m, () -> {
                    this.builderSummon.setHandItem(0, Items.field_151041_m);
                    container.init();
                });
                container.add(button14);
                GuiButtonItem button15 = new GuiButtonItem(x + 118 + 20 - 1, y + 24, 18, 20, Items.field_151052_q, () -> {
                    this.builderSummon.setHandItem(0, Items.field_151052_q);
                    container.init();
                });
                container.add(button15);
                GuiButtonItem button16 = new GuiButtonItem(x + 118 + 40 - 2, y + 24, 18, 20, Items.field_151040_l, () -> {
                    this.builderSummon.setHandItem(0, Items.field_151040_l);
                    container.init();
                });
                container.add(button16);
                GuiButtonItem button17 = new GuiButtonItem(x + 118 + 60 - 3, y + 24, 18, 20, Items.field_151010_B, () -> {
                    this.builderSummon.setHandItem(0, Items.field_151010_B);
                    container.init();
                });
                container.add(button17);
                GuiButtonItem button18 = new GuiButtonItem(x + 118 + 80 - 4, y + 24, 18, 20, Items.field_151048_u, () -> {
                    this.builderSummon.setHandItem(0, Items.field_151048_u);
                    container.init();
                });
                container.add(button18);
                GuiButtonBase button19 = new GuiButtonBase(x + 118 + 100 - 5, y + 24, 20, 20, null, () -> {
                    this.builderSummon.setHandItem(0, Blocks.field_150350_a);
                    container.init();
                });
                container.add(button19);
                GuiButtonItem button20 = new GuiButtonItem(x + 118, y + 48, 18, 20, Items.field_151041_m, () -> {
                    this.builderSummon.setHandItem(1, Items.field_151041_m);
                    container.init();
                });
                container.add(button20);
                GuiButtonItem button21 = new GuiButtonItem(x + 118 + 20 - 1, y + 48, 18, 20, Items.field_151052_q, () -> {
                    this.builderSummon.setHandItem(1, Items.field_151052_q);
                    container.init();
                });
                container.add(button21);
                GuiButtonItem button22 = new GuiButtonItem(x + 118 + 40 - 2, y + 48, 18, 20, Items.field_151040_l, () -> {
                    this.builderSummon.setHandItem(1, Items.field_151040_l);
                    container.init();
                });
                container.add(button22);
                GuiButtonItem button23 = new GuiButtonItem(x + 118 + 60 - 3, y + 48, 18, 20, Items.field_151010_B, () -> {
                    this.builderSummon.setHandItem(1, Items.field_151010_B);
                    container.init();
                });
                container.add(button23);
                GuiButtonItem button24 = new GuiButtonItem(x + 118 + 80 - 4, y + 48, 18, 20, Items.field_151048_u, () -> {
                    this.builderSummon.setHandItem(1, Items.field_151048_u);
                    container.init();
                });
                container.add(button24);
                GuiButtonBase button25 = new GuiButtonBase(x + 118 + 100 - 5, y + 48, 20, 20, null, () -> {
                    this.builderSummon.setHandItem(1, Blocks.field_150350_a);
                    container.init();
                });
                container.add(button25);
                button8.active = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151021_T.getRegistryName());
                button9.active = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151167_ab.getRegistryName());
                button10.active = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151029_X.getRegistryName());
                button11.active = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151151_aj.getRegistryName());
                button12.active = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151175_af.getRegistryName());
                button13.active = !this.builderSummon.getArmorItem(0).equals((Object)Blocks.field_150350_a.getRegistryName());
                button14.active = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151041_m.getRegistryName());
                button15.active = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151052_q.getRegistryName());
                button16.active = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151040_l.getRegistryName());
                button17.active = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151010_B.getRegistryName());
                button18.active = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151048_u.getRegistryName());
                button19.active = !this.builderSummon.getHandItem(0).equals((Object)Blocks.field_150350_a.getRegistryName());
                button20.active = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151041_m.getRegistryName());
                button21.active = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151052_q.getRegistryName());
                button22.active = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151040_l.getRegistryName());
                button23.active = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151010_B.getRegistryName());
                button24.active = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151048_u.getRegistryName());
                button25.active = !this.builderSummon.getHandItem(1).equals((Object)Blocks.field_150350_a.getRegistryName());
            }
            button7.active = false;
        }
    }

    private void send() {
        CommandHelper.sendCommand(this.builderSummon, this.builderSummon.getCustomName().isSpecial());
    }

    @Override
    public void tick(Container container) {
        if (Page.START.equals((Object)this.page)) {
            this.mobField.func_146178_a();
            this.customNameField.func_146178_a();
            this.passengerField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page)) {
            this.mobField.renderButton(mouseX, mouseY, partialTicks);
            this.customNameField.renderButton(mouseX, mouseY, partialTicks);
            this.passengerField.renderButton(mouseX, mouseY, partialTicks);
        } else if (Page.POTIONS.equals((Object)this.page)) {
            Minecraft.func_71410_x().field_71466_p.func_211126_b(this.potionPage + 1 + "/" + (ForgeRegistries.POTIONS.getKeys().size() - 2), (float)(x + 118), (float)(y - 11), Config.getSkin().getHeadlineColor());
        } else if (Page.EQUIPMENT.equals((Object)this.page)) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/beacon.png"));
            container.setBlitOffset(0);
            for (int row = 0; row < 3; ++row) {
                container.blit(x + 116 + 99, y + 2 + 24 * row, 112, 221, 16, 16);
            }
            Minecraft.func_71410_x().field_71466_p.func_211126_b(this.equipmentPage + 1 + "/2", (float)(x + 118), (float)(y - 11), Config.getSkin().getHeadlineColor());
        }
    }

    private List<ResourceLocation> getSortedPotionList() {
        return ForgeRegistries.POTIONS.getKeys().stream().sorted((a, b) -> I18n.func_135052_a((String)((Effect)ForgeRegistries.POTIONS.getValue(a)).func_76393_a(), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)((Effect)ForgeRegistries.POTIONS.getValue(b)).func_76393_a(), (Object[])new Object[0]))).collect(Collectors.toList());
    }

    @Override
    public Category getCategory() {
        return Categories.ENTITIES;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.entities.summon", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.entities.summon", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SUMMON;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Page {
        START,
        POTIONS,
        ATTRIBUTES,
        EQUIPMENT;

    }
}

