/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.TextFormatting;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentWorldInfo
extends Content {
    private Page page = Page.START;
    private GuiTextFieldTooltip posXField;
    private GuiTextFieldTooltip posYField;
    private GuiTextFieldTooltip posZField;
    private GuiTextFieldTooltip worldField;
    private GuiTextFieldTooltip seedField;
    private GuiTextFieldTooltip terrainField;
    private GuiTextFieldTooltip totalTimeField;
    private GuiTextFieldTooltip currentTimeField;

    @Override
    public void initGui(Container container, int x, int y) {
        World world = this.getWorld();
        this.posXField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20);
        this.posXField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " X: " + this.getWorldInfo(WorldInfo::func_76079_c, world));
        this.posYField = new GuiTextFieldTooltip(x + 118, y + 36, 114, 20);
        this.posYField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " Y: " + this.getWorldInfo(WorldInfo::func_76075_d, world));
        this.posZField = new GuiTextFieldTooltip(x + 118, y + 60, 114, 20);
        this.posZField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " Z: " + this.getWorldInfo(WorldInfo::func_76074_e, world));
        this.worldField = new GuiTextFieldTooltip(x + 118, y, 114, 20);
        this.worldField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.world.name", (Object[])new Object[0]) + ": " + this.getWorldInfo(WorldInfo::func_76065_j, world));
        this.terrainField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20);
        this.terrainField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.world.world_type", (Object[])new Object[0]) + ": " + this.getWorldInfo(info -> I18n.func_135052_a((String)info.func_76067_t().func_77128_b(), (Object[])new Object[0]), world));
        this.seedField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20);
        this.seedField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.world.seed", (Object[])new Object[0]) + ": " + this.getSeed(world));
        this.seedField.func_200675_a(string -> string.equals(this.seedField.func_146179_b()));
        this.seedField.func_146196_d();
        this.currentTimeField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20);
        this.updateCurrentTime();
        this.totalTimeField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20);
        this.updateTotalTime();
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase start = new GuiButtonBase(x, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.world_info.start", (Object[])new Object[0]), () -> {
            this.page = Page.START;
            container.init();
        });
        container.add(start);
        GuiButtonBase world = new GuiButtonBase(x, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.world_info.world", (Object[])new Object[0]), () -> {
            this.page = Page.WORLD;
            container.init();
        });
        container.add(world);
        GuiButtonBase stats = new GuiButtonBase(x, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.world_info.statistics", (Object[])new Object[0]), () -> {
            this.page = Page.STATS;
            container.init();
        });
        container.add(stats);
        if (Page.START.equals((Object)this.page)) {
            start.active = false;
        } else if (Page.WORLD.equals((Object)this.page)) {
            world.active = false;
            GuiButtonBase seed = new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.world_info.world.copy_seed", (Object[])new Object[0]), () -> Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSeed(this.getWorld())));
            container.add(seed);
            seed.active = Minecraft.func_71410_x().func_71401_C() != null;
        } else if (Page.STATS.equals((Object)this.page)) {
            stats.active = false;
        }
    }

    @Override
    public void tick(Container container) {
        this.updateCurrentTime();
        this.updateTotalTime();
        this.seedField.func_146178_a();
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page)) {
            this.posXField.renderButton(mouseX, mouseY, partialTicks);
            this.posYField.renderButton(mouseX, mouseY, partialTicks);
            this.posZField.renderButton(mouseX, mouseY, partialTicks);
        } else if (Page.WORLD.equals((Object)this.page)) {
            this.worldField.renderButton(mouseX, mouseY, partialTicks);
            this.terrainField.renderButton(mouseX, mouseY, partialTicks);
            this.seedField.renderButton(mouseX, mouseY, partialTicks);
        } else if (Page.STATS.equals((Object)this.page)) {
            this.totalTimeField.renderButton(mouseX, mouseY, partialTicks);
            this.currentTimeField.renderButton(mouseX, mouseY, partialTicks);
        }
    }

    private void updateCurrentTime() {
        this.currentTimeField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.statistics.world_time", (Object[])new Object[0]) + ": " + TextFormatting.formatWorldTime(Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76073_f()));
    }

    private void updateTotalTime() {
        this.totalTimeField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.statistics.played", (Object[])new Object[0]) + ": " + TextFormatting.getTotalTimePlayed(Minecraft.func_71410_x().field_71441_e.func_72912_H().func_82573_f()));
    }

    private <T> String getWorldInfo(Function<WorldInfo, T> function, World world) {
        if (world != null) {
            return String.valueOf(function.apply(world.func_72912_H()));
        }
        return I18n.func_135052_a((String)"gui.worldhandler.world_info.n_a", (Object[])new Object[0]);
    }

    private World getWorld() {
        if (Minecraft.func_71410_x().func_71401_C() != null) {
            return Minecraft.func_71410_x().func_71401_C().func_71218_a(DimensionType.field_223227_a_);
        }
        return Minecraft.func_71410_x().field_71441_e;
    }

    private String getSeed(World world) {
        return Minecraft.func_71410_x().func_71401_C() != null ? String.valueOf(world.func_72912_H().func_76063_b()) : I18n.func_135052_a((String)"gui.worldhandler.world_info.n_a", (Object[])new Object[0]);
    }

    @Override
    public Category getCategory() {
        return Categories.WORLD;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.world.world", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.world.world", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.WORLD_INFO;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Page {
        START,
        WORLD,
        STATS;

    }
}

