/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.menu.impl;

import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonList;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.menu.Menu;
import exopandora.worldhandler.gui.menu.impl.ILogicColorMenu;
import exopandora.worldhandler.gui.menu.impl.ILogicMapped;
import exopandora.worldhandler.util.MutableStringTextComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MenuColorField
extends Menu {
    private static final List<TextFormatting> COLORS = new ArrayList<TextFormatting>();
    private GuiTextFieldTooltip textField;
    private final MutableStringTextComponent string;
    private final ILogicColorMenu logic;
    private final String translationKey;

    public MenuColorField(int x, int y, String translationKey, MutableStringTextComponent string) {
        this(x, y, translationKey, string, new ILogicColorMenu(){});
    }

    public MenuColorField(int x, int y, String translationKey, MutableStringTextComponent string, ILogicColorMenu logic) {
        super(x, y);
        this.translationKey = translationKey;
        this.string = string;
        this.logic = logic;
    }

    @Override
    public void initGui(Container container) {
        this.textField = new GuiTextFieldTooltip(this.x + 118, this.y, 114, 20, I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]));
        this.textField.func_200675_a(this.logic::validate);
        this.textField.func_195607_a(this.string::formatter);
        this.textField.func_146180_a(this.string.func_150265_g());
        this.textField.func_212954_a(text -> this.string.setText((String)text));
    }

    @Override
    public void initButtons(Container container) {
        container.add(this.textField);
        if (this.logic.doDrawButtons()) {
            container.add(new GuiButtonList<TextFormatting>(this.x + 118, this.y + 24, COLORS, 114, 20, container, new ILogicMapped<TextFormatting>(){

                @Override
                public String translate(TextFormatting item) {
                    return item + I18n.func_135052_a((String)"gui.worldhandler.color", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("gui.worldhandler.color." + item.func_96297_d()), (Object[])new Object[0]);
                }

                @Override
                public String toTooltip(TextFormatting item) {
                    return null;
                }

                @Override
                public String formatTooltip(TextFormatting item, int index, int max) {
                    return null;
                }

                @Override
                public void onClick(TextFormatting item) {
                    MenuColorField.this.string.func_150256_b().func_150238_a(item);
                }

                @Override
                public String getId() {
                    return MenuColorField.this.logic.getId();
                }
            }));
            container.add(new GuiButtonBase(this.x + 118, this.y + 48, 20, 20, (this.string.func_150256_b().func_150242_c() ? TextFormatting.ITALIC : TextFormatting.RESET) + "I", () -> {
                this.string.func_150256_b().func_150217_b(Boolean.valueOf(!this.string.func_150256_b().func_150242_c()));
                container.init();
            }));
            container.add(new GuiButtonBase(this.x + 118 + 24 - 1, this.y + 48, 20, 20, (this.string.func_150256_b().func_150223_b() ? TextFormatting.BOLD : TextFormatting.RESET) + "B", () -> {
                this.string.func_150256_b().func_150227_a(Boolean.valueOf(!this.string.func_150256_b().func_150223_b()));
                container.init();
            }));
            container.add(new GuiButtonBase(this.x + 118 + 48 - 1, this.y + 48, 20, 20, (this.string.func_150256_b().func_150234_e() ? TextFormatting.UNDERLINE : TextFormatting.RESET) + "U", () -> {
                this.string.func_150256_b().func_150228_d(Boolean.valueOf(!this.string.func_150256_b().func_150234_e()));
                container.init();
            }));
            container.add(new GuiButtonBase(this.x + 118 + 72 - 1, this.y + 48, 20, 20, (this.string.func_150256_b().func_150236_d() ? TextFormatting.STRIKETHROUGH : TextFormatting.RESET) + "S", () -> {
                this.string.func_150256_b().func_150225_c(Boolean.valueOf(!this.string.func_150256_b().func_150236_d()));
                container.init();
            }));
            container.add(new GuiButtonBase(this.x + 118 + 96 - 2, this.y + 48, 20, 20, (this.string.func_150256_b().func_150233_f() ? TextFormatting.OBFUSCATED : TextFormatting.RESET) + "O", () -> {
                this.string.func_150256_b().func_150237_e(Boolean.valueOf(!this.string.func_150256_b().func_150233_f()));
                container.init();
            }));
        }
    }

    @Override
    public void tick() {
        this.textField.func_146178_a();
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        this.textField.renderButton(mouseX, mouseY, partialTicks);
    }

    static {
        COLORS.add(TextFormatting.RESET);
        COLORS.add(TextFormatting.YELLOW);
        COLORS.add(TextFormatting.GOLD);
        COLORS.add(TextFormatting.DARK_RED);
        COLORS.add(TextFormatting.RED);
        COLORS.add(TextFormatting.LIGHT_PURPLE);
        COLORS.add(TextFormatting.DARK_PURPLE);
        COLORS.add(TextFormatting.BLUE);
        COLORS.add(TextFormatting.DARK_BLUE);
        COLORS.add(TextFormatting.DARK_AQUA);
        COLORS.add(TextFormatting.AQUA);
        COLORS.add(TextFormatting.GREEN);
        COLORS.add(TextFormatting.DARK_GREEN);
        COLORS.add(TextFormatting.BLACK);
        COLORS.add(TextFormatting.DARK_GRAY);
        COLORS.add(TextFormatting.GRAY);
        COLORS.add(TextFormatting.WHITE);
    }
}

