/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.usercontent.factory;

import com.google.common.base.Predicates;
import exopandora.worldhandler.gui.button.GuiButtonIcon;
import exopandora.worldhandler.gui.button.GuiButtonItem;
import exopandora.worldhandler.gui.button.GuiButtonList;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.button.LogicSliderSimple;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.usercontent.UsercontentAPI;
import exopandora.worldhandler.usercontent.factory.ActionHandlerFactory;
import exopandora.worldhandler.usercontent.factory.WidgetFactory;
import exopandora.worldhandler.usercontent.model.JsonButton;
import exopandora.worldhandler.usercontent.model.JsonItem;
import exopandora.worldhandler.util.TextFormatting;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ButtonFactory
extends WidgetFactory {
    public ButtonFactory(UsercontentAPI api, ActionHandlerFactory actionHandlerFactory) {
        super(api, actionHandlerFactory);
    }

    @Nullable
    public Widget createButton(JsonButton button, Content content, Container container, int x, int y) {
        if (JsonButton.Type.BUTTON.equals((Object)button.getType())) {
            return new GuiButtonTooltip(button.getDimensions().getX() + x, button.getDimensions().getY() + y, button.getDimensions().getWidth(), button.getDimensions().getHeight(), TextFormatting.formatNonnull(button.getText(), new Object[0]), TextFormatting.formatNullable(button.getAttributes() != null ? button.getAttributes().getTooltip() : null, new Object[0]), this.getActionHandlerFactory().createActionHandler(content, button.getAction()));
        }
        if (JsonButton.Type.ITEM_BUTTON.equals((Object)button.getType())) {
            return new GuiButtonItem(button.getDimensions().getX() + x, button.getDimensions().getY() + y, button.getDimensions().getWidth(), button.getDimensions().getHeight(), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(button.getAttributes().getItem())), this.getActionHandlerFactory().createActionHandler(content, button.getAction()));
        }
        if (JsonButton.Type.ICON_BUTTON.equals((Object)button.getType())) {
            return new GuiButtonIcon(button.getDimensions().getX() + x, button.getDimensions().getY() + y, button.getDimensions().getWidth(), button.getDimensions().getHeight(), button.getAttributes().getIcon(), TextFormatting.formatNonnull(button.getAttributes().getTooltip(), new Object[0]), this.getActionHandlerFactory().createActionHandler(content, button.getAction()));
        }
        if (JsonButton.Type.LIST_BUTTON.equals((Object)button.getType())) {
            return new GuiButtonList<JsonItem>(button.getDimensions().getX() + x, button.getDimensions().getY() + y, button.getAttributes().getItems(), button.getDimensions().getWidth(), button.getDimensions().getHeight(), container, new WidgetFactory.UsercontentLogicMapped<JsonButton.Type>(this.getApi(), this.getActionHandlerFactory(), content, button));
        }
        if (JsonButton.Type.SLIDER.equals((Object)button.getType())) {
            Consumer<Integer> responder = this.getActionHandlerFactory().createResponder(integer -> integer.toString(), button.getAttributes().getId(), button.getAction());
            return new GuiSlider(button.getDimensions().getX() + x, button.getDimensions().getY() + y, button.getDimensions().getWidth(), button.getDimensions().getHeight(), button.getAttributes().getMin(), button.getAttributes().getMax(), button.getAttributes().getStart(), container, new LogicSliderSimple(button.getAttributes().getId(), TextFormatting.formatNullable(button.getText(), new Object[0]), responder));
        }
        if (JsonButton.Type.TEXTFIELD.equals((Object)button.getType())) {
            GuiTextFieldTooltip textfield = new GuiTextFieldTooltip(button.getDimensions().getX() + x, button.getDimensions().getY() + y, button.getDimensions().getWidth(), button.getDimensions().getHeight(), TextFormatting.formatNullable(button.getText(), new Object[0]));
            textfield.func_200675_a((Predicate)Predicates.notNull());
            textfield.func_146180_a(this.getApi().getValue(button.getAttributes().getId()));
            textfield.func_212954_a(this.getActionHandlerFactory().createResponder(string -> textfield.func_146179_b(), button.getAttributes().getId(), button.getAction()));
            return textfield;
        }
        return null;
    }
}

