/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import exopandora.worldhandler.builder.INBTWritable;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MutableStringTextComponent
extends StringTextComponent
implements INBTWritable {
    private String text;

    public MutableStringTextComponent() {
        super(null);
        this.text = "";
    }

    public MutableStringTextComponent(String text) {
        super(null);
        this.text = text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String func_150265_g() {
        return this.text;
    }

    public String func_150261_e() {
        return this.text;
    }

    public String func_150254_d() {
        String formatted = super.func_150254_d();
        if (this.isSpecial()) {
            return MutableStringTextComponent.getSpecialFormattedText(formatted);
        }
        return formatted;
    }

    public boolean isSpecial() {
        return this.text != null && !this.text.isEmpty() && MutableStringTextComponent.getSpecialFormattedText(this.text).contains("\u00a7");
    }

    public static String getSpecialFormattedText(String text) {
        String result = text.replaceAll("&", "\u00a7").replaceAll("\u00a7\u00a7", "&");
        if (result.contains("\u00a7")) {
            result = result + TextFormatting.RESET;
        }
        return result;
    }

    public String formatter(String string, Integer index) {
        return this.func_150256_b().func_150218_j() + string;
    }

    @Override
    public INBT serialize() {
        if (this.func_150261_e() != null && !this.func_150261_e().isEmpty()) {
            return StringNBT.func_229705_a_((String)this.toString());
        }
        return null;
    }

    public String toString() {
        MutableStringTextComponent serial = (MutableStringTextComponent)this.func_212638_h();
        serial.setText(MutableStringTextComponent.getSpecialFormattedText(this.func_150261_e()));
        return ITextComponent.Serializer.func_150696_a((ITextComponent)serial);
    }

    public MutableStringTextComponent shallowCopy() {
        return new MutableStringTextComponent(this.text);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MutableStringTextComponent)) {
            return false;
        }
        MutableStringTextComponent stringtextcomponent = (MutableStringTextComponent)object;
        return this.text.equals(stringtextcomponent.func_150265_g()) && super.equals(object);
    }
}

