/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import exopandora.worldhandler.config.Config;
import java.util.Arrays;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategorySkin {
    private final ForgeConfigSpec.ConfigValue<EnumIconSize> iconSize;
    private final ForgeConfigSpec.IntValue labelColor;
    private final ForgeConfigSpec.IntValue headlineColor;
    private final ForgeConfigSpec.IntValue backgroundRed;
    private final ForgeConfigSpec.IntValue backgroundGreen;
    private final ForgeConfigSpec.IntValue backgroundBlue;
    private final ForgeConfigSpec.IntValue backgroundAlpha;
    private final ForgeConfigSpec.IntValue buttonRed;
    private final ForgeConfigSpec.IntValue buttonGreen;
    private final ForgeConfigSpec.IntValue buttonBlue;
    private final ForgeConfigSpec.IntValue buttonAlpha;
    private final ForgeConfigSpec.ConfigValue<String> type;
    private final ForgeConfigSpec.BooleanValue sharpEdges;
    private final ForgeConfigSpec.BooleanValue drawBackground;

    public ConfigCategorySkin(ForgeConfigSpec.Builder builder) {
        builder.push("skin");
        this.iconSize = builder.translation("gui.worldhandler.config.skin.icon_size").comment("Size of the icons").defineEnum("icon_size", (Enum)EnumIconSize.x16, (Enum[])EnumIconSize.values());
        this.labelColor = builder.translation("gui.worldhandler.config.skin.label_color").comment("Label color").defineInRange("label_color", 0x1F1F1F, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.headlineColor = builder.translation("gui.worldhandler.config.skin.headline_color").comment("Headline color").defineInRange("headline_color", 0x4F4F4F, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.backgroundRed = builder.translation("gui.worldhandler.config.skin.background_red").comment("Background red").defineInRange("background_red", 255, 0, 255);
        this.backgroundGreen = builder.translation("gui.worldhandler.config.skin.background_green").comment("Background green").defineInRange("background_green", 255, 0, 255);
        this.backgroundBlue = builder.translation("gui.worldhandler.config.skin.background_blue").comment("Background blue").defineInRange("background_blue", 255, 0, 255);
        this.backgroundAlpha = builder.translation("gui.worldhandler.config.skin.background_alpha").comment("Background alpha").defineInRange("background_alpha", 255, 0, 255);
        this.buttonRed = builder.translation("gui.worldhandler.config.skin.button_red").comment("Button red").defineInRange("button_red", 255, 0, 255);
        this.buttonGreen = builder.translation("gui.worldhandler.config.skin.button_green").comment("Button green").defineInRange("button_green", 255, 0, 255);
        this.buttonBlue = builder.translation("gui.worldhandler.config.skin.button_blue").comment("Button blue").defineInRange("button_blue", 255, 0, 255);
        this.buttonAlpha = builder.translation("gui.worldhandler.config.skin.button_alpha").comment("Button alpha").defineInRange("button_alpha", 255, 0, 255);
        this.type = builder.translation("gui.worldhandler.config.skin.textures").comment("Background texture (resourcepack, vanilla)").defineInList("textures", (Object)"resourcepack", Arrays.asList("resourcepack", "vanilla"));
        this.sharpEdges = builder.translation("gui.worldhandler.config.settings.sharp_tab_edges").comment("Whether or not the gui has sharp or smooth tab edges").define("sharp_tab_edges", false);
        this.drawBackground = builder.translation("gui.worldhandler.config.settings.draw_background").comment("Whether or not to enable background drawing").define("draw_background", true);
        builder.pop();
    }

    public EnumIconSize getIconSize() {
        return (EnumIconSize)((Object)this.iconSize.get());
    }

    public void setIconSize(EnumIconSize size) {
        Config.set(this.iconSize, size);
    }

    public int getLabelColor() {
        return (Integer)this.labelColor.get();
    }

    public void setLabelColor(int color) {
        Config.set(this.labelColor, color);
    }

    public int getHeadlineColor() {
        return (Integer)this.headlineColor.get();
    }

    public void setHeadlineColor(int color) {
        Config.set(this.headlineColor, color);
    }

    private int getBackgroundRed() {
        return (Integer)this.backgroundRed.get();
    }

    public float getBackgroundRedF() {
        return (float)this.getBackgroundRed() / 255.0f;
    }

    public void setBackgroundRed(int red) {
        Config.set(this.backgroundRed, red);
    }

    private int getBackgroundGreen() {
        return (Integer)this.backgroundGreen.get();
    }

    public float getBackgroundGreenF() {
        return (float)this.getBackgroundGreen() / 255.0f;
    }

    public void setBackgroundGreen(int green) {
        Config.set(this.backgroundGreen, green);
    }

    private int getBackgroundBlue() {
        return (Integer)this.backgroundBlue.get();
    }

    public float getBackgroundBlueF() {
        return (float)this.getBackgroundBlue() / 255.0f;
    }

    public void setBackgroundBlue(int blue) {
        Config.set(this.backgroundBlue, blue);
    }

    private int getButtonRed() {
        return (Integer)this.buttonRed.get();
    }

    public float getButtonRedF() {
        return (float)this.getButtonRed() / 255.0f;
    }

    public void setButtonRed(int red) {
        Config.set(this.backgroundRed, red);
    }

    private int getButtonGreen() {
        return (Integer)this.buttonGreen.get();
    }

    public float getButtonGreenF() {
        return (float)this.getButtonGreen() / 255.0f;
    }

    public void setButtonGreen(int green) {
        Config.set(this.buttonGreen, green);
    }

    private int getButtonBlue() {
        return (Integer)this.buttonBlue.get();
    }

    public float getButtonBlueF() {
        return (float)this.getButtonBlue() / 255.0f;
    }

    public void setButtonBlue(int blue) {
        Config.set(this.buttonBlue, blue);
    }

    public String getTextureType() {
        return (String)this.type.get();
    }

    public void setTextureType(String type) {
        Config.set(this.type, type);
    }

    public boolean sharpEdges() {
        return (Boolean)this.sharpEdges.get();
    }

    public void setSharpEdges(boolean enabled) {
        Config.set(this.sharpEdges, enabled);
    }

    public boolean drawBackground() {
        return (Boolean)this.drawBackground.get();
    }

    public void setDrawBackground(boolean enabled) {
        Config.set(this.drawBackground, enabled);
    }

    private int getBackgroundAlpha() {
        return (Integer)this.backgroundAlpha.get();
    }

    public float getBackgroundAlphaF() {
        return (float)this.getBackgroundAlpha() / 255.0f;
    }

    public void setBackgroundAlpha(int alpha) {
        Config.set(this.backgroundAlpha, alpha);
    }

    private int getButtonAlpha() {
        return (Integer)this.buttonAlpha.get();
    }

    public float getButtonAlphaF() {
        return (float)this.getButtonAlpha() / 255.0f;
    }

    public void setButtonAlpha(int alpha) {
        Config.set(this.buttonAlpha, alpha);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum EnumIconSize {
        x16,
        x32,
        x64;

    }
}

