/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import exopandora.worldhandler.gui.button.GuiSlider;
import java.util.function.Consumer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LogicSliderSimple
implements GuiSlider.ILogicSlider {
    private final String id;
    private final IFormattableTextComponent text;
    private final Consumer<Integer> listener;

    public LogicSliderSimple(String id, IFormattableTextComponent text, Consumer<Integer> listener) {
        this.id = id;
        this.text = text;
        this.listener = listener;
    }

    @Override
    public IFormattableTextComponent formatPrefix(int value) {
        return this.text;
    }

    @Override
    public IFormattableTextComponent formatSuffix(int value) {
        return new StringTextComponent("");
    }

    @Override
    public IFormattableTextComponent formatValue(int value) {
        return new StringTextComponent(": " + String.valueOf(value));
    }

    @Override
    public void onChangeSliderValue(int value) {
        this.listener.accept(value);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

