/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.container.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import exopandora.worldhandler.builder.impl.BuilderWorldHandler;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.event.KeyHandler;
import exopandora.worldhandler.gui.button.EnumIcon;
import exopandora.worldhandler.gui.button.GuiButtonIcon;
import exopandora.worldhandler.gui.button.GuiButtonTab;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.menu.IMenu;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.RenderUtils;
import exopandora.worldhandler.util.ResourceHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiWorldHandler
extends Container {
    private final Content content;
    private final int tabSize;
    private final int bgTextureWidth = 248;
    private final int bgTextureHeight = 166;
    private final int tabDistance = 2;
    private final int tabDistanceTotal;
    private final double tabWidth;
    private final double tabHalf;
    private final double tabEpsilon;
    private final String splash = this.getSplash();
    private final List<Widget> finalButtons = new ArrayList<Widget>();
    private GuiTextFieldTooltip syntaxField;
    private GuiTextFieldTooltip nameField;
    private static String player = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private static final BuilderWorldHandler BUILDER_WORLD_HANDLER = new BuilderWorldHandler();

    public GuiWorldHandler(Content content) throws Exception {
        super((ITextComponent)content.getTitle());
        this.content = content;
        this.tabSize = this.content.getCategory().getSize();
        this.tabDistanceTotal = Math.max(this.tabSize - 1, 1) * this.tabDistance;
        this.tabWidth = (this.bgTextureWidth - this.tabDistanceTotal) / Math.max(this.tabSize, 2);
        this.tabHalf = this.tabWidth / 2.0;
        this.tabEpsilon = (double)this.bgTextureWidth - ((double)this.tabDistanceTotal + this.tabHalf * (double)Math.max(this.tabSize, 2) * 2.0);
        this.content.init(this);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        ActionHelper.tryRun(() -> {
            this.finalButtons.clear();
            this.menus.clear();
            this.field_230710_m_.clear();
            this.field_230705_e_.clear();
            this.content.onPlayerNameChanged(this.getPlayer());
            this.content.initGui(this, this.getContentX(), this.getContentY());
            for (IMenu menu : this.menus) {
                menu.initGui(this);
            }
            int x = this.field_230708_k_ / 2 - 10;
            int delta = 21;
            if (Config.getSettings().shortcuts()) {
                this.finalButtons.add((Widget)new GuiButtonIcon(x - 147, 0, 20, 20, EnumIcon.TIME_DAWN, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.time", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.time.dawn", new Object[]{Config.getSettings().getDawn()})}), ActionHelper::timeDawn));
                this.finalButtons.add((Widget)new GuiButtonIcon(x - 126, 0, 20, 20, EnumIcon.TIME_NOON, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.time", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.time.noon", new Object[]{Config.getSettings().getNoon()})}), ActionHelper::timeNoon));
                this.finalButtons.add((Widget)new GuiButtonIcon(x - 105, 0, 20, 20, EnumIcon.TIME_SUNSET, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.time", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.time.sunset", new Object[]{Config.getSettings().getSunset()})}), ActionHelper::timeSunset));
                this.finalButtons.add((Widget)new GuiButtonIcon(x - 84, 0, 20, 20, EnumIcon.TIME_MIDNIGHT, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.time", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.time.midnight", new Object[]{Config.getSettings().getMidnight()})}), ActionHelper::timeMidnight));
                this.finalButtons.add((Widget)new GuiButtonIcon(x - 63, 0, 20, 20, EnumIcon.WEATHER_SUN, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.weather", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.weather.clear")}), ActionHelper::weatherClear));
                this.finalButtons.add((Widget)new GuiButtonIcon(x - 42, 0, 20, 20, EnumIcon.WEATHER_RAIN, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.weather", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.weather.rainy")}), ActionHelper::weatherRain));
                this.finalButtons.add((Widget)new GuiButtonIcon(x - 21, 0, 20, 20, EnumIcon.WEATHER_STORM, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.weather", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.weather.thunder")}), ActionHelper::weatherThunder));
                this.finalButtons.add((Widget)new GuiButtonIcon(x - 0, 0, 20, 20, EnumIcon.DIFFICULTY_PEACEFUL, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.difficulty", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.difficulty.peaceful")}), ActionHelper::difficultyPeaceful));
                this.finalButtons.add((Widget)new GuiButtonIcon(x + 21, 0, 20, 20, EnumIcon.DIFFICULTY_EASY, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.difficulty", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.difficulty.easy")}), ActionHelper::difficultyEasy));
                this.finalButtons.add((Widget)new GuiButtonIcon(x + 42, 0, 20, 20, EnumIcon.DIFFICULTY_NORMAL, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.difficulty", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.difficulty.normal")}), ActionHelper::difficultyNormal));
                this.finalButtons.add((Widget)new GuiButtonIcon(x + 63, 0, 20, 20, EnumIcon.DIFFICULTY_HARD, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.difficulty", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.difficulty.hard")}), ActionHelper::difficultyHard));
                this.finalButtons.add((Widget)new GuiButtonIcon(x + 84, 0, 20, 20, EnumIcon.GAMEMODE_SURVIVAL, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.gamemode", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.gamemode.survival")}), ActionHelper::gamemodeSurvival));
                this.finalButtons.add((Widget)new GuiButtonIcon(x + 105, 0, 20, 20, EnumIcon.GAMEMODE_CREATIVE, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.gamemode", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.gamemode.creative")}), ActionHelper::gamemodeCreative));
                this.finalButtons.add((Widget)new GuiButtonIcon(x + 126, 0, 20, 20, EnumIcon.GAMEMODE_ADVENTURE, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.gamemode", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.gamemode.adventure")}), ActionHelper::gamemodeAdventure));
                this.finalButtons.add((Widget)new GuiButtonIcon(x + 147, 0, 20, 20, EnumIcon.GAMEMODE_SPECTATOR, (ITextComponent)new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.gamemode", new Object[]{new TranslationTextComponent("gui.worldhandler.shortcuts.tooltip.gamemode.spectator")}), ActionHelper::gamemodeSpectator));
            }
            if (Config.getSettings().commandSyntax()) {
                this.syntaxField = new GuiTextFieldTooltip(x - 147 + 1, this.field_230709_l_ - 22, 312, 20);
                this.updateSyntax();
            }
            this.nameField = new GuiTextFieldTooltip(0, 0, 0, 11);
            this.nameField.func_146203_f(16);
            this.nameField.func_146180_a(this.getPlayer());
            this.nameField.func_212954_a(text -> {
                player = text;
                this.updateNameField();
            });
            this.updateNameField();
            this.forEachTab(this::addTabButtons);
            this.initButtons();
        });
    }

    private void addTabButtons(final int index, double xOffset) {
        int backgroundX = this.getBackgroundX();
        int backgroundY = this.getBackgroundY();
        Content tab = this.content.getCategory().getContent(index);
        if (!tab.equals(this.content.getActiveContent())) {
            this.finalButtons.add((Widget)new GuiButtonTab((int)((double)backgroundX + xOffset), backgroundY - 20, (int)this.tabWidth + (int)Math.ceil(this.tabEpsilon / (double)this.tabSize), 21, (ITextComponent)tab.getTabTitle()){

                public void func_230930_b_() {
                    ActionHelper.changeTab(GuiWorldHandler.this.content, index);
                }
            });
        }
    }

    @Override
    public void initButtons() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.content.initButtons(this, this.getContentX(), this.getContentY());
        if (this.finalButtons != null && !this.finalButtons.isEmpty()) {
            this.finalButtons.forEach(this::add);
        }
        if (Config.getSettings().commandSyntax()) {
            this.add(this.syntaxField);
        }
        this.add(this.nameField);
        for (IMenu menu : this.menus) {
            menu.initButtons(this);
        }
    }

    public void func_231023_e_() {
        ActionHelper.tryRun(this::update);
    }

    private void update() {
        this.content.tick(this);
        for (IMenu menu : this.menus) {
            menu.tick();
        }
        this.updateSyntax();
    }

    private int getBackgroundX() {
        return (this.field_230708_k_ - this.bgTextureWidth) / 2 + this.getXOffset();
    }

    private int getBackgroundY() {
        return (this.field_230709_l_ - this.bgTextureHeight) / 2 + this.getYOffset();
    }

    private int getWatchOffset() {
        return Config.getSettings().watch() ? 9 : 0;
    }

    private void forEachTab(BiConsumer<Integer, Double> consumer) {
        double xOffset = 0.0;
        for (int index = 0; index < this.tabSize; ++index) {
            consumer.accept(index, xOffset);
            xOffset += this.tabWidth + (double)this.tabDistance + this.tabEpsilon / (double)this.tabSize;
        }
    }

    private void updateSyntax() {
        if (Config.getSettings().commandSyntax() && this.syntaxField != null) {
            if (!this.syntaxField.func_230999_j_()) {
                this.syntaxField.func_200675_a((Predicate)Predicates.alwaysTrue());
                if (this.content.getCommandBuilder() != null) {
                    this.syntaxField.func_146180_a(this.content.getCommandBuilder().toCommand());
                } else {
                    this.syntaxField.func_146180_a(BUILDER_WORLD_HANDLER.toCommand());
                }
                this.syntaxField.func_200675_a(string -> string.equals(this.syntaxField.func_146179_b()));
                this.syntaxField.func_146196_d();
            }
            this.syntaxField.func_146178_a();
        }
    }

    private void updateNameField() {
        int backgroundX = this.getBackgroundX();
        int backgroundY = this.getBackgroundY();
        if (player.isEmpty()) {
            int width = this.field_230712_o_.func_78256_a(I18n.func_135052_a((String)"gui.worldhandler.generic.edit_username", (Object[])new Object[0])) + 2;
            this.nameField.func_230991_b_(width);
            this.nameField.setPosition(backgroundX + this.bgTextureWidth - this.getWatchOffset() - 7 - (this.field_230712_o_.func_238414_a_((ITextProperties)this.content.getTitle()) + 2), backgroundY + 6);
        } else {
            int width = this.field_230712_o_.func_78256_a(player) + 2;
            this.nameField.func_230991_b_(width);
            this.nameField.setPosition(backgroundX + this.bgTextureWidth - this.getWatchOffset() - 7 - width, backgroundY + 6);
        }
        this.content.onPlayerNameChanged(player);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        ActionHelper.tryRun(() -> {
            int backgroundX = this.getBackgroundX();
            int backgroundY = this.getBackgroundY();
            if (Config.getSkin().drawBackground()) {
                this.func_230926_e_(-1);
                super.func_230446_a_(matrix);
            }
            this.defaultColor();
            this.bindBackground();
            this.func_238474_b_(matrix, backgroundX, backgroundY, 0, 0, this.bgTextureWidth, this.bgTextureHeight);
            this.func_230926_e_(0);
            this.forEachTab((index, xOffset) -> this.drawTab(matrix, (int)index, (double)xOffset));
            this.defaultColor();
            String label = "1.16.1-2.10.1";
            int hexAlpha = 0x33000000;
            int color = Config.getSkin().getLabelColor() + 0x33000000;
            int versionWidth = this.field_230708_k_ - this.field_230712_o_.func_78256_a("1.16.1-2.10.1") - 2;
            int versionHeight = this.field_230709_l_ - 10;
            this.field_230712_o_.func_238421_b_(matrix, "1.16.1-2.10.1", (float)versionWidth, (float)versionHeight, color);
            int maxWidth = this.bgTextureWidth - 7 - 2 - this.field_230712_o_.func_78256_a(player) - 2 - this.getWatchOffset() - 7;
            this.field_230712_o_.func_238422_b_(matrix, (ITextProperties)TextUtils.stripText(this.content.getTitle(), maxWidth, this.field_230712_o_), (float)(backgroundX + 7), (float)(backgroundY + 7), Config.getSkin().getLabelColor());
            String username = player.isEmpty() && !this.nameField.func_230999_j_() ? I18n.func_135052_a((String)"gui.worldhandler.generic.edit_username", (Object[])new Object[0]) : player;
            this.field_230712_o_.func_238421_b_(matrix, username, (float)(backgroundX + this.bgTextureWidth - this.getWatchOffset() - 7 - this.field_230712_o_.func_78256_a(username)), (float)(backgroundY + 7), Config.getSkin().getLabelColor());
            if (Config.getSettings().watch()) {
                int watchX = backgroundX + 233;
                int watchY = backgroundY + 5;
                RenderUtils.drawWatchIntoGui(matrix, (AbstractGui)this, watchX, watchY, Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76073_f(), Config.getSettings().smoothWatch());
                if (Config.getSettings().tooltips() && mouseX >= watchX && mouseX <= watchX + 9 && mouseY >= watchY && mouseY <= watchY + 9) {
                    GuiUtils.drawHoveringText((MatrixStack)matrix, Arrays.asList(new StringTextComponent(TextUtils.formatWorldTime(Minecraft.func_71410_x().field_71441_e.func_72820_D()))), (int)mouseX, (int)(mouseY + 9), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)this.field_230708_k_, (FontRenderer)this.field_230712_o_);
                    RenderUtils.disableLighting();
                }
            }
            for (int x = 0; x < this.field_230710_m_.size(); ++x) {
                ((Widget)this.field_230710_m_.get(x)).func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            }
            this.content.drawScreen(matrix, this, this.getContentX(), this.getContentY(), mouseX, mouseY, partialTicks);
            for (IMenu menu : this.menus) {
                menu.draw(matrix, mouseX, mouseY, partialTicks);
            }
            if (Config.getSettings().commandSyntax() && this.syntaxField != null) {
                this.syntaxField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            }
            if (this.splash != null) {
                RenderHelper.func_227780_a_();
                RenderUtils.disableLighting();
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(backgroundX + 212), (double)(backgroundY + 15), 0.0);
                matrix.func_227863_a_(new Quaternion(17.0f, 0.0f, 0.0f, 1.0f));
                float scale = 1.1f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
                scale = scale * 100.0f / (float)this.field_230712_o_.func_78256_a(this.splash);
                matrix.func_227862_a_(scale, scale, scale);
                this.func_238471_a_(matrix, this.field_230712_o_, this.splash, 0, (int)scale, 0xFFFF00);
                matrix.func_227865_b_();
            }
            if (Config.getSettings().tooltips()) {
                for (Widget button : this.field_230710_m_) {
                    if (!(button instanceof GuiButtonTooltip)) continue;
                    ((GuiButtonTooltip)button).renderTooltip(matrix, mouseX, mouseY);
                }
            }
            if (mouseX >= versionWidth && mouseY >= versionHeight) {
                GuiUtils.drawHoveringText((MatrixStack)matrix, Arrays.asList(new StringTextComponent("1.16.1-2.10.1")), (int)(versionWidth - 12), (int)(versionHeight + 12), (int)(this.field_230708_k_ + this.field_230712_o_.func_78256_a("1.16.1-2.10.1")), (int)(this.field_230709_l_ + 10), (int)this.field_230708_k_, (FontRenderer)this.field_230712_o_);
            }
        });
    }

    private void drawTab(MatrixStack matrix, int index, double xOffset) {
        int color;
        int fHeight;
        int yOffset;
        Content tab = this.content.getCategory().getContent(index);
        int backgroundX = this.getBackgroundX();
        int backgroundY = this.getBackgroundY();
        if (this.content.getActiveContent().equals(tab)) {
            yOffset = -22;
            fHeight = 25;
            color = 0xFFFFFF;
            this.defaultColor();
        } else {
            yOffset = -20;
            fHeight = 20;
            color = 0xE0E0E0;
            this.darkColor();
        }
        this.bindBackground();
        this.func_230926_e_(-1);
        this.func_238474_b_(matrix, (int)((double)backgroundX + xOffset), backgroundY + yOffset, 0, 0, (int)Math.ceil(this.tabHalf), fHeight);
        this.func_238474_b_(matrix, (int)((double)backgroundX + this.tabHalf + xOffset), backgroundY + yOffset, this.bgTextureWidth - (int)Math.floor(this.tabHalf + 1.0), 0, (int)Math.floor(this.tabHalf + 1.0), fHeight);
        if (!Config.getSkin().sharpEdges()) {
            if (this.content.getActiveContent().equals(tab)) {
                int x;
                int factor;
                if (index < this.tabSize - 1 || this.tabSize == 1) {
                    factor = 2;
                    for (x = 0; x < factor; ++x) {
                        this.func_238474_b_(matrix, (int)((double)backgroundX + xOffset - (double)x - 1.0 + Math.floor(this.tabHalf + 1.0) + this.tabHalf), backgroundY + x + 1, (int)(this.tabWidth - (double)x - 1.0), x + 1, x + 1, 1);
                    }
                }
                if (index > 0) {
                    factor = 2;
                    for (x = 0; x < factor; ++x) {
                        this.func_238474_b_(matrix, (int)((double)backgroundX + xOffset), backgroundY + x + 1, (int)xOffset, x + 1, x + 1, 1);
                    }
                }
                int width = (int)(this.tabWidth - 3.0);
                int interval = 5;
                if (index == 0) {
                    for (int x2 = 0; x2 < width; x2 += interval) {
                        this.defaultColor(1.0f - (float)x2 / ((float)width + 5.0f * (float)interval));
                        this.func_238474_b_(matrix, (int)((double)backgroundX + xOffset), backgroundY + yOffset + fHeight + x2 / interval, 0, fHeight, width - x2, 1);
                    }
                }
                if (index == this.tabSize - 1 && this.tabSize > 1) {
                    int offset = 3;
                    for (int x3 = 0; x3 < width; x3 += interval) {
                        this.defaultColor(1.0f - (float)x3 / ((float)width + 5.0f * (float)interval));
                        this.func_238474_b_(matrix, (int)((double)backgroundX + Math.ceil(xOffset) + (double)x3 + (double)offset), backgroundY + yOffset + fHeight + x3 / interval, this.bgTextureWidth - width + x3, fHeight, width - x3, 1);
                    }
                }
            } else {
                int x;
                int factor;
                if (index == 0) {
                    factor = 2;
                    for (x = 0; x < factor; ++x) {
                        this.func_238474_b_(matrix, backgroundX, backgroundY + x, 0, fHeight, factor - x, 1);
                    }
                }
                if (index == this.tabSize - 1) {
                    factor = 3;
                    for (x = 0; x < factor + 1; ++x) {
                        this.func_238474_b_(matrix, backgroundX + this.bgTextureWidth - x, backgroundY + factor - x, this.bgTextureWidth - x, fHeight, x, 1);
                    }
                }
            }
        }
        this.func_230926_e_(0);
        this.func_238472_a_(matrix, this.field_230712_o_, (ITextProperties)TextUtils.stripText(tab.getTabTitle().func_240699_a_(TextFormatting.UNDERLINE), (int)this.tabWidth, this.field_230712_o_), (int)((double)backgroundX + this.tabHalf + xOffset), backgroundY - 13, color);
    }

    public void func_212927_b(double xPos, double mouseY) {
        this.content.func_212927_b(xPos, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int keyCode) {
        if (this.nameField.func_230999_j_()) {
            this.nameField.func_146202_e();
        }
        if (this.content.func_231044_a_(mouseX, mouseY, keyCode)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, keyCode);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int keyCode) {
        if (this.content.func_231048_c_(mouseX, mouseY, keyCode)) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, keyCode);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int keyCode, double deltaX, double deltaY) {
        if (this.content.func_231045_a_(mouseX, mouseY, keyCode, deltaX, deltaY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, keyCode, deltaX, deltaY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double distance) {
        if (this.content.func_231043_a_(mouseX, mouseY, distance)) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, distance);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean focused;
        boolean bl = focused = this.func_241217_q_() != null;
        if (focused && this.func_241217_q_() instanceof Widget) {
            focused = ((Widget)this.func_241217_q_()).func_230999_j_();
        }
        if (!focused && KeyHandler.isPressed(KeyHandler.KEY_WORLD_HANDLER, keyCode)) {
            this.func_231175_as__();
            return true;
        }
        if (this.content.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.content.func_223281_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char charTyped, int keyCode) {
        if (this.nameField.func_230999_j_()) {
            this.nameField.func_146202_e();
        }
        if (this.content.func_231042_a_(charTyped, keyCode)) {
            return true;
        }
        return super.func_231042_a_(charTyped, keyCode);
    }

    public boolean func_231049_c__(boolean focus) {
        if (this.content.func_231049_c__(focus)) {
            return true;
        }
        return super.func_231049_c__(focus);
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        if (this.content.func_231047_b_(mouseX, mouseY)) {
            return true;
        }
        return super.func_231047_b_(mouseX, mouseY);
    }

    private void defaultColor() {
        this.defaultColor(1.0f);
    }

    private void defaultColor(float alpha) {
        RenderSystem.enableBlend();
        RenderUtils.color(Config.getSkin().getBackgroundRedF(), Config.getSkin().getBackgroundGreenF(), Config.getSkin().getBackgroundBlueF(), alpha * Config.getSkin().getBackgroundAlphaF());
    }

    private void darkColor() {
        RenderSystem.enableBlend();
        RenderUtils.color(Config.getSkin().getBackgroundRedF() - 0.3f, Config.getSkin().getBackgroundGreenF() - 0.3f, Config.getSkin().getBackgroundBlueF() - 0.3f, Config.getSkin().getBackgroundAlphaF());
    }

    private void bindBackground() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceHelper.getBackgroundTexture());
    }

    private int getContentX() {
        return this.getBackgroundX() + 8;
    }

    private int getContentY() {
        return this.getBackgroundY() + 33;
    }

    private int getXOffset() {
        return 0;
    }

    private int getYOffset() {
        return Config.getSettings().shortcuts() ? 11 : 8;
    }

    @Nullable
    protected String getSplash() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        if (day == 12 && month == 24) {
            return "Merry X-mas!";
        }
        if (day == 1 && month == 1) {
            return "Happy new year!";
        }
        if (day == 10 && month == 31) {
            return "OOoooOOOoooo! Spooky!";
        }
        if (day == 3 && month == 28) {
            return calendar.get(1) - 2013 + " Years of World Handler!";
        }
        return null;
    }

    public void func_231175_as__() {
        ActionHelper.tryRun(this.content::onGuiClosed);
        super.func_231175_as__();
    }

    public boolean func_231177_au__() {
        return Config.getSettings().pause();
    }

    @Override
    public String getPlayer() {
        return player;
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    public boolean func_231178_ax__() {
        return true;
    }
}

