/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.matrix.MatrixStack;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.component.impl.EntityNBT;
import exopandora.worldhandler.builder.impl.BuilderButcher;
import exopandora.worldhandler.builder.impl.BuilderFill;
import exopandora.worldhandler.builder.impl.BuilderSetBlock;
import exopandora.worldhandler.builder.impl.BuilderSummon;
import exopandora.worldhandler.builder.types.BlockResourceLocation;
import exopandora.worldhandler.builder.types.Coordinate;
import exopandora.worldhandler.builder.types.CoordinateDouble;
import exopandora.worldhandler.builder.types.CoordinateInt;
import exopandora.worldhandler.gui.button.EnumIcon;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonIcon;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.util.ActionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentCommandStack
extends ContentChild {
    private static final int HEAD_LENGTH = 1;
    private static final int TAIL_LENGTH = 2;
    private static final StringTextComponent PLUS = new StringTextComponent("+");
    private static final StringTextComponent MINUS = new StringTextComponent("-");
    private final List<GuiTextFieldTooltip> textfields = new ArrayList<GuiTextFieldTooltip>();
    private int scroll;
    private GuiButtonBase buttonCopy;
    private final BuilderSummon builderCommandStack = new BuilderSummon();

    public ContentCommandStack() {
        this.builderCommandStack.setEntity(EntityType.field_200809_w.getRegistryName());
        this.builderCommandStack.setX(new CoordinateDouble(0.0, Coordinate.EnumType.GLOBAL));
        this.builderCommandStack.setY(new CoordinateDouble(0.5, Coordinate.EnumType.GLOBAL));
        this.builderCommandStack.setZ(new CoordinateDouble(0.0, Coordinate.EnumType.GLOBAL));
        this.builderCommandStack.setMotion(0.0, 0.315, 0.0);
        this.builderCommandStack.setTime(1);
        this.builderCommandStack.setBlockState(Blocks.field_150408_cc.func_176223_P());
        EntityNBT redstoneBlock = new EntityNBT(EntityType.field_200809_w.getRegistryName());
        redstoneBlock.setTime(1);
        redstoneBlock.setBlockState(Blocks.field_150451_bX.func_176223_P());
        this.builderCommandStack.addPassenger(redstoneBlock);
        this.addCommand(0);
        EntityNBT blockRemover = new EntityNBT(EntityType.field_200774_N.getRegistryName());
        BuilderSetBlock builder = new BuilderSetBlock(new CoordinateInt(Coordinate.EnumType.GLOBAL), new CoordinateInt(-2, Coordinate.EnumType.GLOBAL), new CoordinateInt(Coordinate.EnumType.GLOBAL), Blocks.field_185776_dc.getRegistryName(), BuilderSetBlock.EnumMode.DESTROY);
        CompoundNBT commandBlock = new CompoundNBT();
        commandBlock.func_74774_a("auto", (byte)1);
        commandBlock.func_74778_a("Command", new BuilderFill(new CoordinateInt(Coordinate.EnumType.GLOBAL), new CoordinateInt(Coordinate.EnumType.GLOBAL), new CoordinateInt(Coordinate.EnumType.GLOBAL), new CoordinateInt(Coordinate.EnumType.GLOBAL), new CoordinateInt(2, Coordinate.EnumType.GLOBAL), new CoordinateInt(Coordinate.EnumType.GLOBAL), new BlockResourceLocation(Blocks.field_150350_a.getRegistryName())).toActualCommand());
        builder.setBlockNBT(commandBlock);
        blockRemover.setCommand(builder.toActualCommand());
        this.builderCommandStack.addPassenger(blockRemover);
        EntityNBT entityRemover = new EntityNBT(EntityType.field_200774_N.getRegistryName());
        entityRemover.setCommand(new BuilderButcher(EntityType.field_200774_N.getRegistryName(), 1).toActualCommand());
        this.builderCommandStack.addPassenger(entityRemover);
    }

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderCommandStack;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.textfields.clear();
        for (int index = 0; index < 3; ++index) {
            int command = index + this.scroll;
            GuiTextFieldTooltip textfield = new GuiTextFieldTooltip(x, y + 24 * index, 184, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.command_stack.command_n", new Object[]{command + 1}));
            textfield.func_200675_a((Predicate)Predicates.notNull());
            textfield.func_146180_a(command < this.getCommandCount() ? this.getCommand(command) : null);
            textfield.func_212954_a(text -> {
                this.setCommand(command, (String)text);
                this.updateCopyButton();
            });
            this.textfields.add(textfield);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        this.iterate(index -> {
            GuiButtonIcon buttonUp = new GuiButtonIcon(x + 232 - 20 - 24, y + index * 24 - 1, 20, 10, EnumIcon.ARROW_UP, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.move_up"), () -> {
                this.swapCommands(index + this.scroll, index + this.scroll - 1);
                container.func_231160_c_();
            });
            container.add(buttonUp);
            GuiButtonIcon buttonDown = new GuiButtonIcon(x + 232 - 20 - 24, y + index * 24 + 11, 20, 10, EnumIcon.ARROW_DOWN, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.move_down"), () -> {
                this.swapCommands(index + this.scroll, index + this.scroll + 1);
                container.func_231160_c_();
            });
            container.add(buttonDown);
            GuiButtonTooltip buttonRemove = new GuiButtonTooltip(x + 232 - 20, y + index * 24 - 1, 20, 10, (ITextComponent)MINUS, (ITextComponent)new TranslationTextComponent("gui.worldhandler.command_stack.remove_command"), () -> {
                int pos = index + this.scroll;
                this.removeCommand(pos);
                if (this.scroll + 3 > this.getCommandCount()) {
                    this.scrollUp();
                }
                container.func_231160_c_();
            });
            container.add(buttonRemove);
            container.add(new GuiButtonTooltip(x + 232 - 20, y + index * 24 + 11, 20, 10, (ITextComponent)PLUS, (ITextComponent)new TranslationTextComponent("gui.worldhandler.command_stack.insert_command"), () -> {
                int pos = index + this.scroll + 1;
                this.addCommand(pos);
                if (index == 2) {
                    this.scrollDown();
                }
                container.func_231160_c_();
            }));
            container.add((TextFieldWidget)this.textfields.get((int)index));
            buttonRemove.field_230693_o_ = this.getCommandCount() > 1;
            buttonUp.field_230693_o_ = index + this.scroll > 0;
            buttonDown.field_230693_o_ = index + this.scroll + 1 < this.getCommandCount();
        });
        this.buttonCopy = new GuiButtonBase(x, y + 72, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.command_stack.copy_command"), () -> Minecraft.func_71410_x().field_195559_v.func_197960_a(this.builderCommandStack.toActualCommand()));
        container.add(this.buttonCopy);
        GuiButtonIcon buttonScrollUp = new GuiButtonIcon(x + 118, y + 72, 56, 20, EnumIcon.ARROW_UP, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.move_up"), () -> {
            this.scrollUp();
            container.func_231160_c_();
        });
        container.add(buttonScrollUp);
        GuiButtonIcon buttonScrollDown = new GuiButtonIcon(x + 118 + 60, y + 72, 54, 20, EnumIcon.ARROW_DOWN, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.move_down"), () -> {
            this.scrollDown();
            container.func_231160_c_();
        });
        container.add(buttonScrollDown);
        this.updateCopyButton();
        buttonScrollUp.field_230693_o_ = this.scroll > 0;
        buttonScrollDown.field_230693_o_ = this.scroll < this.getCommandCount() - 3;
    }

    @Override
    public void tick(Container container) {
        this.iterate(index -> this.textfields.get((int)index).func_146178_a());
    }

    @Override
    public void drawScreen(MatrixStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.iterate(index -> this.textfields.get((int)index).func_230431_b_(matrix, mouseX, mouseY, partialTicks));
    }

    private void iterate(Consumer<Integer> consumer) {
        for (int x = 0; x < this.textfields.size() && x + this.scroll < this.getCommandCount(); ++x) {
            consumer.accept(x);
        }
    }

    private void scrollUp() {
        this.scroll = Math.max(0, this.scroll - (Screen.func_231173_s_() ? 10 : 1));
    }

    private void scrollDown() {
        this.scroll = Math.min(this.getCommandCount() - 3, this.scroll + (Screen.func_231173_s_() ? 10 : 1));
    }

    private void updateCopyButton() {
        boolean active = false;
        for (int x = 0; x < this.getCommandCount() && !active; ++x) {
            String command = this.getCommand(x);
            if (command == null || command.isEmpty()) continue;
            active = true;
        }
        this.buttonCopy.field_230693_o_ = active;
    }

    private void setCommand(int index, String command) {
        this.builderCommandStack.getPassenger(index + 1).setCommand(command);
    }

    private void addCommand(int index) {
        this.builderCommandStack.addPassenger(index + 1, new EntityNBT(EntityType.field_200774_N.getRegistryName()));
    }

    private void removeCommand(int index) {
        this.builderCommandStack.removePassenger(index + 1);
    }

    private String getCommand(int index) {
        return this.builderCommandStack.getPassenger(index + 1).getCommand();
    }

    private int getCommandCount() {
        return this.builderCommandStack.getPassengerCount() - 1 - 2;
    }

    private void swapCommands(int i, int j) {
        Collections.swap(this.builderCommandStack.getPassengers(), i + 1, j + 1);
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.command_stack");
    }
}

