/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.arguments.BoolArgumentType;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderGamerule;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentGamerules
extends Content {
    private GuiTextFieldTooltip valueField;
    private boolean booleanValue;
    private String value;
    private final BuilderGamerule builderGamerule = new BuilderGamerule();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderGamerule;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        this.valueField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.value"));
        this.valueField.func_200675_a((Predicate)Predicates.notNull());
        this.valueField.func_146180_a(this.value);
        this.valueField.func_146202_e();
        this.valueField.func_212954_a(text -> {
            this.value = text;
            this.builderGamerule.setValue(this.value);
        });
        final HashMap map = new HashMap();
        GameRules.func_223590_a((GameRules.IRuleEntryVisitor)new GameRules.IRuleEntryVisitor(){

            public <T extends GameRules.RuleValue<T>> void func_223481_a(GameRules.RuleKey<T> rule, GameRules.RuleType<T> type) {
                map.put(rule.func_223576_a(), type.func_223581_a(null).getType());
            }
        });
        MenuPageList<String> rules = new MenuPageList<String>(x, y, new ArrayList(map.keySet()), 114, 20, 3, container, new ILogicPageList<String>(){

            @Override
            public IFormattableTextComponent translate(String item) {
                return new TranslationTextComponent("gamerule." + item);
            }

            @Override
            public IFormattableTextComponent toTooltip(String item) {
                return new StringTextComponent(item);
            }

            @Override
            public void onClick(String item) {
                ContentGamerules.this.builderGamerule.setRule(item);
                ContentGamerules.this.booleanValue = map.get(item) instanceof BoolArgumentType;
                if (ContentGamerules.this.booleanValue) {
                    ContentGamerules.this.builderGamerule.setValue(null);
                } else {
                    ContentGamerules.this.builderGamerule.setValue(ContentGamerules.this.value);
                }
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, IFormattableTextComponent text, String item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, (ITextComponent)text, (ITextComponent)this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "gamerules";
            }
        });
        container.add(rules);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.booleanValue) {
            container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.enable"), () -> CommandHelper.sendCommand(this.builderGamerule.getBuilderForValue(String.valueOf(true)))));
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.disable"), () -> CommandHelper.sendCommand(this.builderGamerule.getBuilderForValue(String.valueOf(false)))));
        } else {
            container.add(this.valueField);
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.perform"), () -> CommandHelper.sendCommand(this.builderGamerule)));
        }
    }

    @Override
    public void tick(Container container) {
        if (!this.booleanValue) {
            this.valueField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(MatrixStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (!this.booleanValue) {
            this.valueField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public Category getCategory() {
        return Categories.WORLD;
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.world.gamerules");
    }

    @Override
    public IFormattableTextComponent getTabTitle() {
        return new TranslationTextComponent("gui.worldhandler.tab.world.gamerules");
    }

    @Override
    public Content getActiveContent() {
        return Contents.GAMERULES;
    }
}

