/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderRecipe;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentRecipes
extends Content {
    private final BuilderRecipe builderRecipe = new BuilderRecipe();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderRecipe;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        List recipes = Minecraft.func_71410_x().field_71439_g.func_199507_B().func_199642_d().stream().flatMap(recipe -> recipe.func_192711_b().stream()).filter(recipe -> !recipe.func_192399_d()).collect(Collectors.toList());
        MenuPageList list = new MenuPageList(x, y, recipes, 114, 20, 3, container, new ILogicPageList<IRecipe<?>>(){

            @Override
            public IFormattableTextComponent translate(IRecipe<?> item) {
                if (!item.func_77571_b().equals(ItemStack.field_190927_a)) {
                    return (IFormattableTextComponent)item.func_77571_b().func_200301_q();
                }
                return new StringTextComponent(item.func_199560_c().toString());
            }

            @Override
            public IFormattableTextComponent toTooltip(IRecipe<?> item) {
                return new StringTextComponent(item.func_199560_c().toString());
            }

            @Override
            public void onClick(IRecipe<?> item) {
                ContentRecipes.this.builderRecipe.setRecipe(item);
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, IFormattableTextComponent text, IRecipe<?> item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, (ITextComponent)text, (ITextComponent)this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "recipe";
            }
        });
        container.add(list);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.recipes.give"), () -> {
            CommandHelper.sendCommand(this.builderRecipe.getBuilderForMode(BuilderRecipe.EnumMode.GIVE));
            container.initButtons();
        }));
        container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.recipes.take"), () -> {
            CommandHelper.sendCommand(this.builderRecipe.getBuilderForMode(BuilderRecipe.EnumMode.TAKE));
            container.initButtons();
        }));
    }

    @Override
    public Category getCategory() {
        return Categories.ITEMS;
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.items.recipes");
    }

    @Override
    public IFormattableTextComponent getTabTitle() {
        return new TranslationTextComponent("gui.worldhandler.tab.items.recipes");
    }

    @Override
    public Content getActiveContent() {
        return Contents.RECIPES;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderRecipe.setPlayer(username);
    }
}

