/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.matrix.MatrixStack;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.component.impl.ComponentAttribute;
import exopandora.worldhandler.builder.impl.BuilderSummon;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.EnumIcon;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonIcon;
import exopandora.worldhandler.gui.button.GuiButtonItem;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.button.LogicSliderAttribute;
import exopandora.worldhandler.gui.button.LogicSliderSimple;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.RenderUtils;
import exopandora.worldhandler.util.TextUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class ContentSummon
extends Content {
    private GuiTextFieldTooltip mobField;
    private GuiTextFieldTooltip customNameField;
    private GuiTextFieldTooltip passengerField;
    private int potionPage = 0;
    private Page page = Page.START;
    private String mob;
    private String name;
    private String passenger;
    private final BuilderSummon builderSummon = new BuilderSummon();
    private final ResourceLocation[] helmets = new ResourceLocation[]{Blocks.field_150350_a.getRegistryName(), Items.field_151024_Q.getRegistryName(), Items.field_151028_Y.getRegistryName(), Items.field_151020_U.getRegistryName(), Items.field_151169_ag.getRegistryName(), Items.field_151161_ac.getRegistryName(), Items.field_234763_ls_.getRegistryName()};
    private final ResourceLocation[] chestplates = new ResourceLocation[]{Blocks.field_150350_a.getRegistryName(), Items.field_151027_R.getRegistryName(), Items.field_151030_Z.getRegistryName(), Items.field_151023_V.getRegistryName(), Items.field_151171_ah.getRegistryName(), Items.field_151163_ad.getRegistryName(), Items.field_234764_lt_.getRegistryName()};
    private final ResourceLocation[] leggings = new ResourceLocation[]{Blocks.field_150350_a.getRegistryName(), Items.field_151026_S.getRegistryName(), Items.field_151165_aa.getRegistryName(), Items.field_151022_W.getRegistryName(), Items.field_151149_ai.getRegistryName(), Items.field_151173_ae.getRegistryName(), Items.field_234765_lu_.getRegistryName()};
    private final ResourceLocation[] boots = new ResourceLocation[]{Blocks.field_150350_a.getRegistryName(), Items.field_151021_T.getRegistryName(), Items.field_151167_ab.getRegistryName(), Items.field_151029_X.getRegistryName(), Items.field_151151_aj.getRegistryName(), Items.field_151175_af.getRegistryName(), Items.field_234766_lv_.getRegistryName()};
    private final ResourceLocation[] swords = new ResourceLocation[]{Blocks.field_150350_a.getRegistryName(), Items.field_151041_m.getRegistryName(), Items.field_151052_q.getRegistryName(), Items.field_151040_l.getRegistryName(), Items.field_151010_B.getRegistryName(), Items.field_151048_u.getRegistryName(), Items.field_234754_kI_.getRegistryName()};
    private final ResourceLocation[][] armor = new ResourceLocation[][]{this.helmets, this.chestplates, this.leggings, this.boots};
    private final ResourceLocation[][] hands = new ResourceLocation[][]{this.swords, this.swords};

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderSummon;
    }

    @Override
    public void init(Container container) {
        for (Attribute attribute : this.builderSummon.getAttributes()) {
            double ammount = this.builderSummon.getAttributeAmmount(attribute);
            if (!(ammount > Config.getSliders().getMaxSummonAttributes())) continue;
            this.builderSummon.setAttribute(attribute, Config.getSliders().getMaxSummonAttributes());
        }
        for (Effect potion : this.builderSummon.getEffects()) {
            int minutes;
            byte amplifier = this.builderSummon.getAmplifier(potion);
            if ((double)amplifier > Config.getSliders().getMaxSummonPotionAmplifier()) {
                this.builderSummon.setAmplifier(potion, (byte)Config.getSliders().getMaxSummonPotionAmplifier());
            }
            if (!((double)(minutes = this.builderSummon.getMinutes(potion)) > Config.getSliders().getMaxSummonPotionMinutes())) continue;
            this.builderSummon.setMinutes(potion, (int)Config.getSliders().getMaxSummonPotionMinutes());
        }
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        this.mobField = new GuiTextFieldTooltip(x + 118, y, 114, 20, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"gui.worldhandler.entities.summon.start.mob_id", (Object[])new Object[0]) + " (" + I18n.func_135052_a((String)"gui.worldhandler.generic.name", (Object[])new Object[0]) + ")"));
        this.mobField.func_200675_a((Predicate)Predicates.notNull());
        this.mobField.func_146180_a(this.mob);
        this.mobField.func_212954_a(text -> {
            this.mob = text;
            this.builderSummon.setName(this.mob);
            container.initButtons();
        });
        this.customNameField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.summon.start.custom_name"));
        this.customNameField.func_200675_a((Predicate)Predicates.notNull());
        this.customNameField.func_146180_a(this.name);
        this.customNameField.func_212954_a(text -> {
            this.name = text;
            this.builderSummon.setCustomName(this.name);
            container.initButtons();
        });
        this.passengerField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.summon.start.passenger_mob_id"));
        this.passengerField.func_200675_a((Predicate)Predicates.notNull());
        this.passengerField.func_146180_a(this.passenger);
        this.passengerField.func_212954_a(text -> {
            this.passenger = this.passengerField.func_146179_b();
            this.builderSummon.setPassenger(0, this.passenger);
            container.initButtons();
        });
        if (Page.ATTRIBUTES.equals((Object)this.page)) {
            MenuPageList<Attribute> attributes = new MenuPageList<Attribute>(x + 118, y, ComponentAttribute.ATTRIBUTES, 114, 20, 3, container, new ILogicPageList<Attribute>(){

                @Override
                public IFormattableTextComponent translate(Attribute item) {
                    return new TranslationTextComponent(item.func_233754_c_());
                }

                @Override
                public IFormattableTextComponent toTooltip(Attribute item) {
                    return new StringTextComponent(item.getRegistryName().toString());
                }

                @Override
                public void onClick(Attribute item) {
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, IFormattableTextComponent text, Attribute item, ActionHandler actionHandler) {
                    return new GuiSlider(x, y, width, height, -Config.getSliders().getMaxSummonAttributes(), Config.getSliders().getMaxSummonAttributes(), 0.0, container, new LogicSliderAttribute(item, text, value -> ContentSummon.this.builderSummon.setAttribute(item, value.intValue())));
                }

                @Override
                public boolean doDisable() {
                    return false;
                }

                @Override
                public String getId() {
                    return "attributes";
                }
            });
            container.add(attributes);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase button4 = new GuiButtonBase(x, y, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.summon.start"), () -> {
            this.page = Page.START;
            container.func_231160_c_();
        });
        container.add(button4);
        GuiButtonBase button5 = new GuiButtonBase(x, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.summon.potion_effects"), () -> {
            this.page = Page.POTIONS;
            container.func_231160_c_();
        });
        container.add(button5);
        GuiButtonBase button6 = new GuiButtonBase(x, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.summon.attributes"), () -> {
            this.page = Page.ATTRIBUTES;
            container.func_231160_c_();
        });
        container.add(button6);
        GuiButtonBase button7 = new GuiButtonBase(x, y + 72, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.summon.equipment"), () -> {
            this.page = Page.EQUIPMENT;
            container.func_231160_c_();
        });
        container.add(button7);
        if (Page.START.equals((Object)this.page)) {
            GuiButtonBase button3;
            button4.field_230693_o_ = false;
            container.add(this.mobField);
            container.add(this.customNameField);
            container.add(this.passengerField);
            if (!this.builderSummon.needsCommandBlock() && !this.builderSummon.getCustomName().isSpecial()) {
                button3 = new GuiButtonBase(x + 118, y + 72, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.title.entities.summon"), this::send);
                container.add(button3);
            } else {
                button3 = new GuiButtonBase(x + 118, y + 72, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.place_command_block"), this::send);
                container.add(button3);
            }
            button3.field_230693_o_ = ForgeRegistries.ENTITIES.containsKey(this.builderSummon.getEntity());
        } else if (Page.POTIONS.equals((Object)this.page)) {
            button5.field_230693_o_ = false;
            GuiButtonBase button1 = new GuiButtonBase(x + 118, y + 72, 56, 20, (ITextComponent)TextUtils.ARROW_LEFT, () -> {
                --this.potionPage;
                container.func_231160_c_();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x + 118 + 60, y + 72, 55, 20, (ITextComponent)TextUtils.ARROW_RIGHT, () -> {
                ++this.potionPage;
                container.func_231160_c_();
            });
            container.add(button2);
            int count = 0;
            for (ResourceLocation location : this.getSortedPotionList()) {
                Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(location);
                if (potion.equals(Effects.field_76433_i) || potion.equals(Effects.field_76432_h)) continue;
                if (this.potionPage == 0) {
                    button1.field_230693_o_ = false;
                }
                if (this.potionPage == ForgeRegistries.POTIONS.getKeys().size() - 3) {
                    button2.field_230693_o_ = false;
                }
                if (count == this.potionPage) {
                    container.add(new GuiSlider(x + 118, y, 114, 20, 0.0, Config.getSliders().getMaxSummonPotionAmplifier(), 0.0, container, new LogicSliderSimple("amplifier" + potion.getRegistryName(), (IFormattableTextComponent)new TranslationTextComponent(potion.func_76393_a()), value -> this.builderSummon.setAmplifier(potion, value.byteValue()))));
                    container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, Config.getSliders().getMaxSummonPotionMinutes(), 0.0, container, new LogicSliderSimple("duration" + potion.getRegistryName(), (IFormattableTextComponent)new TranslationTextComponent("gui.worldhandler.potion.time.minutes"), value -> this.builderSummon.setMinutes(potion, (int)value))));
                    container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.particles", new Object[]{this.builderSummon.getShowParticles(potion) ? new TranslationTextComponent("gui.worldhandler.generic.on") : new TranslationTextComponent("gui.worldhandler.generic.off")}), () -> {
                        this.builderSummon.setShowParticles(potion, !this.builderSummon.getShowParticles(potion));
                        container.func_231160_c_();
                    }));
                    break;
                }
                ++count;
            }
        } else if (Page.ATTRIBUTES.equals((Object)this.page)) {
            button6.field_230693_o_ = false;
        } else if (Page.EQUIPMENT.equals((Object)this.page)) {
            GuiButtonItem button1;
            int index;
            int i;
            for (i = 0; i < 4; ++i) {
                index = i;
                container.add(new GuiButtonBase(x + 118, y + 24 * i, 20, 20, (ITextComponent)TextUtils.ARROW_LEFT, () -> {
                    this.builderSummon.setArmorItem(index, this.armor[index][Math.floorMod(ArrayUtils.indexOf((Object[])this.armor[index], (Object)this.builderSummon.getArmorItem(index)) - 1, this.armor[index].length)]);
                    container.func_231160_c_();
                }));
                button1 = new GuiButtonItem(x + 118 + 24, y + 24 * i, 20, 20, (Item)ForgeRegistries.ITEMS.getValue(this.builderSummon.getArmorItem(i)), null);
                container.add(button1);
                container.add(new GuiButtonBase(x + 118 + 47, y + 24 * i, 20, 20, (ITextComponent)TextUtils.ARROW_RIGHT, () -> {
                    this.builderSummon.setArmorItem(index, this.armor[index][Math.floorMod(ArrayUtils.indexOf((Object[])this.armor[index], (Object)this.builderSummon.getArmorItem(index)) + 1, this.armor[index].length)]);
                    container.func_231160_c_();
                }));
                button1.field_230693_o_ = false;
            }
            for (i = 0; i < 2; ++i) {
                index = i;
                container.add(new GuiButtonIcon(x + 118 + 70 + 24 * i, y + 12, 20, 20, EnumIcon.ARROW_UP, null, () -> {
                    this.builderSummon.setHandItem(index, this.hands[index][Math.floorMod(ArrayUtils.indexOf((Object[])this.hands[index], (Object)this.builderSummon.getHandItem(index)) - 1, this.hands[index].length)]);
                    container.func_231160_c_();
                }));
                button1 = new GuiButtonItem(x + 118 + 70 + 24 * i, y + 36, 20, 20, (Item)ForgeRegistries.ITEMS.getValue(this.builderSummon.getHandItem(i)), null);
                container.add(button1);
                container.add(new GuiButtonIcon(x + 118 + 70 + 24 * i, y + 60, 20, 20, EnumIcon.ARROW_DOWN, null, () -> {
                    System.out.println(index + " " + ArrayUtils.indexOf((Object[])this.hands[index], (Object)this.builderSummon.getHandItem(index)) + 1);
                    this.builderSummon.setHandItem(index, this.hands[index][Math.floorMod(ArrayUtils.indexOf((Object[])this.hands[index], (Object)this.builderSummon.getHandItem(index)) + 1, this.hands[index].length)]);
                    container.func_231160_c_();
                }));
                button1.field_230693_o_ = false;
            }
            button7.field_230693_o_ = false;
        }
    }

    private void send() {
        CommandHelper.sendCommand(this.builderSummon, this.builderSummon.getCustomName().isSpecial());
    }

    @Override
    public void tick(Container container) {
        if (Page.START.equals((Object)this.page)) {
            this.mobField.func_146178_a();
            this.customNameField.func_146178_a();
            this.passengerField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(MatrixStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page)) {
            this.mobField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.customNameField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.passengerField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        } else if (Page.POTIONS.equals((Object)this.page)) {
            Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrix, this.potionPage + 1 + "/" + (ForgeRegistries.POTIONS.getKeys().size() - 2), (float)(x + 118), (float)(y - 11), Config.getSkin().getHeadlineColor());
        } else if (Page.EQUIPMENT.equals((Object)this.page)) {
            int i;
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/beacon.png"));
            container.func_230926_e_(0);
            for (i = 0; i < 4; ++i) {
                if (!this.builderSummon.getArmorItem(i).equals((Object)Items.field_190931_a.getRegistryName())) continue;
                container.func_238474_b_(matrix, x + 118 + 24 + 2, y + 2 + 24 * i, 112, 221, 16, 16);
            }
            for (i = 0; i < 2; ++i) {
                if (!this.builderSummon.getHandItem(i).equals((Object)Items.field_190931_a.getRegistryName())) continue;
                container.func_238474_b_(matrix, x + 118 + 70 + 2 + 24 * i, y + 2 + 36, 112, 221, 16, 16);
            }
        }
    }

    private List<ResourceLocation> getSortedPotionList() {
        return ForgeRegistries.POTIONS.getKeys().stream().sorted((a, b) -> I18n.func_135052_a((String)((Effect)ForgeRegistries.POTIONS.getValue(a)).func_76393_a(), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)((Effect)ForgeRegistries.POTIONS.getValue(b)).func_76393_a(), (Object[])new Object[0]))).collect(Collectors.toList());
    }

    @Override
    public Category getCategory() {
        return Categories.ENTITIES;
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.entities.summon");
    }

    @Override
    public IFormattableTextComponent getTabTitle() {
        return new TranslationTextComponent("gui.worldhandler.tab.entities.summon");
    }

    @Override
    public Content getActiveContent() {
        return Contents.SUMMON;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Page {
        START,
        POTIONS,
        ATTRIBUTES,
        EQUIPMENT;

    }
}

