/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.blaze3d.matrix.MatrixStack;
import exopandora.worldhandler.builder.CommandSyntax;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderMultiCommand;
import exopandora.worldhandler.builder.impl.BuilderUsercontent;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.usercontent.ScriptEngineAdapter;
import exopandora.worldhandler.usercontent.UsercontentAPI;
import exopandora.worldhandler.usercontent.UsercontentConfig;
import exopandora.worldhandler.usercontent.VisibleActiveObject;
import exopandora.worldhandler.usercontent.VisibleObject;
import exopandora.worldhandler.usercontent.factory.ActionHandlerFactory;
import exopandora.worldhandler.usercontent.factory.ButtonFactory;
import exopandora.worldhandler.usercontent.factory.MenuFactory;
import exopandora.worldhandler.usercontent.model.JsonButton;
import exopandora.worldhandler.usercontent.model.JsonCommand;
import exopandora.worldhandler.usercontent.model.JsonMenu;
import exopandora.worldhandler.usercontent.model.JsonModel;
import exopandora.worldhandler.usercontent.model.JsonText;
import exopandora.worldhandler.usercontent.model.JsonUsercontent;
import exopandora.worldhandler.usercontent.model.JsonWidget;
import exopandora.worldhandler.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentUsercontent
extends Content {
    private final String id;
    private final JsonUsercontent content;
    private final ScriptEngineAdapter engineAdapter;
    private final List<VisibleObject<BuilderUsercontent>> builders;
    private final Map<String, VisibleActiveObject<TextFieldWidget>> textfields = new HashMap<String, VisibleActiveObject<TextFieldWidget>>();
    private final List<VisibleActiveObject<Widget>> buttons = new ArrayList<VisibleActiveObject<Widget>>();
    private UsercontentAPI api;
    private ButtonFactory buttonFactory;
    private MenuFactory menuFactory;

    public ContentUsercontent(UsercontentConfig config) throws Exception {
        this.id = config.getId();
        this.content = config.getContent();
        this.engineAdapter = new ScriptEngineAdapter(config.getScriptEngine());
        this.builders = this.createBuilders(this.content.getModel());
        this.api = new UsercontentAPI(this.builders.stream().map(VisibleObject::getObject).collect(Collectors.toList()));
        ActionHandlerFactory actionHandlerFactory = new ActionHandlerFactory(this.api, this.builders, this.engineAdapter);
        this.buttonFactory = new ButtonFactory(this.api, actionHandlerFactory);
        this.menuFactory = new MenuFactory(this.api, actionHandlerFactory);
        this.engineAdapter.addObject("api", this.api);
        this.engineAdapter.eval(config.getJs());
    }

    @Override
    public ICommandBuilder getCommandBuilder() {
        ICommandBuilder[] builders = (ICommandBuilder[])this.builders.stream().filter(builder -> builder.isVisible(this.engineAdapter)).map(VisibleObject::getObject).toArray(ICommandBuilder[]::new);
        return builders.length > 0 ? new BuilderMultiCommand(builders) : null;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.textfields.clear();
        this.buttons.clear();
        for (JsonButton button : this.getWidgets(this.content.getGui().getButtons(), JsonWidget.Type.BUTTON)) {
            Widget widget = this.buttonFactory.createButton(button, this, container, x, y);
            if (JsonButton.Type.TEXTFIELD.equals((Object)button.getType())) {
                VisibleActiveObject<TextFieldWidget> visObj = new VisibleActiveObject<TextFieldWidget>(button, (TextFieldWidget)widget);
                this.textfields.put(button.getAttributes().getId(), visObj);
                continue;
            }
            this.buttons.add(new VisibleActiveObject<Widget>(button, widget));
        }
        for (JsonMenu menu : this.getWidgets(this.content.getGui().getMenus(), JsonWidget.Type.MENU)) {
            container.add(this.menuFactory.createMenu(menu, this, container, x, y));
        }
        this.updateTextfields();
        this.updateButtons();
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        this.textfields.values().stream().map(VisibleObject::getObject).forEach(container::add);
        this.buttons.stream().map(VisibleObject::getObject).forEach(container::add);
    }

    @Override
    public void tick(Container container) {
        for (VisibleObject visibleObject : this.textfields.values()) {
            if (!visibleObject.isVisible(this.engineAdapter)) continue;
            ((TextFieldWidget)visibleObject.getObject()).func_146178_a();
        }
        this.updateButtons();
        this.updateTextfields();
    }

    @Override
    public void drawScreen(MatrixStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        for (VisibleObject visibleObject : this.textfields.values()) {
            if (!((TextFieldWidget)visibleObject.getObject()).field_230694_p_) continue;
            ((TextFieldWidget)visibleObject.getObject()).func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        }
        if (this.content.getGui() != null && this.content.getGui().getTexts() != null) {
            for (JsonText jsonText : this.content.getGui().getTexts()) {
                if (jsonText.getVisible() != null && !jsonText.getVisible().eval(this.engineAdapter)) continue;
                container.getMinecraft().field_71466_p.func_238422_b_(matrix, (ITextProperties)TextUtils.formatNonnull(jsonText.getText(), new Object[0]), (float)(jsonText.getX() + x), (float)(jsonText.getY() + y), jsonText.getColor());
            }
        }
    }

    @Override
    public Category getCategory() {
        return Categories.getRegisteredCategory(this.content.getGui().getTab().getCategory());
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return TextUtils.formatNonnull(this.content.getGui().getTitle(), new Object[0]);
    }

    @Override
    public IFormattableTextComponent getTabTitle() {
        return TextUtils.formatNonnull(this.content.getGui().getTab().getTitle(), new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        if (this.content.getGui().getTab().getActiveContent() == null) {
            return this;
        }
        return Contents.getRegisteredContent(this.content.getGui().getTab().getActiveContent());
    }

    @Override
    public Content getBackContent() {
        if (this.content.getGui().getTab().getActiveContent() == null) {
            return super.getBackContent();
        }
        return Contents.getRegisteredContent(this.content.getGui().getTab().getBackContent());
    }

    @Override
    public void onPlayerNameChanged(String username) {
        for (VisibleObject<BuilderUsercontent> visObj : this.builders) {
            visObj.getObject().setPlayerName(username);
        }
    }

    private List<VisibleObject<BuilderUsercontent>> createBuilders(JsonModel model) {
        ArrayList<VisibleObject<BuilderUsercontent>> builders = new ArrayList<VisibleObject<BuilderUsercontent>>();
        if (model != null && model.getCommands() != null) {
            for (JsonCommand command : model.getCommands()) {
                if (command.getName() == null || command.getSyntax() == null) continue;
                BuilderUsercontent builder = new BuilderUsercontent(command.getName(), new CommandSyntax(command.getSyntax()));
                builders.add(new VisibleObject<BuilderUsercontent>(command.getVisible(), builder));
            }
        }
        return builders;
    }

    private <T extends JsonWidget<?>> List<T> getWidgets(List<T> list, JsonWidget.Type type) {
        ArrayList<JsonWidget> result = new ArrayList<JsonWidget>();
        if (list == null) {
            return result;
        }
        for (int x = 0; x < list.size(); ++x) {
            JsonWidget widget = (JsonWidget)list.get(x);
            try {
                widget.validate();
                result.add(widget);
                continue;
            }
            catch (Exception e) {
                this.printError(type.toString().toLowerCase(), x, e);
            }
        }
        return result;
    }

    private void printError(String type, int index, Throwable e) {
        StringTextComponent message = new StringTextComponent(TextFormatting.RED + "<" + "World Handler" + ":" + this.id + ":" + type + ":" + index + "> " + e.getMessage());
        Minecraft.func_71410_x().field_71456_v.func_238450_a_(ChatType.CHAT, (ITextComponent)message, Util.field_240973_b_);
    }

    private void updateTextfields() {
        for (VisibleActiveObject<TextFieldWidget> visObj : this.textfields.values()) {
            ((TextFieldWidget)visObj.getObject()).func_146184_c(visObj.isEnabled(this.engineAdapter));
            ((TextFieldWidget)visObj.getObject()).field_230694_p_ = visObj.isVisible(this.engineAdapter);
        }
    }

    private void updateButtons() {
        for (VisibleActiveObject<Widget> visObj : this.buttons) {
            ((Widget)visObj.getObject()).field_230693_o_ = visObj.isEnabled(this.engineAdapter);
            ((Widget)visObj.getObject()).field_230694_p_ = visObj.isVisible(this.engineAdapter);
        }
    }
}

