/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.blaze3d.matrix.MatrixStack;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentWorldInfo
extends Content {
    private Page page = Page.START;
    private GuiTextFieldTooltip posXField;
    private GuiTextFieldTooltip posYField;
    private GuiTextFieldTooltip posZField;
    private GuiTextFieldTooltip worldField;
    private GuiTextFieldTooltip seedField;
    private GuiTextFieldTooltip totalTimeField;
    private GuiTextFieldTooltip currentTimeField;

    @Override
    public void initGui(Container container, int x, int y) {
        World world = ContentWorldInfo.getSidedWorld();
        IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
        this.posXField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20);
        this.posXField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " X: " + ContentWorldInfo.format(world, object -> object.func_72912_H().func_76079_c()));
        this.posYField = new GuiTextFieldTooltip(x + 118, y + 36, 114, 20);
        this.posYField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " Y: " + ContentWorldInfo.format(world, object -> object.func_72912_H().func_76075_d()));
        this.posZField = new GuiTextFieldTooltip(x + 118, y + 60, 114, 20);
        this.posZField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " Z: " + ContentWorldInfo.format(world, object -> object.func_72912_H().func_76074_e()));
        this.worldField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20);
        this.worldField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.world.name", (Object[])new Object[0]) + ": " + ContentWorldInfo.format(server, object -> object.func_240793_aU_().func_76065_j()));
        this.seedField = new GuiTextFieldTooltip(x + 118, y + 36, 114, 20);
        this.seedField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.world.seed", (Object[])new Object[0]) + ": " + ContentWorldInfo.format(server, object -> object.func_241755_D_().func_72905_C()));
        this.seedField.func_200675_a(string -> string.equals(this.seedField.func_146179_b()));
        this.seedField.func_146196_d();
        this.currentTimeField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20);
        this.updateCurrentTime();
        this.totalTimeField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20);
        this.updateTotalTime();
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase start = new GuiButtonBase(x, y + 12, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.world_info.start"), () -> {
            this.page = Page.START;
            container.func_231160_c_();
        });
        container.add(start);
        GuiButtonBase world = new GuiButtonBase(x, y + 36, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.world_info.world"), () -> {
            this.page = Page.WORLD;
            container.func_231160_c_();
        });
        container.add(world);
        GuiButtonBase stats = new GuiButtonBase(x, y + 60, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.world_info.statistics"), () -> {
            this.page = Page.STATS;
            container.func_231160_c_();
        });
        container.add(stats);
        if (Page.START.equals((Object)this.page)) {
            start.field_230693_o_ = false;
        } else if (Page.WORLD.equals((Object)this.page)) {
            IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
            world.field_230693_o_ = false;
            GuiButtonBase seed = new GuiButtonBase(x + 118, y + 60, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.world_info.world.copy_seed"), () -> Minecraft.func_71410_x().field_195559_v.func_197960_a(String.valueOf(server.func_241755_D_().func_72905_C())));
            container.add(seed);
            seed.field_230693_o_ = server != null;
        } else if (Page.STATS.equals((Object)this.page)) {
            stats.field_230693_o_ = false;
        }
    }

    @Override
    public void tick(Container container) {
        this.updateCurrentTime();
        this.updateTotalTime();
        this.seedField.func_146178_a();
    }

    @Override
    public void drawScreen(MatrixStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page)) {
            this.posXField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.posYField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.posZField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        } else if (Page.WORLD.equals((Object)this.page)) {
            this.worldField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.seedField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        } else if (Page.STATS.equals((Object)this.page)) {
            this.totalTimeField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.currentTimeField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    private void updateCurrentTime() {
        this.currentTimeField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.statistics.world_time", (Object[])new Object[0]) + ": " + TextUtils.formatWorldTime(Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76073_f()));
    }

    private void updateTotalTime() {
        this.totalTimeField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.world_info.statistics.played", (Object[])new Object[0]) + ": " + TextUtils.formatTotalTime(Minecraft.func_71410_x().field_71441_e.func_72912_H().func_82573_f()));
    }

    private static <T> String format(T object, Function<T, Object> function) {
        if (object != null) {
            return String.valueOf(function.apply(object));
        }
        return I18n.func_135052_a((String)"gui.worldhandler.world_info.n_a", (Object[])new Object[0]);
    }

    private static World getSidedWorld() {
        if (Minecraft.func_71410_x().func_71356_B()) {
            return Minecraft.func_71410_x().func_71401_C().func_241755_D_();
        }
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public Category getCategory() {
        return Categories.WORLD;
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.world.world");
    }

    @Override
    public IFormattableTextComponent getTabTitle() {
        return new TranslationTextComponent("gui.worldhandler.tab.world.world");
    }

    @Override
    public Content getActiveContent() {
        return Contents.WORLD_INFO;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Page {
        START,
        WORLD,
        STATS;

    }
}

