/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.usercontent.model;

import com.google.gson.annotations.SerializedName;
import exopandora.worldhandler.usercontent.model.Action;
import exopandora.worldhandler.usercontent.model.Attributes;
import exopandora.worldhandler.usercontent.model.JsonDimensions;
import exopandora.worldhandler.usercontent.model.JsonWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JsonButton
extends JsonWidget<Type> {
    @SerializedName(value="text")
    private String text;
    @SerializedName(value="type")
    private Type type;

    public JsonButton(String text, Type type, Action action, JsonDimensions dimensions, Attributes attributes) {
        super(action, dimensions, attributes);
        this.text = text;
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void validate() throws IllegalStateException {
        if (this.type == null) {
            throw new IllegalStateException("button.type is null");
        }
        if (this.type == Type.TEXTFIELD) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("button.attributes is null");
            }
            if (this.getAttributes().getId() == null) {
                throw new IllegalStateException("button.attributes.id is null");
            }
            if (this.getAttributes().getId().isEmpty()) {
                throw new IllegalStateException("button.attributes.id is empty");
            }
            this.validateAction(Action.Type.SET, Action.Type.JS);
        } else if (this.type == Type.ITEM_BUTTON) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("button.attributes is null");
            }
            if (this.getAttributes().getItem() == null) {
                throw new IllegalStateException("button.attributes.item is null");
            }
            this.validateAction(Action.Type.OPEN, Action.Type.SET, Action.Type.RUN, Action.Type.BACK, Action.Type.BACK_TO_GAME, Action.Type.JS);
        } else if (this.type == Type.ICON_BUTTON) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("button.attributes is null");
            }
            if (this.getAttributes().getIcon() == null) {
                throw new IllegalStateException("button.attributes.icon is null");
            }
            this.validateAction(Action.Type.OPEN, Action.Type.SET, Action.Type.RUN, Action.Type.BACK, Action.Type.BACK_TO_GAME, Action.Type.JS);
        } else if (this.type == Type.LIST_BUTTON) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("button.attributes is null");
            }
            if (this.getAttributes().getItems() == null) {
                throw new IllegalStateException("button.attributes.items is null");
            }
            if (this.getAttributes().getItems().isEmpty()) {
                throw new IllegalStateException("button.attributes.items is empty");
            }
            this.validateAction(Action.Type.SET, Action.Type.JS);
        } else if (this.type == Type.SLIDER) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("button.attributes is null");
            }
            this.validateAction(Action.Type.SET, Action.Type.JS);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        BUTTON,
        TEXTFIELD,
        ITEM_BUTTON,
        ICON_BUTTON,
        LIST_BUTTON,
        SLIDER;

    }
}

