/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.usercontent.model;

import com.google.gson.annotations.SerializedName;
import exopandora.worldhandler.usercontent.model.Action;
import exopandora.worldhandler.usercontent.model.Attributes;
import exopandora.worldhandler.usercontent.model.JsonDimensions;
import java.util.Arrays;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class JsonWidget<T extends Enum<T>> {
    @SerializedName(value="action")
    private Action action;
    @SerializedName(value="dimensions")
    private JsonDimensions dimensions;
    @SerializedName(value="attributes")
    private Attributes attributes;

    public JsonWidget(Action action, JsonDimensions dimensions, Attributes attributes) {
        this.action = action;
        this.dimensions = dimensions;
        this.attributes = attributes;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public JsonDimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(JsonDimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public abstract T getType();

    public abstract void setType(T var1);

    public abstract void validate() throws IllegalStateException;

    protected void validateAction(Action.Type ... allowedTypes) throws IllegalStateException {
        if (this.getAction() != null) {
            this.getAction().validate();
            if (Arrays.stream(allowedTypes).noneMatch(type -> type.equals((Object)this.getAction().getType()))) {
                throw new IllegalStateException("Illegal action for type " + ((Enum)this.getType()).toString().toLowerCase());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        BUTTON,
        MENU;

    }
}

