/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.impl.BuilderDifficulty;
import exopandora.worldhandler.builder.impl.BuilderGamemode;
import exopandora.worldhandler.builder.impl.BuilderTime;
import exopandora.worldhandler.builder.impl.BuilderWeather;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.impl.GuiWorldHandler;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.gui.content.impl.ContentContinue;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.NoteBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ActionHelper {
    public static void backToGame() {
        Minecraft.func_71410_x().func_147108_a(null);
        Minecraft.func_71410_x().field_71417_B.func_198034_i();
    }

    public static void back(Content content) throws Exception {
        if (content.getBackContent() != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldHandler(content.getBackContent()));
        }
    }

    public static void changeTab(Content content, int index) {
        ActionHelper.tryRun(() -> ActionHelper.open(content.getCategory().getContent(index)));
    }

    public static void open(String id) throws Exception {
        if (id != null) {
            ActionHelper.open(Contents.getRegisteredContent(id));
        }
    }

    public static void open(Content content) throws Exception {
        if (content != null && !(content instanceof ContentContinue)) {
            if (content instanceof ContentChild && Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiWorldHandler) {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldHandler(((ContentChild)content).withParent(((GuiWorldHandler)Minecraft.func_71410_x().field_71462_r).getContent())));
            } else {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldHandler(content));
            }
        }
    }

    public static void timeDawn() {
        CommandHelper.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, Config.getSettings().getDawn()));
    }

    public static void timeNoon() {
        CommandHelper.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, Config.getSettings().getNoon()));
    }

    public static void timeSunset() {
        CommandHelper.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, Config.getSettings().getSunset()));
    }

    public static void timeMidnight() {
        CommandHelper.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, Config.getSettings().getMidnight()));
    }

    public static void weatherClear() {
        CommandHelper.sendCommand(new BuilderWeather(BuilderWeather.EnumWeather.CLEAR));
    }

    public static void weatherRain() {
        CommandHelper.sendCommand(new BuilderWeather(BuilderWeather.EnumWeather.RAIN));
    }

    public static void weatherThunder() {
        CommandHelper.sendCommand(new BuilderWeather(BuilderWeather.EnumWeather.THUNDER));
    }

    public static void difficultyPeaceful() {
        CommandHelper.sendCommand(new BuilderDifficulty(Difficulty.PEACEFUL));
    }

    public static void difficultyEasy() {
        CommandHelper.sendCommand(new BuilderDifficulty(Difficulty.EASY));
    }

    public static void difficultyNormal() {
        CommandHelper.sendCommand(new BuilderDifficulty(Difficulty.NORMAL));
    }

    public static void difficultyHard() {
        CommandHelper.sendCommand(new BuilderDifficulty(Difficulty.HARD));
    }

    public static void gamemodeSurvival() {
        CommandHelper.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.SURVIVAL));
    }

    public static void gamemodeCreative() {
        CommandHelper.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.CREATIVE));
    }

    public static void gamemodeAdventure() {
        CommandHelper.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.ADVENTURE));
    }

    public static void gamemodeSpectator() {
        CommandHelper.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.SPECTATOR));
    }

    public static void tryRun(ActionHandler action) {
        try {
            if (action != null) {
                action.run();
            }
        }
        catch (Exception e) {
            Minecraft.func_71410_x().func_147108_a(null);
            Minecraft.func_71410_x().field_71417_B.func_198034_i();
            IFormattableTextComponent message = new TranslationTextComponent("<World Handler> %s", new Object[]{new TranslationTextComponent("worldhandler.error.gui")}).func_240699_a_(TextFormatting.RED);
            IFormattableTextComponent cause = new StringTextComponent(" " + e.getClass().getCanonicalName() + ": " + e.getMessage()).func_240699_a_(TextFormatting.RED);
            Minecraft.func_71410_x().field_71456_v.func_238450_a_(ChatType.SYSTEM, (ITextComponent)message, Util.field_240973_b_);
            Minecraft.func_71410_x().field_71456_v.func_238450_a_(ChatType.SYSTEM, (ITextComponent)cause, Util.field_240973_b_);
            WorldHandler.LOGGER.throwing((Throwable)e);
        }
    }

    public static void displayGui() {
        if (!CommandHelper.canPlayerIssueCommand() && Config.getSettings().permissionQuery()) {
            Minecraft.func_71410_x().field_71456_v.func_238450_a_(ChatType.SYSTEM, (ITextComponent)new StringTextComponent(TextFormatting.RED + I18n.func_135052_a((String)"worldhandler.permission.refused", (Object[])new Object[0])), Util.field_240973_b_);
            Minecraft.func_71410_x().field_71456_v.func_238450_a_(ChatType.SYSTEM, (ITextComponent)new StringTextComponent(TextFormatting.RED + I18n.func_135052_a((String)"worldhandler.permission.refused.change", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.config.settings.permission_query", (Object[])new Object[0])})), Util.field_240973_b_);
        } else {
            ActionHelper.tryRun(() -> {
                if (BlockHelper.getFocusedBlock() instanceof AbstractSignBlock) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldHandler(Contents.SIGN_EDITOR));
                } else if (BlockHelper.getFocusedBlock() instanceof NoteBlock) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldHandler(Contents.NOTE_EDITOR));
                } else {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldHandler(Contents.MAIN));
                }
            });
        }
    }
}

