/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import exopandora.worldhandler.builder.INBTWritable;
import exopandora.worldhandler.builder.component.IBuilderComponent;
import exopandora.worldhandler.builder.component.impl.EntityNBT;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NBTHelper {
    public static INBT serialize(BlockState blockState) {
        return blockState != null ? NBTUtil.func_190009_a((BlockState)blockState) : null;
    }

    public static INBT serialize(double[] vector) {
        if (vector.length == 3 && (vector[0] != 0.0 || vector[1] != 0.0 || vector[2] != 0.0)) {
            ListNBT list = new ListNBT();
            list.add((Object)DoubleNBT.func_229684_a_((double)vector[0]));
            list.add((Object)DoubleNBT.func_229684_a_((double)vector[1]));
            list.add((Object)DoubleNBT.func_229684_a_((double)vector[2]));
            return list;
        }
        return null;
    }

    public static INBT serialize(ResourceLocation resource) {
        if (resource != null) {
            return StringNBT.func_229705_a_((String)resource.toString());
        }
        return null;
    }

    public static INBT serialize(ResourceLocation[] itemArray) {
        if (Arrays.stream(itemArray).allMatch(resource -> Items.field_190931_a.getRegistryName().equals(resource))) {
            return null;
        }
        ListNBT list = new ListNBT();
        for (ResourceLocation item : itemArray) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("id", item.toString());
            compound.func_74768_a("Count", 1);
            list.add((Object)compound);
        }
        return list;
    }

    public static INBT serialize(List<EntityNBT> entities) {
        ListNBT list = new ListNBT();
        for (EntityNBT entity : entities) {
            CompoundNBT nbt = entity.serialize();
            if (nbt == null) continue;
            list.add((Object)nbt);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static void append(CompoundNBT compound, String tag, INBTWritable writable) {
        NBTHelper.append(compound, tag, writable.serialize());
    }

    public static void append(CompoundNBT compound, IBuilderComponent component) {
        NBTHelper.append(compound, component.getTag(), component.serialize());
    }

    public static void append(CompoundNBT compound, String tag, INBT nbt) {
        if (nbt != null && !compound.func_74764_b(tag)) {
            compound.func_218657_a(tag, nbt);
        }
    }
}

