/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.util.ResourceHelper;
import exopandora.worldhandler.util.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtils {
    public static void drawWatchIntoGui(MatrixStack matrix, AbstractGui gui, int width, int height, long worldTicks, boolean smooth) {
        float hour = TextUtils.toHour(worldTicks);
        float minute = TextUtils.toMinute(worldTicks);
        if (smooth) {
            hour = (float)(worldTicks + 6000L) / 1000.0f;
            minute = (float)(((double)((float)worldTicks + 6000.0f) - Math.floor(hour) * 1000.0) * 6.0 / 100.0);
        }
        float rotationHour = 30.0f * (hour >= 12.0f ? hour - 12.0f : hour) - 180.0f;
        float rotationMinute = 6.0f * minute - 180.0f;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)(width + 5), (double)(height + 5), 0.0);
        matrix.func_227862_a_(0.25f, 0.25f, 0.25f);
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotationHour));
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)-1, (int)-1, (int)1, (int)11, (int)-13092808);
        matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(rotationHour));
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotationMinute));
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)-1, (int)-1, (int)1, (int)15, (int)-9474193);
        matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(rotationMinute));
        matrix.func_227865_b_();
        RenderUtils.color(Config.getSkin().getButtonRedF(), Config.getSkin().getButtonGreenF(), Config.getSkin().getButtonBlueF(), Config.getSkin().getButtonAlphaF());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceHelper.getIconTexture());
        gui.func_238474_b_(matrix, width + 0, height, 48, 0, 10, 10);
        matrix.func_227860_a_();
        matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
        Screen.func_238467_a_((MatrixStack)matrix, (int)((width + 5) * 2 - 1), (int)((height + 4) * 2 + 1), (int)((width + 6) * 2 - 1), (int)((height + 5) * 2 + 1), (int)-16777216);
        matrix.func_227865_b_();
    }

    public static void renderItemIntoGUI(MatrixStack matrix, ItemStack stack, int x, int y) {
        boolean flag;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        IBakedModel bakedmodel = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, (World)null, (LivingEntity)null);
        matrix.func_227860_a_();
        textureManager.func_110577_a(PlayerContainer.field_226615_c_);
        textureManager.func_229267_b_(PlayerContainer.field_226615_c_).func_174937_a(false, false);
        RenderUtils.enableRescaleNormal();
        RenderUtils.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        matrix.func_227861_a_((double)x, (double)y, (double)(100.0f + itemRenderer.field_77023_b));
        matrix.func_227861_a_(8.0, 8.0, 0.0);
        matrix.func_227862_a_(1.0f, -1.0f, 1.0f);
        matrix.func_227862_a_(16.0f, 16.0f, 16.0f);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrix, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        buffer.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderUtils.disableAlphaTest();
        RenderUtils.disableRescaleNormal();
        matrix.func_227865_b_();
    }

    public static void color(float r, float g, float b, float a) {
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void color(float r, float g, float b) {
        RenderSystem.color3f((float)r, (float)g, (float)b);
    }

    public static void enableAlphaTest() {
        RenderSystem.enableAlphaTest();
    }

    public static void disableAlphaTest() {
        RenderSystem.disableAlphaTest();
    }

    public static void enableRescaleNormal() {
        RenderSystem.enableRescaleNormal();
    }

    public static void disableRescaleNormal() {
        RenderSystem.disableRescaleNormal();
    }

    public static void disableLighting() {
        RenderSystem.disableLighting();
    }
}

