/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextUtils {
    public static final StringTextComponent ARROW_LEFT = new StringTextComponent("<");
    public static final StringTextComponent ARROW_RIGHT = new StringTextComponent(">");
    public static final IFormattableTextComponent ARROW_LEFT_BOLD = new StringTextComponent("<").func_240699_a_(TextFormatting.BOLD);
    public static final IFormattableTextComponent ARROW_RIGHT_BOLD = new StringTextComponent(">").func_240699_a_(TextFormatting.BOLD);

    public static IFormattableTextComponent stripText(IFormattableTextComponent string, int maxWidth, FontRenderer fontRenderer) {
        return TextUtils.stripText(string, (IFormattableTextComponent)StringTextComponent.field_240750_d_, maxWidth, fontRenderer);
    }

    public static IFormattableTextComponent stripText(IFormattableTextComponent string, IFormattableTextComponent prefix, int maxWidth, FontRenderer fontRenderer) {
        if (fontRenderer.func_238414_a_((ITextProperties)prefix) + fontRenderer.func_238414_a_((ITextProperties)string) > maxWidth - fontRenderer.func_238414_a_((ITextProperties)prefix)) {
            IFormattableTextComponent result = new StringTextComponent("").func_240703_c_(string.func_150256_b());
            for (char c : string.getString().toCharArray()) {
                IFormattableTextComponent extension = new StringTextComponent(result.getString() + c + "...").func_240703_c_(string.func_150256_b());
                if (fontRenderer.func_238414_a_((ITextProperties)extension) >= maxWidth) {
                    return new StringTextComponent(result.getString() + "...").func_240703_c_(string.func_150256_b());
                }
                result = new StringTextComponent(result.getString() + c).func_240703_c_(string.func_150256_b());
            }
        }
        return prefix.func_230531_f_().func_230529_a_((ITextComponent)string);
    }

    public static String formatTotalTime(long tick) {
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        seconds = (int)(tick / 20L);
        if (seconds > 60) {
            int min = MathHelper.func_76141_d((float)(seconds / 60));
            seconds %= 60;
            minutes = min;
        }
        if (minutes > 60) {
            int hrs = MathHelper.func_76141_d((float)(minutes / 60));
            minutes %= 60;
            hours = hrs;
        }
        if (hours > 24) {
            int day = MathHelper.func_76141_d((float)(hours / 24));
            hours %= 24;
            days = day;
        }
        return String.format("%d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static int toHour(long tick) {
        int hour = MathHelper.func_76141_d((float)((float)(tick + 6000L) / 1000.0f)) % 24;
        return hour;
    }

    public static int toMinute(long tick) {
        int hour = MathHelper.func_76141_d((float)(((float)tick + 6000.0f) / 1000.0f));
        int minute = MathHelper.func_76141_d((float)(((float)tick + 6000.0f - (float)(hour * 1000)) * 6.0f / 100.0f));
        return minute;
    }

    public static String formatWorldTime(long tick) {
        int hour = TextUtils.toHour(tick);
        int minute = TextUtils.toMinute(tick);
        return String.format("%02d:%02d", hour, minute);
    }

    @Nonnull
    public static IFormattableTextComponent formatNonnull(String text, Object ... parameters) {
        if (text == null) {
            return (IFormattableTextComponent)StringTextComponent.field_240750_d_;
        }
        return new TranslationTextComponent(text, parameters);
    }
}

