/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.ButterflyLeviathanEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.render.ButterflyLeviathanRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.canariwyvern.CanariWyvernEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.canariwyvern.CanariWyvernRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.dfruitdrake.DragonFruitDrakeEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.dfruitdrake.DragonFruitDrakeRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.minutus.MinutusEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.minutus.MinutusRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.owdrake.OWDrakeEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.owdrake.OWDrakeRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.rooststalker.RoostStalkerEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.rooststalker.RoostStalkerRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.sliverglider.SilverGliderEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.sliverglider.SilverGliderRenderer;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggEntity;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggRenderer;
import WolfShotz.Wyrmroost.content.entities.multipart.MultiPartEntity;
import WolfShotz.Wyrmroost.content.io.screen.DebugScreen;
import WolfShotz.Wyrmroost.content.items.CustomSpawnEggItem;
import WolfShotz.Wyrmroost.content.items.DragonStaffItem;
import WolfShotz.Wyrmroost.registry.WRIO;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.registry.WRKeyBinds;
import WolfShotz.Wyrmroost.util.ConfigData;
import WolfShotz.Wyrmroost.util.ModUtils;
import WolfShotz.Wyrmroost.util.network.messages.DragonKeyBindMessage;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientEvents {
    public static AxisAlignedBB debugBox;
    public static int time;

    public static void onModConstruction(IEventBus bus) {
        bus.addListener(ClientEvents::clientSetup);
        bus.addListener(ClientEvents::registerItemColors);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ClientEvents.class);
        ClientEvents.registerEntityRenders();
        WRKeyBinds.registerKeys();
        WRIO.screenSetup();
    }

    public static void registerItemColors(ColorHandlerEvent.Item evt) {
        ItemColors handler = evt.getItemColors();
        IItemColor eggColor = (stack, tintIndex) -> ((CustomSpawnEggItem)stack.func_77973_b()).getColors(tintIndex);
        CustomSpawnEggItem.EGG_TYPES.forEach(e -> handler.func_199877_a(eggColor, new IItemProvider[]{e}));
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        AbstractDragonEntity dragon;
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (WRKeyBinds.genericAttack.func_151468_f()) {
            if (!(player.func_184187_bx() instanceof AbstractDragonEntity)) {
                return;
            }
            dragon = (AbstractDragonEntity)player.func_184187_bx();
            if (dragon.noActiveAnimation()) {
                dragon.performGenericAttack();
                Wyrmroost.NETWORK.sendToServer((Object)new DragonKeyBindMessage(dragon, 0));
            }
        }
        if (WRKeyBinds.specialAttack.func_151468_f()) {
            if (!(player.func_184187_bx() instanceof AbstractDragonEntity)) {
                return;
            }
            dragon = (AbstractDragonEntity)player.func_184187_bx();
            if (dragon.noActiveAnimation()) {
                dragon.performAltAttack(true);
                Wyrmroost.NETWORK.sendToServer((Object)new DragonKeyBindMessage(dragon, 1));
            }
        }
    }

    @SubscribeEvent
    public static void cameraPerspective(EntityViewRenderEvent.CameraSetup event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.field_71439_g.func_184187_bx();
        if (!(entity instanceof AbstractDragonEntity)) {
            return;
        }
        int i1 = mc.field_71474_y.field_74320_O;
        if (i1 != 0) {
            ((AbstractDragonEntity)entity).setMountCameraAngles(i1 == 1);
        }
    }

    @SubscribeEvent
    public static void renderWorld(RenderWorldLastEvent event) {
        ClientEvents.renderDebugBox();
    }

    public static void renderDragonStaff() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ItemStack stack = ModUtils.getHeldStack((PlayerEntity)player, (Item)WRItems.DRAGON_STAFF.get());
        if (stack.func_77973_b() instanceof DragonStaffItem) {
            AbstractDragonEntity dragon = DragonStaffItem.getDragon(stack, ModUtils.getServerWorld((PlayerEntity)player));
            ActiveRenderInfo renderInfo = mc.field_71460_t.func_215316_n();
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            double d0 = renderInfo.func_216785_c().field_72450_a;
            double d1 = renderInfo.func_216785_c().field_72448_b;
            double d2 = renderInfo.func_216785_c().field_72449_c;
            if (dragon != null) {
                if (dragon.getHomePos().isPresent()) {
                    BlockPos homePos = dragon.getHomePos().get();
                    ResourceLocation loc = Wyrmroost.rl("textures/io/homepos.png");
                    double x = (double)homePos.func_177958_n() - d0;
                    double y = (double)homePos.func_177956_o() - d1;
                    double z = (double)homePos.func_177952_p() - d2;
                    GlStateManager.pushMatrix();
                    GlStateManager.depthFunc((int)519);
                    GlStateManager.translated((double)(x + 0.5), (double)(y + Math.sin((double)dragon.field_70173_aa * 0.06) * 0.5 + 3.0), (double)(z + 0.5));
                    GlStateManager.rotatef((float)(-renderInfo.func_216778_f()), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.rotatef((float)renderInfo.func_216777_e(), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    mc.field_71446_o.func_110577_a(loc);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    buffer.func_181662_b(0.5, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b(0.5, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b(-0.5, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(-0.5, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                    Tessellator.func_178181_a().func_78381_a();
                    buffer.func_178969_c(0.0, 0.0, 0.0);
                    GlStateManager.depthFunc((int)515);
                    GlStateManager.popMatrix();
                } else {
                    BlockPos blockpos;
                    BlockState blockstate;
                    ClientWorld world = mc.field_71441_e;
                    if (mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && (blockstate = world.func_180495_p(blockpos = ((BlockRayTraceResult)mc.field_71476_x).func_216350_a())).func_200132_m() && world.func_175723_af().func_177746_a(blockpos)) {
                        GlStateManager.enableBlend();
                        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        GlStateManager.lineWidth((float)1000.0f);
                        GlStateManager.disableTexture();
                        GlStateManager.depthMask((boolean)false);
                        GlStateManager.matrixMode((int)5889);
                        GlStateManager.pushMatrix();
                        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)0.999f);
                        WorldRenderer.func_195463_b((VoxelShape)blockstate.func_215700_a((IBlockReader)world, blockpos, ISelectionContext.func_216374_a((Entity)renderInfo.func_216773_g())), (double)((double)blockpos.func_177958_n() - d0), (double)((double)blockpos.func_177956_o() - d1), (double)((double)blockpos.func_177952_p() - d2), (float)0.0f, (float)0.0f, (float)1.0f, (float)0.2f);
                        GlStateManager.popMatrix();
                        GlStateManager.matrixMode((int)5888);
                        GlStateManager.depthMask((boolean)true);
                        GlStateManager.enableTexture();
                        GlStateManager.disableBlend();
                    }
                }
            }
        }
    }

    public static void renderDebugBox() {
        if (!ConfigData.debugMode) {
            return;
        }
        if (debugBox == null) {
            return;
        }
        Vec3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double x = view.field_72450_a;
        double y = view.field_72448_b;
        double z = view.field_72449_c;
        GlStateManager.depthMask((boolean)false);
        GlStateManager.disableTexture();
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        GlStateManager.disableBlend();
        WorldRenderer.func_189694_a((double)(ClientEvents.debugBox.field_72340_a - x), (double)(ClientEvents.debugBox.field_72338_b - y), (double)(ClientEvents.debugBox.field_72339_c - z), (double)(ClientEvents.debugBox.field_72336_d - x), (double)(ClientEvents.debugBox.field_72337_e - y), (double)(ClientEvents.debugBox.field_72334_f - z), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.enableTexture();
        GlStateManager.enableLighting();
        GlStateManager.enableCull();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        if (--time <= 0) {
            debugBox = null;
        }
    }

    public static void queueRenderBox(AxisAlignedBB aabb) {
        debugBox = aabb;
        time = 500;
    }

    public static void debugScreen(AbstractDragonEntity dragon) {
        Minecraft.func_71410_x().func_147108_a((Screen)new DebugScreen(dragon));
    }

    public static void bookScreen(ItemStack stack) {
    }

    public static void registerEntityRenders() {
        RenderingRegistry.registerEntityRenderingHandler(OWDrakeEntity.class, OWDrakeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MinutusEntity.class, MinutusRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SilverGliderEntity.class, SilverGliderRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RoostStalkerEntity.class, RoostStalkerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ButterflyLeviathanEntity.class, ButterflyLeviathanRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(DragonFruitDrakeEntity.class, DragonFruitDrakeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(CanariWyvernEntity.class, CanariWyvernRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(DragonEggEntity.class, DragonEggRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MultiPartEntity.class, mgr -> new EntityRenderer<MultiPartEntity>(mgr){

            protected ResourceLocation getEntityTexture(MultiPartEntity entity) {
                return null;
            }
        });
    }
}

