/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost;

import WolfShotz.Wyrmroost.ClientEvents;
import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.multipart.IMultiPartEntity;
import WolfShotz.Wyrmroost.content.items.DrakeArmorItem;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRWorld;
import WolfShotz.Wyrmroost.util.ConfigData;
import WolfShotz.Wyrmroost.util.network.NetworkUtils;
import com.google.common.collect.Streams;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class CommonEvents {
    public static void onModConstruction(IEventBus bus) {
        bus.addListener(CommonEvents::commonSetup);
        bus.addListener(CommonEvents::configLoad);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEvents.onModConstruction(bus));
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(CommonEvents.class);
        DeferredWorkQueue.runLater(WRWorld::setupWorldGen);
        DeferredWorkQueue.runLater(WREntities::registerEntityWorldSpawns);
        NetworkUtils.registerMessages();
    }

    public static void configLoad(ModConfig.ModConfigEvent evt) {
        if (evt.getConfig().getSpec() == ConfigData.CommonConfig.COMMON_SPEC) {
            ConfigData.CommonConfig.reload();
        }
        if (evt.getConfig().getSpec() == ConfigData.ClientConfig.CLIENT_SPEC) {
            ConfigData.ClientConfig.reload();
        }
    }

    @SubscribeEvent
    public static void debugStick(PlayerInteractEvent.EntityInteract evt) {
        if (!ConfigData.debugMode) {
            return;
        }
        PlayerEntity player = evt.getPlayer();
        ItemStack stack = player.func_184586_b(evt.getHand());
        if (stack.func_77973_b() != Items.field_151055_y || !stack.func_200301_q().func_150261_e().equals("Debug Stick")) {
            return;
        }
        evt.setCanceled(true);
        evt.setCancellationResult(ActionResultType.SUCCESS);
        Entity entity = evt.getTarget();
        if (!(entity instanceof AbstractDragonEntity)) {
            return;
        }
        AbstractDragonEntity dragon = (AbstractDragonEntity)entity;
        if (player.func_70093_af()) {
            dragon.tame(true, player);
        } else if (evt.getWorld().field_72995_K) {
            ClientEvents.debugScreen(dragon);
        }
    }

    @SubscribeEvent
    public static void onEntityTrack(PlayerEvent.StartTracking evt) {
        Entity target = evt.getTarget();
        if (target instanceof IMultiPartEntity) {
            IMultiPartEntity entity = (IMultiPartEntity)target;
            entity.iterateParts().forEach(arg_0 -> ((World)target.field_70170_p).func_217376_c(arg_0));
        }
    }

    @SubscribeEvent
    public static void onChangeEquipment(LivingEquipmentChangeEvent evt) {
        if (!(evt.getEntity() instanceof PlayerEntity)) {
            return;
        }
        Iterable armor = evt.getEntity().func_184193_aE();
        boolean full = Streams.stream((Iterable)armor).allMatch(k -> k.func_77973_b() instanceof DrakeArmorItem);
        Streams.stream((Iterable)armor).filter(i -> i.func_77973_b() instanceof DrakeArmorItem).map(i -> (DrakeArmorItem)i.func_77973_b()).forEach(i -> i.setFullSet(full));
    }
}

