/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon;

import WolfShotz.Wyrmroost.ClientEvents;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggProperties;
import WolfShotz.Wyrmroost.content.items.CustomSpawnEggItem;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.util.ConfigData;
import WolfShotz.Wyrmroost.util.ModUtils;
import WolfShotz.Wyrmroost.util.QuikMaths;
import WolfShotz.Wyrmroost.util.entityutils.DragonBodyController;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.IAnimatedObject;
import WolfShotz.Wyrmroost.util.network.NetworkUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractDragonEntity
extends TameableEntity
implements IAnimatedObject,
INamedContainerProvider {
    public static final DataParameter<Boolean> GENDER = AbstractDragonEntity.createKey(DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> SPECIAL = AbstractDragonEntity.createKey(DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> FLYING = AbstractDragonEntity.createKey(DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> SLEEPING = AbstractDragonEntity.createKey(DataSerializers.field_187198_h);
    public static final DataParameter<Integer> VARIANT = AbstractDragonEntity.createKey(DataSerializers.field_187192_b);
    public static final DataParameter<Optional<BlockPos>> HOME_POS = AbstractDragonEntity.createKey(DataSerializers.field_187201_k);
    public static final String DATA_HOME_POS = "HomePos";
    public static final String DATA_SPECIAL = "special";
    public static final String DATA_SLEEPING = "sleeping";
    public static final String DATA_INV = "Inv";
    public int animationTick;
    public Animation animation = NO_ANIMATION;
    public static Animation SLEEP_ANIMATION;
    public static Animation WAKE_ANIMATION;
    public int shouldFlyThreshold = 3;
    public int sleepCooldown;
    public final LazyOptional<ItemStackHandler> invHandler;
    public List<String> immunes = Lists.newArrayList();
    public DragonEggProperties eggProperties;

    public AbstractDragonEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.func_70903_f(false);
        this.invHandler = this.createInv();
        this.eggProperties = this.createEggProperties();
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
    }

    protected BodyController func_184650_s() {
        return new DragonBodyController(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPECIAL, (Object)(this.getSpecialChances() != 0 && this.func_70681_au().nextInt(this.getSpecialChances()) == 0 ? 1 : 0));
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(HOME_POS, Optional.empty());
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a(DATA_SPECIAL, this.isSpecial());
        nbt.func_74757_a(DATA_SLEEPING, this.func_70608_bn());
        this.invHandler.ifPresent(i -> nbt.func_218657_a(DATA_INV, (INBT)i.serializeNBT()));
        this.getHomePos().ifPresent(pos -> nbt.func_74772_a(DATA_HOME_POS, pos.func_218275_a()));
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setSpecial(nbt.func_74767_n(DATA_SPECIAL));
        this.field_70180_af.func_187227_b(SLEEPING, (Object)nbt.func_74767_n(DATA_SLEEPING));
        this.invHandler.ifPresent(i -> i.deserializeNBT(nbt.func_74775_l(DATA_INV)));
        if (nbt.func_74764_b(DATA_HOME_POS)) {
            this.setHomePos(BlockPos.func_218283_e((long)nbt.func_74763_f(DATA_HOME_POS)));
        }
    }

    public boolean getGender() {
        try {
            return (Boolean)this.field_70180_af.func_187225_a(GENDER);
        }
        catch (NullPointerException ignore) {
            return true;
        }
    }

    public void setGender(boolean sex) {
        this.field_70180_af.func_187227_b(GENDER, (Object)sex);
    }

    public boolean isSpecial() {
        return (Boolean)this.field_70180_af.func_187225_a(SPECIAL);
    }

    public void setSpecial(boolean albino) {
        this.field_70180_af.func_187227_b(SPECIAL, (Object)albino);
    }

    public int getSpecialChances() {
        return this.field_70146_Z.nextInt(400) + 100;
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean fly) {
        if (this.isFlying() == fly) {
            return;
        }
        this.func_70661_as().func_75499_g();
        if (this.canFly() && fly && this.liftOff()) {
            this.field_70699_by = new FlyingPathNavigator((MobEntity)this, this.field_70170_p);
            this.field_70180_af.func_187227_b(FLYING, (Object)true);
        } else {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.field_70180_af.func_187227_b(FLYING, (Object)false);
        }
    }

    public int getVariant() {
        try {
            return (Integer)this.field_70180_af.func_187225_a(VARIANT);
        }
        catch (NullPointerException ignore) {
            return 0;
        }
    }

    public void setVariant(int variant) {
        if (this.getVariant() == variant) {
            return;
        }
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public void setSleeping(boolean sleep) {
        if (this.func_70608_bn() == sleep || this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleep);
        this.clearAI();
        if (!sleep) {
            this.sleepCooldown = 350;
        }
        if (SLEEP_ANIMATION != null && WAKE_ANIMATION != null && this.noActiveAnimation()) {
            NetworkUtils.sendAnimationPacket(this, sleep ? SLEEP_ANIMATION : WAKE_ANIMATION);
        }
        this.func_213323_x_();
    }

    public void setSit(boolean sitting) {
        if (this.func_70906_o() == sitting) {
            return;
        }
        if (this.func_70608_bn()) {
            this.setSleeping(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70911_d.func_75270_a(sitting);
            this.clearAI();
        }
        super.func_70904_g(sitting);
        this.func_213323_x_();
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        if (this.isAngry() == angry) {
            return;
        }
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public void setHomePos(Optional<BlockPos> homePos) {
        this.field_70180_af.func_187227_b(HOME_POS, homePos);
    }

    public void setHomePos(BlockPos homePos) {
        this.setHomePos(Optional.of(homePos));
    }

    public Optional<BlockPos> getHomePos() {
        return (Optional)this.field_70180_af.func_187225_a(HOME_POS);
    }

    public ItemStackHandler getInvHandler() {
        return (ItemStackHandler)this.invHandler.orElse((Object)new ItemStackHandler());
    }

    public LazyOptional<ItemStackHandler> createInv() {
        return LazyOptional.empty();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70613_aW()) {
            boolean flying;
            boolean bl = flying = this.canFly() && this.getAltitude(true) > (double)this.shouldFlyThreshold && this.func_184187_bx() == null;
            if (flying != this.isFlying()) {
                this.setFlying(flying);
            }
            this.handleSleep();
            if (this.func_70608_bn() && this.getHomePos().isPresent() && this.func_213383_dH() && this.func_70681_au().nextInt(150) == 0) {
                this.func_70691_i(1.0f);
            }
        } else if (this.isSpecial()) {
            this.doSpecialEffects();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getAnimation() != NO_ANIMATION) {
            ++this.animationTick;
            if (this.animationTick >= this.animation.getDuration()) {
                this.setAnimation(NO_ANIMATION);
            }
        }
    }

    public void func_70098_U() {
        super.func_70098_U();
        Entity entity = this.func_184187_bx();
        if (entity == null || !entity.func_70089_S()) {
            this.func_184210_p();
            return;
        }
        this.func_213317_d(Vec3d.field_186680_a);
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            int index = player.func_184188_bt().indexOf(this);
            if (player.func_70093_af() && !player.field_71075_bZ.field_75100_b || this.func_70090_H() || index > 2) {
                this.func_184210_p();
                return;
            }
            this.field_70127_C = this.field_70125_A = player.field_70125_A / 2.0f;
            this.field_70126_B = this.field_70177_z = player.field_70177_z;
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.func_70101_b(player.field_70759_as, this.field_70125_A);
            double baseOffset = (double)this.func_213311_cf() * 0.8;
            double xOffset = index == 1 ? baseOffset : (index == 2 ? -baseOffset : 0.0);
            double yOffset = index == 0 ? 1.85 : 1.38;
            double zOffset = 0.0;
            if (player.func_184613_cA()) {
                if (!this.canFly()) {
                    this.func_184210_p();
                    return;
                }
                xOffset *= 4.0;
                this.setFlying(true);
            }
            Vec3d pos = QuikMaths.calculateYawAngle(player.field_70761_aq, xOffset, zOffset).func_72441_c(player.field_70165_t, player.field_70163_u + yOffset, player.field_70161_v);
            this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    public boolean processInteract(PlayerEntity player, Hand hand, ItemStack stack) {
        if (stack.func_111282_a(player, (LivingEntity)this, hand)) {
            return true;
        }
        if (!this.func_70631_g_() && this.func_204701_dC() && this.func_70877_b(stack) && this.func_152114_e((LivingEntity)player) && !player.func_70093_af()) {
            this.eat(stack);
            this.func_146082_f(player);
            return true;
        }
        if (this.isFoodItem(stack) && this.func_70909_n()) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.eat(stack);
                return true;
            }
            if (this.func_70631_g_()) {
                this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
                this.eat(stack);
                return true;
            }
        }
        return false;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (!this.processInteract(player, hand, player.func_184586_b(hand))) {
            return false;
        }
        this.setSleeping(false);
        return true;
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.invHandler.map(i -> i.getStackInSlot(slot)).orElse((Object)ItemStack.field_190927_a);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.invHandler.ifPresent(i -> i.setStackInSlot(slot, stack));
    }

    public void attackInFront(int radius) {
        AxisAlignedBB size = this.func_174813_aQ();
        AxisAlignedBB aabb = size.func_191194_a(QuikMaths.calculateYawAngle(this.field_70761_aq, 0.0, size.func_216364_b())).func_186662_g((double)radius);
        this.attackInAABB(aabb);
    }

    public void attackInAABB(AxisAlignedBB aabb) {
        List livingEntities = this.field_70170_p.func_175647_a(LivingEntity.class, aabb, found -> {
            if (found == this) return false;
            if (!this.func_184188_bt().stream().noneMatch(arg_0 -> ((LivingEntity)found).equals(arg_0))) return false;
            return true;
        });
        if (ConfigData.debugMode && this.field_70170_p.field_72995_K) {
            ClientEvents.queueRenderBox(aabb);
        }
        if (livingEntities.isEmpty()) {
            return;
        }
        livingEntities.forEach(this::func_70652_k);
    }

    public boolean func_70652_k(Entity entity) {
        if (entity == this.func_70902_q()) {
            return false;
        }
        if (entity instanceof TameableEntity && ((TameableEntity)entity).func_70902_q() == this.func_70902_q()) {
            return false;
        }
        return super.func_70652_k(entity);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!this.func_70909_n()) {
            return true;
        }
        if (target instanceof TameableEntity) {
            TameableEntity tamable = (TameableEntity)target;
            return tamable.func_70902_q() == null || tamable.func_70902_q() != owner;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.setSleeping(false);
        this.setSit(false);
        return super.func_70097_a(source, amount);
    }

    public void doSpecialEffects() {
        if (this.field_70173_aa % 25 == 0) {
            double x = this.field_70165_t + (double)this.func_213311_cf() * (this.func_70681_au().nextGaussian() * 0.5);
            double y = this.field_70163_u + (double)this.func_213302_cg() * this.func_70681_au().nextDouble();
            double z = this.field_70161_v + (double)this.func_213311_cf() * (this.func_70681_au().nextGaussian() * 0.5);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, 0.0, (double)0.05f, 0.0);
        }
    }

    public boolean func_184202_aL() {
        return super.func_184202_aL();
    }

    protected void func_213345_d(DamageSource src) {
        this.invHandler.ifPresent(i -> {
            for (int index = 0; index < i.getSlots(); ++index) {
                this.func_199701_a_(i.getStackInSlot(index));
            }
        });
        super.func_213345_d(src);
    }

    public void tryTeleportToOwner() {
        LivingEntity owner = this.func_70902_q();
        if (owner == null) {
            return;
        }
        this.tryTeleportToPos(owner.func_180425_c().func_177982_a(-2, 0, -2));
    }

    public boolean tryTeleportToPos(BlockPos pos) {
        for (int i = 0; i <= 4; ++i) {
            for (int l = 0; l <= 4; ++l) {
                if (i >= 1 && l >= 1 && i <= 3 && l <= 3 || !this.field_70170_p.func_195586_b((Entity)this, this.func_174813_aQ()) || !this.isFlying() && this.field_70170_p.func_180495_p(pos.func_177977_b()).isAir((IBlockReader)this.field_70170_p, pos)) continue;
                this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                this.clearAI();
                return true;
            }
        }
        this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0);
        this.clearAI();
        return false;
    }

    public boolean func_213383_dH() {
        return this.func_213389_a(this.func_180425_c());
    }

    public boolean func_213389_a(BlockPos pos) {
        return this.getHomePos().map(home -> home.func_177951_i((Vec3i)pos) <= (double)(ConfigData.homeRadius * ConfigData.homeRadius)).orElse(true);
    }

    public void func_70101_b(float yaw, float pitch) {
        this.field_70177_z = yaw % 360.0f;
        this.field_70125_A = pitch % 360.0f;
    }

    public double getAltitude(boolean capThreshold) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_180425_c());
        if (capThreshold) {
            for (int i = 0; i <= this.shouldFlyThreshold + 1 && !this.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a(); ++i) {
                pos.func_196234_d(0, -1, 0);
            }
        } else {
            while (pos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a()) {
                pos.func_196234_d(0, -1, 0);
            }
        }
        return this.field_70163_u - (double)pos.func_177956_o();
    }

    public void eat(@Nullable ItemStack stack) {
        if (stack != null && !stack.func_190926_b()) {
            stack.func_190918_g(1);
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(Math.max((int)this.func_110138_aP() / 5, 6));
            }
            if (stack.func_77973_b().func_219971_r()) {
                try {
                    List effects = Objects.requireNonNull(stack.func_77973_b().func_219967_s()).func_221464_f();
                    if (!effects.isEmpty() && effects.stream().noneMatch(e -> e.getLeft() == null)) {
                        effects.forEach(e -> this.func_195064_c((EffectInstance)e.getLeft()));
                    }
                }
                catch (Exception effects) {
                    // empty catch block
                }
            }
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            if (this.field_70170_p.field_72995_K) {
                Vec3d mouth = this.getApproximateMouthPos();
                for (int i = 0; i < 11; ++i) {
                    Vec3d vec3d1 = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1);
                    vec3d1 = vec3d1.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                    vec3d1 = vec3d1.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), mouth.field_72450_a, mouth.field_72448_b, mouth.field_72449_c, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
                }
            }
        }
    }

    public boolean tame(boolean tame, @Nullable PlayerEntity tamer) {
        if (this.func_70909_n()) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (tame && tamer != null && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)tamer)) {
                this.func_193101_c(tamer);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_70606_j(this.func_110138_aP());
                this.func_70908_e(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                return true;
            }
            this.func_70908_e(false);
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
        }
        return false;
    }

    public void func_70691_i(float healAmount) {
        super.func_70691_i(healAmount);
        if (!this.field_70170_p.field_72995_K) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197632_y, this.field_70165_t, this.field_70163_u, this.field_70161_v, (int)this.func_213311_cf() * 5, (double)this.func_213311_cf() * 0.85, (double)this.func_213302_cg() * 0.85, (double)this.func_213311_cf() * 0.85, 0.0);
        }
    }

    public int func_184649_cE() {
        return this.isFlying() ? 10 : super.func_184649_cE();
    }

    public boolean isRiding() {
        return this.func_184187_bx() != null;
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        CompoundNBT tag = new CompoundNBT();
        ItemStack eggStack = new ItemStack((IItemProvider)WRItems.DRAGON_EGG.get());
        tag.func_74778_a("dragonType", EntityType.func_200718_a((EntityType)this.func_200600_R()).toString());
        tag.func_74768_a("hatchTime", this.getEggProperties().getHatchTime());
        eggStack.func_77982_d(tag);
        ItemEntity eggItem = new ItemEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, eggStack);
        eggItem.func_213293_j(0.0, (double)(this.func_213302_cg() / 3.0f), 0.0);
        this.field_70170_p.func_217376_c((Entity)eggItem);
        return null;
    }

    public void handleSleep() {
        if (!this.func_70608_bn() && --this.sleepCooldown <= 0 && !this.field_70170_p.func_72935_r() && (!this.func_70909_n() || this.func_70906_o() && this.func_213383_dH()) && this.isIdling() && this.func_70681_au().nextInt(300) == 0) {
            this.setSleeping(true);
        } else if (this.func_70608_bn() && this.field_70170_p.func_72935_r() && this.func_70681_au().nextInt(150) == 0) {
            this.setSleeping(false);
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184179_bs() == passenger) {
            this.clearAI();
        }
    }

    @Nullable
    public PlayerEntity getControllingPlayer() {
        Entity passenger = this.func_184179_bs();
        if (passenger instanceof PlayerEntity) {
            return (PlayerEntity)passenger;
        }
        return null;
    }

    public void clearAI() {
        this.field_70703_bu = false;
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
    }

    public boolean isIdling() {
        return this.func_70661_as().func_75500_f() && this.func_70638_az() == null && !this.func_184207_aI() && !this.isAngry() && !this.func_203005_aq() && !this.isFlying();
    }

    public Vec3d getApproximateMouthPos() {
        return QuikMaths.calculateYawAngle(this.field_70761_aq, 0.0, (double)(this.func_213311_cf() / 2.0f) + 0.5).func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() - 0.15, this.field_70161_v);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        Optional<CustomSpawnEggItem> egg = CustomSpawnEggItem.EGG_TYPES.stream().filter(e -> e.type.get() == this.func_200600_R()).findFirst();
        return egg.map(ItemStack::new).orElse(ItemStack.field_190927_a);
    }

    public List<Entity> getEntitiesNearby(double radius, Predicate<Entity> filter) {
        return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(radius), e -> this.func_184188_bt().stream().noneMatch(arg_0 -> ((Entity)e).equals(arg_0)) && filter.test((Entity)e));
    }

    public List<Entity> getEntitiesNearby(double radius) {
        return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(radius), e -> this.func_184188_bt().stream().noneMatch(arg_0 -> ((Entity)e).equals(arg_0)));
    }

    public void addMotion(Vec3d vec3d) {
        this.func_213317_d(this.func_213322_ci().func_178787_e(vec3d));
    }

    public void addMotion(double x, double y, double z) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(x, y, z));
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        this.playSound(soundIn, volume, pitch, false);
    }

    public void playSound(SoundEvent sound, float volume, float pitch, boolean local) {
        if (this.func_174814_R()) {
            return;
        }
        volume *= this.func_70599_aP();
        pitch *= this.func_70647_i();
        if (local) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, this.func_184176_by(), volume, pitch, false);
        } else {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, this.func_184176_by(), volume, pitch);
        }
    }

    public boolean func_174814_R() {
        return super.func_174814_R() || this.func_70608_bn();
    }

    public void setImmune(DamageSource source) {
        this.immunes.add(source.func_76355_l());
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || !this.immunes.isEmpty() && this.immunes.contains(source.func_76355_l());
    }

    public boolean func_184186_bw() {
        return this.func_184179_bs() != null && this.func_152114_e((LivingEntity)this.func_184179_bs());
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void performGenericAttack() {
    }

    public void performAltAttack(boolean shouldContinue) {
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.func_70608_bn();
    }

    public boolean canFly() {
        return !this.func_70631_g_() && !this.func_110167_bD();
    }

    protected float func_175134_bD() {
        return this.canFly() ? 1.25f : super.func_175134_bD();
    }

    public boolean liftOff() {
        if (!this.canFly()) {
            return false;
        }
        int i = 1;
        while ((float)i < (float)this.shouldFlyThreshold / 2.5f + 1.0f) {
            if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177981_b((int)this.func_213302_cg() + i)).func_185904_a().func_76230_c()) {
                return false;
            }
            ++i;
        }
        this.setSit(false);
        this.setSleeping(false);
        this.func_70664_aZ();
        return true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.canFly()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    public void setMountCameraAngles(boolean backView) {
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInv, PlayerEntity player) {
        return null;
    }

    public boolean func_70877_b(ItemStack stack) {
        return this.isFoodItem(stack);
    }

    public boolean isFoodItem(ItemStack stack) {
        if (this.getFoodItems() == null || this.getFoodItems().size() == 0) {
            return false;
        }
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        return this.getFoodItems().contains(stack.func_77973_b());
    }

    public abstract Collection<Item> getFoodItems();

    public DragonEggProperties getEggProperties() {
        if (this.eggProperties == null) {
            ModUtils.L.warn("{} is missing dragon egg properties! Using default values...", (Object)this.func_200600_R().func_212546_e().func_150261_e());
            this.eggProperties = new DragonEggProperties(2.0f, 2.0f, 12000);
        }
        return this.eggProperties;
    }

    public abstract DragonEggProperties createEggProperties();

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        if (animation == null) {
            animation = NO_ANIMATION;
        }
        this.setAnimationTick(0);
        this.animation = animation;
    }

    public boolean noActiveAnimation() {
        return this.getAnimation() == NO_ANIMATION || this.getAnimationTick() == 0;
    }

    public static <T> DataParameter<T> createKey(IDataSerializer<T> serializer) {
        return EntityDataManager.func_187226_a(AbstractDragonEntity.class, serializer);
    }
}

